/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.actions.AbstractDartFileProcessingAction;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.jetbrains.annotations.NotNull;

public class DartStyleAction
extends AbstractDartFileProcessingAction {
    private static final Logger LOG = Logger.getInstance((String)DartStyleAction.class.getName());

    public DartStyleAction() {
        super(DartBundle.message("dart.style.action.name", new Object[0]), DartBundle.message("dart.style.action.description", new Object[0]), null);
    }

    @Override
    @NotNull
    protected String getActionTextForEditor() {
        String string = DartBundle.message("dart.style.action.name", new Object[0]);
        if (string == null) {
            DartStyleAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionTextForFiles() {
        String string = DartBundle.message("dart.style.action.name.ellipsis", new Object[0]);
        if (string == null) {
            DartStyleAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void runOverEditor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Document document;
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DartStyleAction.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            DartStyleAction.$$$reportNull$$$0(4);
        }
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)(document = editor.getDocument()))) {
            return;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int lineLength = DartStyleAction.getRightMargin(project);
        DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
        das.updateFilesContent();
        DartAnalysisServerService.FormatResult formatResult = das.edit_format(psiFile.getVirtualFile(), caretOffset, 0, lineLength);
        if (formatResult == null) {
            DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.failed", new Object[0]), true);
            LOG.warn("Unexpected response from edit_format, formatResult is null");
            return;
        }
        Runnable runnable = () -> {
            List<SourceEdit> edits;
            if (editor == null) {
                DartStyleAction.$$$reportNull$$$0(15);
            }
            if (psiFile == null) {
                DartStyleAction.$$$reportNull$$$0(16);
            }
            if ((edits = formatResult.getEdits()) == null || edits.size() == 0) {
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.already.good", new Object[0]), false);
            } else if (edits.size() == 1) {
                String replacement = StringUtil.convertLineSeparators((String)edits.get(0).getReplacement());
                document.replaceString(0, document.getTextLength(), (CharSequence)replacement);
                int offset = das.getConvertedOffset(psiFile.getVirtualFile(), formatResult.getOffset());
                editor.getCaretModel().moveToOffset(offset);
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.success", new Object[0]), false);
            } else {
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.failed", new Object[0]), true);
                LOG.warn("Unexpected response from edit_format, formatResult.getEdits().size() = " + edits.size());
            }
        };
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                DartStyleAction.$$$reportNull$$$0(14);
            }
            CommandProcessor.getInstance().executeCommand(project, runnable, DartBundle.message("dart.style.action.name", new Object[0]), null);
        });
    }

    @Override
    protected void runOverFiles(@NotNull Project project, @NotNull List<VirtualFile> dartFiles) {
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(5);
        }
        if (dartFiles == null) {
            DartStyleAction.$$$reportNull$$$0(6);
        }
        if (dartFiles.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)DartBundle.message("dart.style.files.no.dart.files", new Object[0]), (String)DartBundle.message("dart.style.action.name", new Object[0]));
            return;
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DartBundle.message("dart.style.files.dialog.question", dartFiles.size()), (String)DartBundle.message("dart.style.action.name", new Object[0]), null) != 0) {
            return;
        }
        DartStyleAction.runDartfmt(project, dartFiles);
    }

    public static void runDartfmt(@NotNull Project project, @NotNull List<VirtualFile> dartFiles) {
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(7);
        }
        if (dartFiles == null) {
            DartStyleAction.$$$reportNull$$$0(8);
        }
        THashMap fileToNewContentMap = new THashMap();
        int lineLength = DartStyleAction.getRightMargin(project);
        Runnable runnable = () -> DartStyleAction.lambda$runDartfmt$2(dartFiles, project, lineLength, (Map)fileToNewContentMap);
        DartAnalysisServerService.getInstance(project).updateFilesContent();
        boolean ok = ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(runnable, DartBundle.message("dart.style.action.name", new Object[0]), true, project);
        if (ok) {
            Runnable onSuccessRunnable = () -> DartStyleAction.lambda$runDartfmt$3(project, (Map)fileToNewContentMap);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    DartStyleAction.$$$reportNull$$$0(10);
                }
                CommandProcessor.getInstance().executeCommand(project, onSuccessRunnable, DartBundle.message("dart.style.action.name", new Object[0]), null);
            });
        }
    }

    private static int getRightMargin(@NotNull Project project) {
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(9);
        }
        return CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)DartLanguage.INSTANCE).RIGHT_MARGIN;
    }

    private static /* synthetic */ void lambda$runDartfmt$3(@NotNull Project project, Map fileToNewContentMap) {
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(11);
        }
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
        for (Map.Entry entry : fileToNewContentMap.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            Document document = FileDocumentManager.getInstance().getDocument(file);
            String newContent = (String)entry.getValue();
            if (document == null || newContent == null) continue;
            document.setText((CharSequence)newContent);
        }
    }

    private static /* synthetic */ void lambda$runDartfmt$2(@NotNull List dartFiles, @NotNull Project project, int lineLength, Map fileToNewContentMap) {
        if (dartFiles == null) {
            DartStyleAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DartStyleAction.$$$reportNull$$$0(13);
        }
        double fraction = 0.0;
        for (VirtualFile virtualFile : dartFiles) {
            DartAnalysisServerService.FormatResult formatResult;
            fraction += 1.0;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setFraction(fraction / (double)dartFiles.size());
                indicator.setText2(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
            }
            if ((formatResult = DartAnalysisServerService.getInstance(project).edit_format(virtualFile, 0, 0, lineLength)) == null || formatResult.getEdits() == null || formatResult.getEdits().size() != 1) continue;
            String replacement = StringUtil.convertLineSeparators((String)formatResult.getEdits().get(0).getReplacement());
            fileToNewContentMap.put(virtualFile, replacement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/actions/DartStyleAction";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTextForEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTextForFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartStyleAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runOverEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runOverFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runDartfmt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runDartfmt$4";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runDartfmt$3";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runDartfmt$2";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverEditor$1";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

