/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.ide.actions.AbstractDartFileProcessingAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;

public class DartSortMembersAction
extends AbstractDartFileProcessingAction {
    private static final Logger LOG = Logger.getInstance((String)DartSortMembersAction.class.getName());

    public DartSortMembersAction() {
        super(DartBundle.message("dart.sort.members.action.name", new Object[0]), DartBundle.message("dart.sort.members.action.description", new Object[0]), null);
    }

    @Override
    @NotNull
    protected String getActionTextForEditor() {
        String string = DartBundle.message("dart.sort.members.action.name", new Object[0]);
        if (string == null) {
            DartSortMembersAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionTextForFiles() {
        String string = DartBundle.message("dart.sort.members.action.name.ellipsis", new Object[0]);
        if (string == null) {
            DartSortMembersAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void runOverEditor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Document document;
        if (project == null) {
            DartSortMembersAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DartSortMembersAction.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            DartSortMembersAction.$$$reportNull$$$0(4);
        }
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)(document = editor.getDocument()))) {
            return;
        }
        String path = psiFile.getVirtualFile().getPath();
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        service.updateFilesContent();
        SourceFileEdit fileEdit = service.edit_sortMembers(path);
        if (fileEdit == null) {
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.failed", new Object[0]), true);
            LOG.warn("Unexpected response from edit_sortMembers, fileEdit is null");
            return;
        }
        List<SourceEdit> edits = fileEdit.getEdits();
        if (edits == null || edits.size() == 0) {
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.already.good", new Object[0]), false);
            return;
        }
        Runnable runnable = () -> {
            if (project == null) {
                DartSortMembersAction.$$$reportNull$$$0(12);
            }
            if (psiFile == null) {
                DartSortMembersAction.$$$reportNull$$$0(13);
            }
            if (editor == null) {
                DartSortMembersAction.$$$reportNull$$$0(14);
            }
            AssistUtils.applySourceEdits(project, psiFile.getVirtualFile(), document, edits, Collections.emptySet());
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.success", new Object[0]), false);
        };
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                DartSortMembersAction.$$$reportNull$$$0(11);
            }
            CommandProcessor.getInstance().executeCommand(project, runnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), null);
        });
    }

    @Override
    protected void runOverFiles(@NotNull Project project, @NotNull List<VirtualFile> dartFiles) {
        if (project == null) {
            DartSortMembersAction.$$$reportNull$$$0(5);
        }
        if (dartFiles == null) {
            DartSortMembersAction.$$$reportNull$$$0(6);
        }
        if (dartFiles.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)DartBundle.message("dart.sort.members.files.no.dart.files", new Object[0]), (String)DartBundle.message("dart.sort.members.action.name", new Object[0]));
            return;
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DartBundle.message("dart.sort.members.files.dialog.question", dartFiles.size()), (String)DartBundle.message("dart.sort.members.action.name", new Object[0]), null) != 0) {
            return;
        }
        HashMap fileToFileEditMap = Maps.newHashMap();
        Runnable runnable = () -> {
            if (dartFiles == null) {
                DartSortMembersAction.$$$reportNull$$$0(9);
            }
            if (project == null) {
                DartSortMembersAction.$$$reportNull$$$0(10);
            }
            double fraction = 0.0;
            for (VirtualFile virtualFile : dartFiles) {
                fraction += 1.0;
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setFraction(fraction / (double)dartFiles.size());
                    indicator.setText2(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
                }
                String path = virtualFile.getPath();
                SourceFileEdit fileEdit = DartAnalysisServerService.getInstance(project).edit_sortMembers(path);
                if (fileEdit == null) continue;
                fileToFileEditMap.put(virtualFile, fileEdit);
            }
        };
        DartAnalysisServerService.getInstance(project).updateFilesContent();
        boolean ok = ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(runnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), true, project);
        if (ok) {
            Runnable onSuccessRunnable = () -> {
                if (project == null) {
                    DartSortMembersAction.$$$reportNull$$$0(8);
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                for (Map.Entry entry : fileToFileEditMap.entrySet()) {
                    VirtualFile file = (VirtualFile)entry.getKey();
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    SourceFileEdit fileEdit = (SourceFileEdit)entry.getValue();
                    if (document == null) continue;
                    AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), Collections.emptySet());
                }
            };
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    DartSortMembersAction.$$$reportNull$$$0(7);
                }
                CommandProcessor.getInstance().executeCommand(project, onSuccessRunnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), null);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTextForEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTextForFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runOverEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runOverFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverFiles$4";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverFiles$3";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverFiles$2";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverEditor$1";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runOverEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

