/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseActiveTabAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartPubActionBase
extends AnAction
implements DumbAware {
    public static final String PUB_ENV_VAR_NAME = "PUB_ENVIRONMENT";
    private static final String GROUP_DISPLAY_ID = "Dart Pub Tool";
    private static final Key<PubToolWindowContentInfo> PUB_TOOL_WINDOW_CONTENT_INFO_KEY = Key.create((String)"PUB_TOOL_WINDOW_CONTENT_INFO_KEY");
    private static final AtomicBoolean ourInProgress = new AtomicBoolean(false);

    public static String getPubEnvValue() {
        String existingVar = System.getenv(PUB_ENV_VAR_NAME);
        if (existingVar == null) {
            return DartAnalysisServerService.getClientId();
        }
        return existingVar + ":" + DartAnalysisServerService.getClientId();
    }

    public static boolean isInProgress() {
        return ourInProgress.get();
    }

    public static void setIsInProgress(boolean inProgress) {
        ourInProgress.set(inProgress);
    }

    public void update(@NotNull AnActionEvent e) {
        Pair<Module, VirtualFile> moduleAndPubspec;
        if (e == null) {
            DartPubActionBase.$$$reportNull$$$0(0);
        }
        boolean visible = (moduleAndPubspec = DartPubActionBase.getModuleAndPubspecYamlFile(e)) != null && (!FlutterUtil.isFlutterPluginInstalled() || !FlutterUtil.isFlutterModule((Module)moduleAndPubspec.first));
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !DartPubActionBase.isInProgress());
    }

    @Nullable
    private static Pair<Module, VirtualFile> getModuleAndPubspecYamlFile(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (module != null && psiFile != null && psiFile.getName().equalsIgnoreCase("pubspec.yaml")) {
            VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
            return file != null ? Pair.create((Object)module, (Object)file) : null;
        }
        return null;
    }

    @NotNull
    protected abstract String getTitle(@NotNull VirtualFile var1);

    @Nullable
    protected abstract String[] calculatePubParameters(@NotNull Project var1, @NotNull VirtualFile var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Pair<Module, VirtualFile> moduleAndPubspecYamlFile;
        if (e == null) {
            DartPubActionBase.$$$reportNull$$$0(1);
        }
        if ((moduleAndPubspecYamlFile = DartPubActionBase.getModuleAndPubspecYamlFile(e)) == null) {
            return;
        }
        Module module = (Module)moduleAndPubspecYamlFile.first;
        VirtualFile pubspecYamlFile = (VirtualFile)moduleAndPubspecYamlFile.second;
        this.performPubAction(module, pubspecYamlFile, true);
    }

    public void performPubAction(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile, boolean allowModalDialogs) {
        DartSdk sdk;
        if (module == null) {
            DartPubActionBase.$$$reportNull$$$0(2);
        }
        if (pubspecYamlFile == null) {
            DartPubActionBase.$$$reportNull$$$0(3);
        }
        if ((sdk = DartSdk.getDartSdk(module.getProject())) == null && allowModalDialogs) {
            int answer = Messages.showDialog((Project)module.getProject(), (String)DartBundle.message("dart.sdk.is.not.configured", new Object[0]), (String)this.getTitle(pubspecYamlFile), (String[])new String[]{DartBundle.message("setup.dart.sdk", new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getErrorIcon());
            if (answer != 0) {
                return;
            }
            DartConfigurable.openDartSettings(module.getProject());
            sdk = DartSdk.getDartSdk(module.getProject());
        }
        if (sdk == null) {
            return;
        }
        File pubFile = new File(DartSdkUtil.getPubPath(sdk));
        if (!pubFile.isFile() && allowModalDialogs) {
            int answer = Messages.showDialog((Project)module.getProject(), (String)DartBundle.message("dart.sdk.bad.dartpub.path", pubFile.getPath()), (String)this.getTitle(pubspecYamlFile), (String[])new String[]{DartBundle.message("setup.dart.sdk", new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getErrorIcon());
            if (answer != 0) {
                return;
            }
            DartConfigurable.openDartSettings(module.getProject());
            sdk = DartSdk.getDartSdk(module.getProject());
            if (sdk == null) {
                return;
            }
            pubFile = new File(DartSdkUtil.getPubPath(sdk));
        }
        if (!pubFile.isFile()) {
            return;
        }
        String[] pubParameters = this.calculatePubParameters(module.getProject(), pubspecYamlFile);
        if (pubParameters != null) {
            String flutterRoot;
            GeneralCommandLine command = new GeneralCommandLine().withWorkDirectory(pubspecYamlFile.getParent().getPath());
            if (FlutterUtil.isFlutterModule(module) && (flutterRoot = FlutterUtil.getFlutterRoot(sdk.getHomePath())) != null) {
                command.getEnvironment().put("FLUTTER_ROOT", FileUtil.toSystemDependentName((String)flutterRoot));
            }
            command.setExePath(pubFile.getPath());
            command.addParameters(pubParameters);
            DartPubActionBase.doPerformPubAction(module, pubspecYamlFile, command, this.getTitle(pubspecYamlFile));
        }
    }

    private static void doPerformPubAction(final @NotNull Module module, final @NotNull VirtualFile pubspecYamlFile, @NotNull GeneralCommandLine command, @NotNull String actionTitle) {
        if (module == null) {
            DartPubActionBase.$$$reportNull$$$0(4);
        }
        if (pubspecYamlFile == null) {
            DartPubActionBase.$$$reportNull$$$0(5);
        }
        if (command == null) {
            DartPubActionBase.$$$reportNull$$$0(6);
        }
        if (actionTitle == null) {
            DartPubActionBase.$$$reportNull$$$0(7);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            if (ourInProgress.compareAndSet(false, true)) {
                command.withEnvironment(PUB_ENV_VAR_NAME, DartPubActionBase.getPubEnvValue());
                OSProcessHandler processHandler = new OSProcessHandler(command);
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ourInProgress.set(false);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (module == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (pubspecYamlFile == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (!module.isDisposed()) {
                                DartProjectComponent.excludeBuildAndPackagesFolders(module, pubspecYamlFile);
                                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{pubspecYamlFile.getParent()});
                                if (DartSdkLibUtil.isDartSdkEnabled(module)) {
                                    DartAnalysisServerService.getInstance(module.getProject()).serverReadyForRequest(module.getProject());
                                }
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "module";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pubspecYamlFile";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartPubActionBase$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$processTerminated$0";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                DartPubActionBase.showPubOutputConsole(module, command, processHandler, pubspecYamlFile, actionTitle);
            }
        }
        catch (ExecutionException e) {
            ourInProgress.set(false);
            Notifications.Bus.notify((Notification)new Notification(GROUP_DISPLAY_ID, actionTitle, DartBundle.message("dart.pub.exception", e.getMessage()), NotificationType.ERROR));
        }
    }

    private static void showPubOutputConsole(@NotNull Module module, @NotNull GeneralCommandLine command, @NotNull OSProcessHandler processHandler, @NotNull VirtualFile pubspecYamlFile, @NotNull String actionTitle) {
        ConsoleView console;
        PubToolWindowContentInfo info;
        if (module == null) {
            DartPubActionBase.$$$reportNull$$$0(8);
        }
        if (command == null) {
            DartPubActionBase.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            DartPubActionBase.$$$reportNull$$$0(10);
        }
        if (pubspecYamlFile == null) {
            DartPubActionBase.$$$reportNull$$$0(11);
        }
        if (actionTitle == null) {
            DartPubActionBase.$$$reportNull$$$0(12);
        }
        if ((info = DartPubActionBase.findExistingInfoForCommand(module.getProject(), command)) != null) {
            console = info.console;
            console.clear();
        } else {
            console = DartPubActionBase.createConsole(module.getProject(), pubspecYamlFile);
            info = new PubToolWindowContentInfo(module, pubspecYamlFile, command, actionTitle, console);
            ActionToolbar actionToolbar = DartPubActionBase.createToolWindowActionsBar(info);
            SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
            toolWindowPanel.setContent(console.getComponent());
            toolWindowPanel.setToolbar(actionToolbar.getComponent());
            Content content = ContentFactory.SERVICE.getInstance().createContent(toolWindowPanel.getComponent(), actionTitle, true);
            content.putUserData(PUB_TOOL_WINDOW_CONTENT_INFO_KEY, (Object)info);
            Disposer.register((Disposable)content, (Disposable)console);
            ContentManager contentManager = MessageView.SERVICE.getInstance((Project)module.getProject()).getContentManager();
            DartPubActionBase.removeOldTabs(contentManager);
            contentManager.addContent(content);
            contentManager.setSelectedContent(content);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)module.getProject()).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
            toolWindow.activate(null, true);
        }
        info.rerunPubCommandAction.setProcessHandler(processHandler);
        info.stopProcessAction.setProcessHandler((ProcessHandler)processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                console.print(IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{event.getExitCode()}), ConsoleViewContentType.SYSTEM_OUTPUT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/ide/actions/DartPubActionBase$2", "processTerminated"));
            }
        });
        console.print(DartBundle.message("working.dir.0", FileUtil.toSystemDependentName((String)pubspecYamlFile.getParent().getPath())) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        console.attachToProcess((ProcessHandler)processHandler);
        processHandler.startNotify();
    }

    @Nullable
    private static PubToolWindowContentInfo findExistingInfoForCommand(Project project, @NotNull GeneralCommandLine command) {
        if (command == null) {
            DartPubActionBase.$$$reportNull$$$0(13);
        }
        for (Content content : MessageView.SERVICE.getInstance((Project)project).getContentManager().getContents()) {
            PubToolWindowContentInfo info = (PubToolWindowContentInfo)content.getUserData(PUB_TOOL_WINDOW_CONTENT_INFO_KEY);
            if (info == null || info.command != command) continue;
            return info;
        }
        return null;
    }

    @NotNull
    private static ConsoleView createConsole(@NotNull Project project, @NotNull VirtualFile pubspecYamlFile) {
        if (project == null) {
            DartPubActionBase.$$$reportNull$$$0(14);
        }
        if (pubspecYamlFile == null) {
            DartPubActionBase.$$$reportNull$$$0(15);
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.setViewer(true);
        consoleBuilder.addFilter((Filter)new DartConsoleFilter(project, pubspecYamlFile));
        consoleBuilder.addFilter((Filter)new DartRelativePathsConsoleFilter(project, pubspecYamlFile.getParent().getPath()));
        consoleBuilder.addFilter((Filter)new UrlFilter());
        ConsoleView consoleView = consoleBuilder.getConsole();
        if (consoleView == null) {
            DartPubActionBase.$$$reportNull$$$0(16);
        }
        return consoleView;
    }

    @NotNull
    private static ActionToolbar createToolWindowActionsBar(@NotNull PubToolWindowContentInfo info) {
        if (info == null) {
            DartPubActionBase.$$$reportNull$$$0(17);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        RerunPubCommandAction rerunPubCommandAction = new RerunPubCommandAction(info);
        info.rerunPubCommandAction = rerunPubCommandAction;
        actionGroup.addAction((AnAction)rerunPubCommandAction);
        StopProcessAction stopProcessAction = new StopProcessAction(DartBundle.message("stop.pub.process.action", new Object[0]), DartBundle.message("stop.pub.process.action", new Object[0]), null);
        info.stopProcessAction = stopProcessAction;
        actionGroup.addAction((AnAction)stopProcessAction);
        actionGroup.add(ActionManager.getInstance().getAction("PinActiveTab"));
        CloseActiveTabAction closeContentAction = new CloseActiveTabAction();
        closeContentAction.getTemplatePresentation().setIcon(AllIcons.Actions.Cancel);
        closeContentAction.getTemplatePresentation().setText(UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]));
        actionGroup.add((AnAction)closeContentAction);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DartPubAction", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent(info.console.getComponent());
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            DartPubActionBase.$$$reportNull$$$0(18);
        }
        return actionToolbar;
    }

    private static void removeOldTabs(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            DartPubActionBase.$$$reportNull$$$0(19);
        }
        for (Content content : contentManager.getContents()) {
            if (content.isPinned() || !content.isCloseable() || content.getUserData(PUB_TOOL_WINDOW_CONTENT_INFO_KEY) == null) continue;
            contentManager.removeContent(content, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecYamlFile";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionTitle";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/actions/DartPubActionBase";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartPubActionBase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindowActionsBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performPubAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doPerformPubAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showPubOutputConsole";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInfoForCommand";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowActionsBar";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeOldTabs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RerunPubCommandAction
    extends DumbAwareAction {
        @NotNull
        private final PubToolWindowContentInfo myInfo;
        private OSProcessHandler myProcessHandler;

        public RerunPubCommandAction(@NotNull PubToolWindowContentInfo info) {
            if (info == null) {
                RerunPubCommandAction.$$$reportNull$$$0(0);
            }
            super(DartBundle.message("rerun.pub.command.action.name", new Object[0]), DartBundle.message("rerun.pub.command.action.description", new Object[0]), AllIcons.Actions.Execute);
            this.myInfo = info;
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), info.console.getComponent());
        }

        public void setProcessHandler(@NotNull OSProcessHandler processHandler) {
            if (processHandler == null) {
                RerunPubCommandAction.$$$reportNull$$$0(1);
            }
            this.myProcessHandler = processHandler;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunPubCommandAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(!DartPubActionBase.isInProgress() && this.myProcessHandler != null && this.myProcessHandler.isProcessTerminated());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunPubCommandAction.$$$reportNull$$$0(3);
            }
            DartPubActionBase.doPerformPubAction(this.myInfo.module, this.myInfo.pubspecYamlFile, this.myInfo.command, this.myInfo.actionTitle);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartPubActionBase$RerunPubCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PubToolWindowContentInfo {
        @NotNull
        private final Module module;
        @NotNull
        private final VirtualFile pubspecYamlFile;
        @NotNull
        private final GeneralCommandLine command;
        @NotNull
        private final String actionTitle;
        @NotNull
        private final ConsoleView console;
        private RerunPubCommandAction rerunPubCommandAction;
        private StopProcessAction stopProcessAction;

        public PubToolWindowContentInfo(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile, @NotNull GeneralCommandLine command, @NotNull String actionTitle, @NotNull ConsoleView console) {
            if (module == null) {
                PubToolWindowContentInfo.$$$reportNull$$$0(0);
            }
            if (pubspecYamlFile == null) {
                PubToolWindowContentInfo.$$$reportNull$$$0(1);
            }
            if (command == null) {
                PubToolWindowContentInfo.$$$reportNull$$$0(2);
            }
            if (actionTitle == null) {
                PubToolWindowContentInfo.$$$reportNull$$$0(3);
            }
            if (console == null) {
                PubToolWindowContentInfo.$$$reportNull$$$0(4);
            }
            this.module = module;
            this.pubspecYamlFile = pubspecYamlFile;
            this.command = command;
            this.actionTitle = actionTitle;
            this.console = console;
        }

        public boolean equals(Object o) {
            return o instanceof PubToolWindowContentInfo && this.command == ((PubToolWindowContentInfo)o).command;
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pubspecYamlFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/ide/actions/DartPubActionBase$PubToolWindowContentInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

