/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class DartInheritorsSearcher
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters parameters, @NotNull Processor<PsiElement> consumer) {
        if (parameters == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(1);
        }
        Ref fileRef = Ref.create();
        Ref offsetRef = Ref.create();
        Ref componentTypeRef = Ref.create();
        DartInheritorsSearcher.prepare(parameters, (Ref<VirtualFile>)fileRef, (Ref<Integer>)offsetRef, (Ref<DartComponentType>)componentTypeRef);
        if (fileRef.isNull() || offsetRef.isNull() || componentTypeRef.isNull()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (parameters == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(34);
            }
            if (consumer == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(35);
            }
            List hierarchyItems = (List)CachedValuesManager.getCachedValue((PsiElement)parameters.getElement(), () -> {
                if (parameters == null) {
                    DartInheritorsSearcher.$$$reportNull$$$0(36);
                }
                DartAnalysisServerService das = DartAnalysisServerService.getInstance(parameters.getElement().getProject());
                List<TypeHierarchyItem> items = das.search_getTypeHierarchy((VirtualFile)fileRef.get(), (Integer)offsetRef.get(), false);
                return new CachedValueProvider.Result(items, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            List<DartComponent> components = componentTypeRef.get() == DartComponentType.CLASS ? DartInheritorsSearcher.getSubClasses(parameters.getElement().getProject(), parameters.getScope(), hierarchyItems) : DartInheritorsSearcher.getSubMembers(parameters.getElement().getProject(), parameters.getScope(), hierarchyItems);
            for (DartComponent component : components) {
                consumer.process((Object)component);
            }
        });
    }

    private static void prepare(@NotNull DefinitionsScopedSearch.SearchParameters parameters, @NotNull Ref<VirtualFile> fileRef, @NotNull Ref<Integer> offsetRef, @NotNull Ref<DartComponentType> componentTypeRef) {
        if (parameters == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (fileRef == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if (offsetRef == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(4);
        }
        if (componentTypeRef == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile file;
            PsiElement element;
            if (parameters == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(30);
            }
            if (fileRef == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(31);
            }
            if (offsetRef == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(32);
            }
            if (componentTypeRef == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(33);
            }
            if ((element = parameters.getElement()).getLanguage() != DartLanguage.INSTANCE) {
                return;
            }
            DartComponentType componentType = DartComponentType.typeOf(element);
            if (componentType != DartComponentType.CLASS && componentType != DartComponentType.METHOD && componentType != DartComponentType.OPERATOR) {
                return;
            }
            DartComponentName componentName = element instanceof DartComponentName ? (DartComponentName)element : (element instanceof DartComponent ? ((DartComponent)element).getComponentName() : null);
            VirtualFile virtualFile = file = componentName == null ? null : DartResolveUtil.getRealVirtualFile(componentName.getContainingFile());
            if (file != null) {
                fileRef.set((Object)file);
                offsetRef.set((Object)componentName.getTextRange().getStartOffset());
                componentTypeRef.set((Object)componentType);
            }
        });
    }

    @NotNull
    public static List<DartComponent> getSubClasses(@NotNull Project project, @NotNull SearchScope scope, @NotNull List<TypeHierarchyItem> hierarchyItems) {
        if (project == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(7);
        }
        if (hierarchyItems == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(8);
        }
        if (hierarchyItems.isEmpty()) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<DartComponent> result = new ArrayList<DartComponent>(hierarchyItems.size());
        DartInheritorsSearcher.addSubClasses(project, scope, Sets.newHashSet(), hierarchyItems, result, hierarchyItems.get(0), false);
        ArrayList<DartComponent> arrayList = result;
        if (arrayList == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<DartComponent> getSubMembers(@NotNull Project project, @NotNull SearchScope scope, @NotNull List<TypeHierarchyItem> hierarchyItems) {
        if (project == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(12);
        }
        if (hierarchyItems == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(13);
        }
        if (hierarchyItems.isEmpty()) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                DartInheritorsSearcher.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<DartComponent> result = new ArrayList<DartComponent>(hierarchyItems.size());
        DartInheritorsSearcher.addSubMembers(project, scope, Sets.newHashSet(), hierarchyItems, result, hierarchyItems.get(0), false);
        ArrayList<DartComponent> arrayList = result;
        if (arrayList == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addSubClasses(@NotNull Project project, @NotNull SearchScope scope, @NotNull Set<TypeHierarchyItem> visited, @NotNull List<TypeHierarchyItem> hierarchyItems, @NotNull List<DartComponent> components, @NotNull TypeHierarchyItem currentItem, boolean addItem) {
        Element element;
        Location location;
        DartComponent component;
        if (project == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(17);
        }
        if (visited == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(18);
        }
        if (hierarchyItems == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(19);
        }
        if (components == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(20);
        }
        if (currentItem == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(21);
        }
        if (!visited.add(currentItem)) {
            return;
        }
        if (addItem && (component = DartHierarchyUtil.findDartComponent(project, location = (element = currentItem.getClassElement()).getLocation())) != null && DartInheritorsSearcher.isInScope(scope, (PsiElement)component)) {
            components.add(component);
        }
        for (int subIndex : currentItem.getSubclasses()) {
            TypeHierarchyItem subItem = hierarchyItems.get(subIndex);
            DartInheritorsSearcher.addSubClasses(project, scope, visited, hierarchyItems, components, subItem, true);
        }
    }

    private static void addSubMembers(@NotNull Project project, @NotNull SearchScope scope, @NotNull Set<TypeHierarchyItem> visited, @NotNull List<TypeHierarchyItem> hierarchyItems, @NotNull List<DartComponent> components, @NotNull TypeHierarchyItem currentItem, boolean addItem) {
        Location location;
        DartComponent component;
        Element element;
        if (project == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(23);
        }
        if (visited == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(24);
        }
        if (hierarchyItems == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(25);
        }
        if (components == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(26);
        }
        if (currentItem == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(27);
        }
        if (!visited.add(currentItem)) {
            return;
        }
        if (addItem && (element = currentItem.getMemberElement()) != null && (component = DartHierarchyUtil.findDartComponent(project, location = element.getLocation())) != null && DartInheritorsSearcher.isInScope(scope, (PsiElement)component)) {
            components.add(component);
        }
        for (int subIndex : currentItem.getSubclasses()) {
            TypeHierarchyItem subItem = hierarchyItems.get(subIndex);
            DartInheritorsSearcher.addSubMembers(project, scope, visited, hierarchyItems, components, subItem, true);
        }
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        VirtualFile file;
        if (scope == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(28);
        }
        if (element == null) {
            DartInheritorsSearcher.$$$reportNull$$$0(29);
        }
        if ((file = element.getContainingFile().getVirtualFile()) == null) {
            return false;
        }
        return scope.contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRef";
                break;
            }
            case 4: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetRef";
                break;
            }
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentTypeRef";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyItems";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentItem";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClasses";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSubClasses";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubMembers";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSubClasses";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addSubMembers";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepare$2";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processQuery$1";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

