/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class DartWritingAccessProvider
implements NonProjectFileWritingAccessExtension {
    private final Project myProject;

    public DartWritingAccessProvider(Project project) {
        this.myProject = project;
    }

    public boolean isNotWritable(@NotNull VirtualFile file) {
        if (file == null) {
            DartWritingAccessProvider.$$$reportNull$$$0(0);
        }
        return DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(this.myProject, file);
    }

    public static boolean isInDartSdkOrDartPackagesFolder(@NotNull PsiFile psiFile) {
        VirtualFile vFile;
        if (psiFile == null) {
            DartWritingAccessProvider.$$$reportNull$$$0(1);
        }
        return (vFile = psiFile.getOriginalFile().getVirtualFile()) != null && DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(psiFile.getProject(), vFile);
    }

    public static boolean isInDartSdkOrDartPackagesFolder(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex fileIndex;
        if (project == null) {
            DartWritingAccessProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            DartWritingAccessProvider.$$$reportNull$$$0(3);
        }
        if ((fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInLibraryClasses(file) && !fileIndex.isInContent(file)) {
            return true;
        }
        return fileIndex.isExcluded(file) || fileIndex.isInContent(file) && DartWritingAccessProvider.isInDartPackagesFolder(fileIndex, file);
    }

    private static boolean isInDartPackagesFolder(ProjectFileIndex fileIndex, VirtualFile file) {
        VirtualFile parent = file;
        while ((parent = parent.getParent()) != null && fileIndex.isInContent(parent)) {
            if (!"packages".equals(parent.getName())) continue;
            return VfsUtilCore.findRelativeFile((String)"../pubspec.yaml", (VirtualFile)parent) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/DartWritingAccessProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotWritable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInDartSdkOrDartPackagesFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

