/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.pubServer.PubServerManager;
import com.jetbrains.lang.dart.pubServer.PubServerPathHandlerKt;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManagerImpl;

final class DartFileUrlMapper
extends FileUrlMapper {
    private static final String SDK_URL_MARKER = "/packages/$sdk/lib/";
    private static final String PACKAGE_URL_MARKER = "/packages/";
    private static final String DART_SDK_JS = "dart_sdk.js";
    private static final LightVirtualFile DART_SDK_JS_STUB = new LightVirtualFile("dart_sdk.js", (CharSequence)"// Dart SDK");

    DartFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        DartUrlResolver urlResolver;
        String dartUri;
        Pair<VirtualFile, String> servedDirAndPath;
        if (file == null) {
            DartFileUrlMapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DartFileUrlMapper.$$$reportNull$$$0(1);
        }
        if (currentAuthority == null || file.getFileType() != DartFileType.INSTANCE) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                DartFileUrlMapper.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (ProjectFileIndex.getInstance((Project)project).isInContent(file) && (servedDirAndPath = PubServerPathHandlerKt.getServedDirAndPathForPubServer(project, file)) != null) {
            String pubAuthority;
            VirtualFile servedDir = (VirtualFile)servedDirAndPath.first;
            String path = (String)servedDirAndPath.second;
            String string = pubAuthority = BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)currentAuthority) ? PubServerManager.getInstance(project).getPubServerAuthorityForServedDir(servedDir) : currentAuthority;
            if (pubAuthority != null) {
                List<Url> list = Collections.singletonList(Urls.newHttpUrl((String)pubAuthority, (String)path));
                if (list == null) {
                    DartFileUrlMapper.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        if (!(dartUri = (urlResolver = DartUrlResolver.getInstance(project, file)).getDartUrlForFile(file)).startsWith("package:")) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                DartFileUrlMapper.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)currentAuthority)) {
            SmartList result = new SmartList();
            VirtualFile pubspec = urlResolver.getPubspecYamlFile();
            VirtualFile dartRoot = pubspec != null ? pubspec.getParent() : null;
            Collection<String> authorities = dartRoot != null ? PubServerManager.getInstance(project).getAlivePubServerAuthoritiesForDartRoot(pubspec.getParent()) : PubServerManager.getInstance(project).getAllAlivePubServerAuthorities();
            for (String pubAuthority : authorities) {
                String pubUrlPath = PACKAGE_URL_MARKER + dartUri.substring("package:".length());
                result.add(Urls.newHttpUrl((String)pubAuthority, (String)pubUrlPath));
            }
            SmartList smartList = result;
            if (smartList == null) {
                DartFileUrlMapper.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        String urlPath = PACKAGE_URL_MARKER + dartUri.substring("package:".length());
        List<Url> list = Collections.singletonList(Urls.newHttpUrl((String)currentAuthority, (String)urlPath));
        if (list == null) {
            DartFileUrlMapper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            DartFileUrlMapper.$$$reportNull$$$0(7);
        }
        if (project == null) {
            DartFileUrlMapper.$$$reportNull$$$0(8);
        }
        String scheme = url.getScheme();
        String authority = url.getAuthority();
        String path = url.getPath();
        if ("dart".equals(scheme)) {
            return DartUrlResolver.findFileInDartSdkLibFolder(project, DartSdk.getDartSdk(project), "dart:" + path);
        }
        if ("package".equals(scheme)) {
            String packageUri = "package:" + path;
            VirtualFile contextFile = DartFileUrlMapper.findContextFile(project, requestor);
            if (contextFile != null) {
                return (VirtualFile)ReadAction.compute(() -> {
                    if (project == null) {
                        DartFileUrlMapper.$$$reportNull$$$0(16);
                    }
                    return DartUrlResolver.getInstance(project, contextFile).findFileByDartUrl(packageUri);
                });
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return DumbService.getInstance((Project)project).isDumb() ? null : DartFileUrlMapper.findFileInAnyPackagesFolder(project, packageUri);
            }
            return (VirtualFile)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    DartFileUrlMapper.$$$reportNull$$$0(15);
                }
                return DartFileUrlMapper.findFileInAnyPackagesFolder(project, packageUri);
            });
        }
        if ("http".equalsIgnoreCase(scheme) || scheme == null && authority == null) {
            VirtualFile contextFile;
            if (path.equals("/dart_sdk.js")) {
                return DART_SDK_JS_STUB;
            }
            int sdkUrlMarkerIndex = path.indexOf(SDK_URL_MARKER);
            if (sdkUrlMarkerIndex >= 0 || scheme == null && path.startsWith(SDK_URL_MARKER.substring(1))) {
                String relPath = path.substring(sdkUrlMarkerIndex + SDK_URL_MARKER.length());
                return DartUrlResolver.findFileInDartSdkLibFolder(project, DartSdk.getDartSdk(project), "dart:" + relPath);
            }
            int packageUrlMarkerIndex = path.lastIndexOf(PACKAGE_URL_MARKER);
            if ((packageUrlMarkerIndex >= 0 || scheme == null && path.startsWith(PACKAGE_URL_MARKER.substring(1))) && (contextFile = DartFileUrlMapper.findContextFile(project, requestor)) != null) {
                String packageUri = "package:" + path.substring(packageUrlMarkerIndex + PACKAGE_URL_MARKER.length());
                return (VirtualFile)ReadAction.compute(() -> {
                    if (project == null) {
                        DartFileUrlMapper.$$$reportNull$$$0(14);
                    }
                    return DartUrlResolver.getInstance(project, contextFile).findFileByDartUrl(packageUri);
                });
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContextFile(@NotNull Project project, @Nullable Url url) {
        if (project == null) {
            DartFileUrlMapper.$$$reportNull$$$0(9);
        }
        if (url == null) {
            return null;
        }
        for (FileUrlMapper urlMapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            VirtualFile file;
            if (urlMapper instanceof DartFileUrlMapper || (file = urlMapper.getFile(url, project, url)) == null) continue;
            return file;
        }
        String authority = url.getAuthority();
        if (authority != null && !BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)authority)) {
            return (VirtualFile)ReadAction.compute(() -> {
                if (project == null) {
                    DartFileUrlMapper.$$$reportNull$$$0(13);
                }
                return (VirtualFile)ContainerUtil.getFirstItem((Collection)FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
            });
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFileInAnyPackagesFolder(@NotNull Project project, @NotNull String packageUrl) {
        if (project == null) {
            DartFileUrlMapper.$$$reportNull$$$0(10);
        }
        if (packageUrl == null) {
            DartFileUrlMapper.$$$reportNull$$$0(11);
        }
        for (VirtualFile yamlFile : FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            VirtualFile file = DartUrlResolver.getInstance(project, yamlFile).findFileByDartUrl(packageUrl);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public FileType getFileType(@NotNull Url url) {
        if (url == null) {
            DartFileUrlMapper.$$$reportNull$$$0(12);
        }
        return "dart".equals(url.getScheme()) || "package".equals(url.getScheme()) ? DartFileType.INSTANCE : null;
    }

    static {
        DART_SDK_JS_STUB.setWritable(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/DartFileUrlMapper";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/DartFileUrlMapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContextFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileInAnyPackagesFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findContextFile$3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFile$2";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFile$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

