/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.highlight;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.highlight.DartSyntaxHighlighterColors;
import com.jetbrains.lang.dart.lexer.DartLexer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DartSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        DartLexer dartLexer = new DartLexer();
        if (dartLexer == null) {
            DartSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return dartLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = DartSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            DartSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        DartSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)DartTokenTypesSets.RESERVED_WORDS, (TextAttributesKey)DartSyntaxHighlighterColors.KEYWORD);
        DartSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)DartTokenTypesSets.ASSIGNMENT_OPERATORS, (TextAttributesKey)DartSyntaxHighlighterColors.OPERATION_SIGN);
        DartSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)DartTokenTypesSets.BINARY_OPERATORS, (TextAttributesKey)DartSyntaxHighlighterColors.OPERATION_SIGN);
        DartSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)DartTokenTypesSets.UNARY_OPERATORS, (TextAttributesKey)DartSyntaxHighlighterColors.OPERATION_SIGN);
        ATTRIBUTES.put(DartTokenTypes.QUEST, DartSyntaxHighlighterColors.OPERATION_SIGN);
        DartSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)DartTokenTypesSets.STRINGS, (TextAttributesKey)DartSyntaxHighlighterColors.STRING);
        ATTRIBUTES.put(DartTokenTypes.HEX_NUMBER, DartSyntaxHighlighterColors.NUMBER);
        ATTRIBUTES.put(DartTokenTypes.NUMBER, DartSyntaxHighlighterColors.NUMBER);
        ATTRIBUTES.put(DartTokenTypes.LPAREN, DartSyntaxHighlighterColors.PARENTHS);
        ATTRIBUTES.put(DartTokenTypes.RPAREN, DartSyntaxHighlighterColors.PARENTHS);
        ATTRIBUTES.put(DartTokenTypes.LBRACE, DartSyntaxHighlighterColors.BRACES);
        ATTRIBUTES.put(DartTokenTypes.RBRACE, DartSyntaxHighlighterColors.BRACES);
        ATTRIBUTES.put(DartTokenTypes.SHORT_TEMPLATE_ENTRY_START, DartSyntaxHighlighterColors.BRACES);
        ATTRIBUTES.put(DartTokenTypes.LONG_TEMPLATE_ENTRY_START, DartSyntaxHighlighterColors.BRACES);
        ATTRIBUTES.put(DartTokenTypes.LONG_TEMPLATE_ENTRY_END, DartSyntaxHighlighterColors.BRACES);
        ATTRIBUTES.put(DartTokenTypes.LBRACKET, DartSyntaxHighlighterColors.BRACKETS);
        ATTRIBUTES.put(DartTokenTypes.RBRACKET, DartSyntaxHighlighterColors.BRACKETS);
        ATTRIBUTES.put(DartTokenTypes.COMMA, DartSyntaxHighlighterColors.COMMA);
        ATTRIBUTES.put(DartTokenTypes.DOT, DartSyntaxHighlighterColors.DOT);
        ATTRIBUTES.put(DartTokenTypes.DOT_DOT, DartSyntaxHighlighterColors.DOT);
        ATTRIBUTES.put(DartTokenTypes.QUEST_DOT, DartSyntaxHighlighterColors.DOT);
        ATTRIBUTES.put(DartTokenTypes.SEMICOLON, DartSyntaxHighlighterColors.SEMICOLON);
        ATTRIBUTES.put(DartTokenTypes.COLON, DartSyntaxHighlighterColors.COLON);
        ATTRIBUTES.put(DartTokenTypes.EXPRESSION_BODY_DEF, DartSyntaxHighlighterColors.FAT_ARROW);
        ATTRIBUTES.put(DartTokenTypesSets.SINGLE_LINE_COMMENT, DartSyntaxHighlighterColors.LINE_COMMENT);
        ATTRIBUTES.put(DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT, DartSyntaxHighlighterColors.DOC_COMMENT);
        ATTRIBUTES.put(DartTokenTypesSets.MULTI_LINE_COMMENT, DartSyntaxHighlighterColors.BLOCK_COMMENT);
        ATTRIBUTES.put(DartTokenTypesSets.MULTI_LINE_DOC_COMMENT, DartSyntaxHighlighterColors.DOC_COMMENT);
        ATTRIBUTES.put(DartTokenTypesSets.BAD_CHARACTER, DartSyntaxHighlighterColors.BAD_CHARACTER);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(ATTRIBUTES, null);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(ATTRIBUTES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/lang/dart/highlight/DartSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

