/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.folding.DartCodeFoldingSettings;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassBody;
import com.jetbrains.lang.dart.psi.DartClassDefinition;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartEnumDefinition;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartImportOrExportStatement;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartMapLiteralExpression;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartPartStatement;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.IDartBlock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final String SMILEY = "<~>";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DartFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            DartFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!(root instanceof DartFile)) {
            return;
        }
        DartFile dartFile = (DartFile)root;
        TextRange fileHeaderRange = DartFoldingBuilder.foldFileHeader(descriptors, dartFile, document);
        DartFoldingBuilder.foldConsequentStatements(descriptors, dartFile, DartImportOrExportStatement.class);
        DartFoldingBuilder.foldConsequentStatements(descriptors, dartFile, DartPartStatement.class);
        Collection psiElements = PsiTreeUtil.collectElementsOfType((PsiElement)root, (Class[])new Class[]{DartComponent.class, DartTypeArguments.class, PsiComment.class, DartStringLiteralExpression.class, DartMapLiteralExpression.class, DartNewExpression.class});
        DartFoldingBuilder.foldComments(descriptors, psiElements, fileHeaderRange);
        DartFoldingBuilder.foldClassBodies(descriptors, dartFile);
        DartFoldingBuilder.foldFunctionBodies(descriptors, psiElements);
        DartFoldingBuilder.foldTypeArguments(descriptors, psiElements);
        DartFoldingBuilder.foldMultilineStrings(descriptors, psiElements);
        DartFoldingBuilder.foldMapLiterals(descriptors, psiElements);
        DartFoldingBuilder.foldNewDartExpressions(descriptors, psiElements);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            DartFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            DartFoldingBuilder.$$$reportNull$$$0(4);
        }
        IElementType elementType = node.getElementType();
        PsiElement psiElement = node.getPsi();
        if (psiElement instanceof DartFile) {
            return "/.../";
        }
        if (psiElement instanceof DartImportOrExportStatement) {
            return "...";
        }
        if (psiElement instanceof DartPartStatement) {
            return "...";
        }
        if (elementType == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT) {
            return "/**...*/";
        }
        if (elementType == DartTokenTypesSets.MULTI_LINE_COMMENT) {
            return "/*...*/";
        }
        if (elementType == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
            return "///...";
        }
        if (elementType == DartTokenTypesSets.SINGLE_LINE_COMMENT) {
            return "//...";
        }
        if (psiElement instanceof DartClassBody || psiElement instanceof DartEnumDefinition) {
            return "{...}";
        }
        if (psiElement instanceof DartFunctionBody) {
            return "{...}";
        }
        if (psiElement instanceof DartTypeArguments) {
            return SMILEY;
        }
        if (psiElement instanceof DartStringLiteralExpression) {
            return DartFoldingBuilder.multilineStringPlaceholder(node);
        }
        if (psiElement instanceof DartMapLiteralExpression) {
            return "{...}";
        }
        if (psiElement instanceof DartArguments) {
            return "(...)";
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            DartFoldingBuilder.$$$reportNull$$$0(5);
        }
        IElementType elementType = node.getElementType();
        PsiElement psiElement = node.getPsi();
        CodeFoldingSettings settings = CodeFoldingSettings.getInstance();
        DartCodeFoldingSettings dartSettings = DartCodeFoldingSettings.getInstance();
        if (psiElement instanceof DartFile) {
            return settings.COLLAPSE_FILE_HEADER;
        }
        if (psiElement instanceof DartImportOrExportStatement) {
            return settings.COLLAPSE_IMPORTS;
        }
        if (psiElement instanceof DartPartStatement) {
            return dartSettings.isCollapseParts();
        }
        if (elementType == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT || elementType == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
            return settings.COLLAPSE_DOC_COMMENTS;
        }
        if (psiElement instanceof DartFunctionBody) {
            return settings.COLLAPSE_METHODS;
        }
        if (psiElement instanceof DartTypeArguments) {
            return dartSettings.isCollapseGenericParameters();
        }
        return false;
    }

    @Nullable
    private static TextRange foldFileHeader(@NotNull List<FoldingDescriptor> descriptors, @NotNull DartFile dartFile, @NotNull Document document) {
        PsiElement firstComment;
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (dartFile == null) {
            DartFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (document == null) {
            DartFoldingBuilder.$$$reportNull$$$0(8);
        }
        if ((firstComment = dartFile.getFirstChild()) instanceof PsiWhiteSpace) {
            firstComment = firstComment.getNextSibling();
        }
        if (!(firstComment instanceof PsiComment)) {
            return null;
        }
        boolean containsCustomRegionMarker = false;
        PsiElement nextAfterComments = firstComment;
        while (nextAfterComments instanceof PsiComment || nextAfterComments instanceof PsiWhiteSpace) {
            containsCustomRegionMarker |= DartFoldingBuilder.isCustomRegionElement((PsiElement)nextAfterComments);
            nextAfterComments = nextAfterComments.getNextSibling();
        }
        if (nextAfterComments == null) {
            return null;
        }
        if (nextAfterComments instanceof DartLibraryStatement || nextAfterComments instanceof DartPartStatement || nextAfterComments instanceof DartPartOfStatement || nextAfterComments instanceof DartImportOrExportStatement) {
            if (nextAfterComments.getPrevSibling() instanceof PsiWhiteSpace) {
                nextAfterComments = nextAfterComments.getPrevSibling();
            }
            if (nextAfterComments.equals(firstComment)) {
                return null;
            }
            UnfairTextRange fileHeaderCommentsRange = new UnfairTextRange(firstComment.getTextRange().getStartOffset(), nextAfterComments.getTextRange().getStartOffset());
            if (fileHeaderCommentsRange.getLength() > 1 && document.getLineNumber(fileHeaderCommentsRange.getEndOffset()) > document.getLineNumber(fileHeaderCommentsRange.getStartOffset())) {
                if (!containsCustomRegionMarker) {
                    descriptors.add(new FoldingDescriptor((PsiElement)dartFile, (TextRange)fileHeaderCommentsRange));
                }
                return fileHeaderCommentsRange;
            }
        }
        return null;
    }

    private static <T extends PsiElement> void foldConsequentStatements(@NotNull List<FoldingDescriptor> descriptors, @NotNull DartFile dartFile, @NotNull Class<T> aClass) {
        PsiElement firstStatement;
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (dartFile == null) {
            DartFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (aClass == null) {
            DartFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((firstStatement = PsiTreeUtil.getChildOfType((PsiElement)dartFile, aClass)) == null) {
            return;
        }
        PsiElement lastStatement = firstStatement;
        PsiElement nextElement = firstStatement;
        while (aClass.isInstance(nextElement) || nextElement instanceof PsiComment || nextElement instanceof PsiWhiteSpace) {
            if (aClass.isInstance(nextElement)) {
                lastStatement = nextElement;
            }
            nextElement = nextElement.getNextSibling();
        }
        if (lastStatement != firstStatement) {
            int startOffset = firstStatement.getTextRange().getStartOffset() + firstStatement.getFirstChild().getTextLength() + 1;
            int endOffset = lastStatement.getTextRange().getEndOffset();
            FoldingDescriptor descriptor = new FoldingDescriptor(firstStatement, TextRange.create((int)startOffset, (int)endOffset));
            if (aClass == DartImportOrExportStatement.class) {
                descriptor.setCanBeRemovedWhenCollapsed(true);
            }
            descriptors.add(descriptor);
        }
    }

    private static void foldComments(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements, @Nullable TextRange fileHeaderRange) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(13);
        }
        Iterator<PsiElement> iter = psiElements.iterator();
        while (iter.hasNext()) {
            PsiElement firstCommentInSequence;
            PsiElement psiElement = iter.next();
            if (!(psiElement instanceof PsiComment) || fileHeaderRange != null && fileHeaderRange.intersects(psiElement.getTextRange())) continue;
            IElementType elementType = psiElement.getNode().getElementType();
            if (!(elementType != DartTokenTypesSets.MULTI_LINE_DOC_COMMENT && elementType != DartTokenTypesSets.MULTI_LINE_COMMENT || DartFoldingBuilder.isCustomRegionElement((PsiElement)psiElement))) {
                descriptors.add(new FoldingDescriptor(psiElement, psiElement.getTextRange()));
                continue;
            }
            if (elementType != DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT && elementType != DartTokenTypesSets.SINGLE_LINE_COMMENT) continue;
            PsiElement lastCommentInSequence = firstCommentInSequence = psiElement;
            PsiElement nextElement = firstCommentInSequence;
            boolean containsCustomRegionMarker = DartFoldingBuilder.isCustomRegionElement((PsiElement)nextElement);
            while (iter.hasNext() && (nextElement = nextElement.getNextSibling()) != null && (nextElement instanceof PsiWhiteSpace || nextElement.getNode().getElementType() == elementType)) {
                if (nextElement.getNode().getElementType() != elementType) continue;
                iter.next();
                lastCommentInSequence = nextElement;
                containsCustomRegionMarker |= DartFoldingBuilder.isCustomRegionElement((PsiElement)nextElement);
            }
            if (lastCommentInSequence == firstCommentInSequence || containsCustomRegionMarker) continue;
            TextRange range = TextRange.create((int)firstCommentInSequence.getTextRange().getStartOffset(), (int)lastCommentInSequence.getTextRange().getEndOffset());
            descriptors.add(new FoldingDescriptor(firstCommentInSequence, range));
        }
    }

    private static void foldClassBodies(@NotNull List<FoldingDescriptor> descriptors, @NotNull DartFile dartFile) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(14);
        }
        if (dartFile == null) {
            DartFoldingBuilder.$$$reportNull$$$0(15);
        }
        for (DartClass dartClass : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)dartFile, DartClass.class)) {
            if (dartClass instanceof DartClassDefinition) {
                DartClassBody body = ((DartClassDefinition)dartClass).getClassBody();
                if (body == null || body.getTextLength() <= 2) continue;
                descriptors.add(new FoldingDescriptor((PsiElement)body, body.getTextRange()));
                continue;
            }
            if (!(dartClass instanceof DartEnumDefinition)) continue;
            ASTNode lBrace = dartClass.getNode().findChildByType(DartTokenTypes.LBRACE);
            ASTNode rBrace = dartClass.getNode().findChildByType(DartTokenTypes.RBRACE, lBrace);
            if (lBrace == null || rBrace == null || rBrace.getStartOffset() - lBrace.getStartOffset() <= 2) continue;
            descriptors.add(new FoldingDescriptor((PsiElement)dartClass, TextRange.create((int)lBrace.getStartOffset(), (int)(rBrace.getStartOffset() + 1))));
        }
    }

    private static void foldFunctionBodies(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(16);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(17);
        }
        for (PsiElement dartComponent : psiElements) {
            DartComponentType componentType = DartComponentType.typeOf(dartComponent);
            if (componentType == null) continue;
            switch (componentType) {
                case CONSTRUCTOR: 
                case FUNCTION: 
                case METHOD: 
                case OPERATOR: {
                    DartFoldingBuilder.foldFunctionBody(descriptors, dartComponent);
                    break;
                }
            }
        }
    }

    private static void foldFunctionBody(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement dartComponentOrOperatorDeclaration) {
        DartFunctionBody functionBody;
        IDartBlock block;
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(18);
        }
        if (dartComponentOrOperatorDeclaration == null) {
            DartFoldingBuilder.$$$reportNull$$$0(19);
        }
        IDartBlock iDartBlock = block = (functionBody = (DartFunctionBody)PsiTreeUtil.getChildOfType((PsiElement)dartComponentOrOperatorDeclaration, DartFunctionBody.class)) == null ? null : functionBody.getBlock();
        if (block != null && block.getTextLength() > 2) {
            descriptors.add(new FoldingDescriptor((PsiElement)functionBody, block.getTextRange()));
        }
    }

    private static void foldTypeArguments(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(20);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(21);
        }
        for (PsiElement psiElement : psiElements) {
            if (!(psiElement instanceof DartTypeArguments)) continue;
            DartTypeArguments dartTypeArguments = (DartTypeArguments)psiElement;
            if (!(PsiTreeUtil.getParentOfType((PsiElement)dartTypeArguments, (Class[])new Class[]{DartNewExpression.class, DartTypeArguments.class}) instanceof DartNewExpression)) continue;
            descriptors.add(new FoldingDescriptor((PsiElement)dartTypeArguments, TextRange.create((int)dartTypeArguments.getTextRange().getStartOffset(), (int)dartTypeArguments.getTextRange().getEndOffset())));
        }
    }

    private static void foldMultilineStrings(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(22);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(23);
        }
        for (PsiElement element : psiElements) {
            IElementType type;
            DartStringLiteralExpression dartString;
            PsiElement child;
            if (!(element instanceof DartStringLiteralExpression) || (child = (dartString = (DartStringLiteralExpression)element).getFirstChild()) == null || (type = child.getNode().getElementType()) != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING && (type != DartTokenTypes.OPEN_QUOTE || child.getTextLength() != 3)) continue;
            descriptors.add(new FoldingDescriptor((PsiElement)dartString, dartString.getTextRange()));
        }
    }

    private static void foldNewDartExpressions(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(24);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(25);
        }
        for (PsiElement psiElement : psiElements) {
            DartArgumentList dartArgumentList;
            DartNewExpression dartNewExpression;
            DartArguments dartArguments;
            if (!(psiElement instanceof DartNewExpression) || (dartArguments = (dartNewExpression = (DartNewExpression)psiElement).getArguments()) == null || dartArguments.getArgumentList() == null || (dartArgumentList = dartArguments.getArgumentList()).getExpressionList().isEmpty() && dartArgumentList.getNamedArgumentList().isEmpty()) continue;
            descriptors.add(new FoldingDescriptor((PsiElement)dartArguments, dartArguments.getTextRange()));
        }
    }

    private static String multilineStringPlaceholder(@NotNull ASTNode node) {
        ASTNode child;
        if (node == null) {
            DartFoldingBuilder.$$$reportNull$$$0(26);
        }
        if ((child = node.getFirstChildNode()) == null) {
            return "...";
        }
        if (child.getElementType() == DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) {
            String text = child.getText();
            String quotes = text.substring(1, 4);
            return "r" + quotes + "..." + quotes;
        }
        if (child.getElementType() == DartTokenTypes.OPEN_QUOTE) {
            String text = child.getText();
            String quotes = text.substring(0, 3);
            return quotes + "..." + quotes;
        }
        return "...";
    }

    private static void foldMapLiterals(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            DartFoldingBuilder.$$$reportNull$$$0(27);
        }
        if (psiElements == null) {
            DartFoldingBuilder.$$$reportNull$$$0(28);
        }
        for (PsiElement psiElement : psiElements) {
            String text;
            ASTNode rBrace;
            if (!(psiElement instanceof DartMapLiteralExpression)) continue;
            ASTNode node = psiElement.getNode();
            ASTNode lBrace = node.findChildByType(DartTokenTypes.LBRACE);
            ASTNode aSTNode = rBrace = lBrace == null ? null : node.findChildByType(DartTokenTypes.RBRACE, lBrace);
            if (lBrace == null || rBrace == null || !(text = node.getText().substring(lBrace.getStartOffset() - node.getStartOffset(), rBrace.getStartOffset() - node.getStartOffset())).contains("\n")) continue;
            descriptors.add(new FoldingDescriptor(psiElement, TextRange.create((int)lBrace.getStartOffset(), (int)(rBrace.getStartOffset() + rBrace.getTextLength()))));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartComponentOrOperatorDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/folding/DartFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "foldFileHeader";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "foldConsequentStatements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "foldComments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "foldClassBodies";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "foldFunctionBodies";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "foldFunctionBody";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "foldTypeArguments";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "foldMultilineStrings";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "foldNewDartExpressions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "multilineStringPlaceholder";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "foldMapLiterals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

