/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.flutter;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class FlutterUtil {
    private static final String FLUTTER_MODULE_TYPE_ID = "FLUTTER_MODULE_TYPE";
    private static final String DART_SDK_SUFFIX = "/bin/cache/dart-sdk";
    private static final boolean FLUTTER_PLUGIN_INSTALLED = PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)"io.flutter"));

    @Nullable
    public static String getFlutterRoot(@NotNull String dartSdkPath) {
        if (dartSdkPath == null) {
            FlutterUtil.$$$reportNull$$$0(0);
        }
        return dartSdkPath.endsWith(DART_SDK_SUFFIX) ? dartSdkPath.substring(0, dartSdkPath.length() - DART_SDK_SUFFIX.length()) : null;
    }

    public static boolean isFlutterModule(@NotNull Module module) {
        if (module == null) {
            FlutterUtil.$$$reportNull$$$0(1);
        }
        if (FLUTTER_MODULE_TYPE_ID.equals(ModuleType.get((Module)module).getId())) {
            return true;
        }
        DartSdk dartSdk = DartSdk.getDartSdk(module.getProject());
        String dartSdkPath = dartSdk != null ? dartSdk.getHomePath() : null;
        return dartSdkPath != null && dartSdkPath.endsWith(DART_SDK_SUFFIX) && DartSdkLibUtil.isDartSdkEnabled(module);
    }

    public static boolean isFlutterPluginInstalled() {
        return FLUTTER_PLUGIN_INSTALLED;
    }

    public static boolean isPubspecDeclaringFlutter(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtil.$$$reportNull$$$0(2);
        }
        try {
            String contents = new String(pubspec.contentsToByteArray(true));
            Map<String, Object> yaml = FlutterUtil.loadPubspecInfo(contents);
            if (yaml == null) {
                return false;
            }
            Object flutterEntry = yaml.get("dependencies");
            if (flutterEntry instanceof Map) {
                return ((Map)flutterEntry).containsKey("flutter");
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Map<String, Object> loadPubspecInfo(@NotNull String yamlContents) {
        if (yamlContents == null) {
            FlutterUtil.$$$reportNull$$$0(3);
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), new DumperOptions(), new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
                this.addImplicitResolver(new Tag("tag:yaml.org,2002:value"), VALUE, "=");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            }
        });
        try {
            return (Map)yaml.load(yamlContents);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartSdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContents";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/flutter/FlutterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFlutterRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlutterModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPubspecDeclaringFlutter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPubspecInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

