/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.fixes;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.fixes.DartQuickFix;
import com.jetbrains.lang.dart.ide.annotator.DartProblemGroup;
import java.util.ArrayList;
import java.util.List;
import org.dartlang.analysis.server.protocol.AnalysisErrorFixes;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartQuickFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final VirtualFile myFile;
    private final int myOffset;
    @Nullable
    private final String myErrorCode;
    @NotNull
    private final String myErrorSeverity;
    @NotNull
    private final List<DartQuickFix> myQuickFixes;
    private volatile long myPsiModCountWhenRequestSent;
    private volatile long myVfsModCountWhenRequestSent;

    public DartQuickFixSet(@NotNull PsiManager psiManager, @NotNull VirtualFile file, int offset, @Nullable String errorCode, @NotNull String errorSeverity) {
        if (psiManager == null) {
            DartQuickFixSet.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DartQuickFixSet.$$$reportNull$$$0(1);
        }
        if (errorSeverity == null) {
            DartQuickFixSet.$$$reportNull$$$0(2);
        }
        this.myQuickFixes = new ArrayList<DartQuickFix>(5);
        this.myPsiManager = psiManager;
        this.myFile = file;
        this.myOffset = offset;
        this.myErrorCode = errorCode;
        this.myErrorSeverity = errorSeverity;
        for (int i = 0; i < 5; ++i) {
            this.myQuickFixes.add(new DartQuickFix(this, i));
        }
    }

    @NotNull
    public List<DartQuickFix> getQuickFixes() {
        List<DartQuickFix> list = this.myQuickFixes;
        if (list == null) {
            DartQuickFixSet.$$$reportNull$$$0(3);
        }
        return list;
    }

    synchronized void ensureInitialized() {
        long psiModCount = this.myPsiManager.getModificationTracker().getModificationCount();
        long vfsModCount = VirtualFileManager.getInstance().getModificationCount();
        if (this.myPsiModCountWhenRequestSent == psiModCount && this.myVfsModCountWhenRequestSent == vfsModCount) {
            return;
        }
        this.myPsiModCountWhenRequestSent = psiModCount;
        this.myVfsModCountWhenRequestSent = vfsModCount;
        for (DartQuickFix fix : this.myQuickFixes) {
            fix.setSourceChange(null);
        }
        Consumer consumer = fixes -> {
            long psiModCountWhenReceivedFixes = this.myPsiManager.getModificationTracker().getModificationCount();
            long vfsModCountWhenReceivedFixes = VirtualFileManager.getInstance().getModificationCount();
            if (this.myPsiModCountWhenRequestSent != psiModCountWhenReceivedFixes || this.myVfsModCountWhenRequestSent != vfsModCountWhenReceivedFixes) {
                return;
            }
            if (fixes == null || fixes.isEmpty()) {
                if (this.myErrorCode != null) {
                    this.myQuickFixes.get(0).setSuppressActionDelegate(new DartProblemGroup.DartSuppressAction(this.myErrorCode, this.myErrorSeverity, false));
                    this.myQuickFixes.get(1).setSuppressActionDelegate(new DartProblemGroup.DartSuppressAction(this.myErrorCode, this.myErrorSeverity, true));
                }
            } else {
                int index = 0;
                for (AnalysisErrorFixes fix : fixes) {
                    for (SourceChange sourceChange : fix.getFixes()) {
                        this.myQuickFixes.get(index).setSourceChange(sourceChange);
                        if (++index != 5) continue;
                        return;
                    }
                }
            }
        };
        DartAnalysisServerService.getInstance(this.myPsiManager.getProject()).askForFixesAndWaitABitIfReceivedQuickly(this.myFile, this.myOffset, (Consumer<List<AnalysisErrorFixes>>)consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorSeverity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/fixes/DartQuickFixSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/fixes/DartQuickFixSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

