/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.fixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.fixes.DartQuickFixSet;
import com.jetbrains.lang.dart.ide.annotator.DartProblemGroup;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DartQuickFix
implements IntentionAction,
Comparable<IntentionAction> {
    @NotNull
    private final DartQuickFixSet myQuickFixSet;
    private final int myIndex;
    @Nullable
    private SourceChange mySourceChange;
    @Nullable
    private DartProblemGroup.DartSuppressAction mySuppressActionDelegate;

    public DartQuickFix(@NotNull DartQuickFixSet quickFixSet, int index) {
        if (quickFixSet == null) {
            DartQuickFix.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myQuickFixSet = quickFixSet;
    }

    @NotNull
    public String getFamilyName() {
        if (this.mySuppressActionDelegate != null) {
            String string = this.mySuppressActionDelegate.getFamilyName();
            if (string == null) {
                DartQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getText();
        if (string == null) {
            DartQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        this.myQuickFixSet.ensureInitialized();
        if (this.mySuppressActionDelegate != null) {
            String string = this.mySuppressActionDelegate.getText();
            if (string == null) {
                DartQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.mySourceChange == null ? "" : this.mySourceChange.getMessage();
        if (string == null) {
            DartQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public int compareTo(IntentionAction o) {
        if (o instanceof DartQuickFix) {
            return this.myIndex - ((DartQuickFix)o).myIndex;
        }
        return 0;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile;
        if (project == null) {
            DartQuickFix.$$$reportNull$$$0(5);
        }
        if (this.mySuppressActionDelegate != null) {
            this.mySuppressActionDelegate.invoke(project, editor, file);
        }
        if (this.mySourceChange == null) {
            return;
        }
        SourceFileEdit fileEdit = this.mySourceChange.getEdits().get(0);
        String filePath = FileUtil.toSystemIndependentName((String)fileEdit.getFile());
        if (fileEdit.getFileStamp() == -1L) {
            try {
                String directoryPath = PathUtil.getParentPath((String)filePath);
                if (directoryPath.isEmpty()) {
                    throw new IOException("empty folder path");
                }
                VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)directoryPath);
                if (directory == null) {
                    throw new IOException("failed to create folder " + FileUtil.toSystemDependentName((String)directoryPath));
                }
                virtualFile = directory.createChildData((Object)this, PathUtil.getFileName((String)filePath));
            }
            catch (IOException e) {
                String message = DartBundle.message("failed.to.create.file.0.1", FileUtil.toSystemDependentName((String)filePath), e.getMessage());
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
                return;
            }
        } else {
            virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if (virtualFile == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, Collections.singletonList(virtualFile))) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        try {
            AssistUtils.applySourceChange(project, this.mySourceChange, true);
        }
        catch (DartSourceEditException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DartQuickFix.$$$reportNull$$$0(6);
        }
        this.myQuickFixSet.ensureInitialized();
        if (this.mySuppressActionDelegate != null) {
            return this.mySuppressActionDelegate.isAvailable(project, editor, file);
        }
        if (this.mySourceChange == null) {
            return false;
        }
        List<SourceFileEdit> fileEdits = this.mySourceChange.getEdits();
        if (fileEdits.size() != 1) {
            return false;
        }
        SourceFileEdit fileEdit = fileEdits.get(0);
        VirtualFile virtualFile = AssistUtils.findVirtualFile(fileEdit);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return fileEdit.getFileStamp() == -1L || virtualFile != null && fileIndex.isInContent(virtualFile);
    }

    void setSourceChange(@Nullable SourceChange sourceChange) {
        this.mySourceChange = sourceChange;
    }

    void setSuppressActionDelegate(@Nullable DartProblemGroup.DartSuppressAction suppressActionDelegate) {
        this.mySuppressActionDelegate = suppressActionDelegate;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/fixes/DartQuickFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/fixes/DartQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

