/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.coverage.DartCoverageData;
import com.jetbrains.lang.dart.coverage.DartCoverageEngine;
import com.jetbrains.lang.dart.coverage.DartCoverageSuite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageRunner
extends CoverageRunner {
    private static final String ID = "DartCoverageRunner";
    private static final Logger LOG = Logger.getInstance((String)DartCoverageRunner.class.getName());

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            DartCoverageRunner.$$$reportNull$$$0(0);
        }
        if (!(baseCoverageSuite instanceof DartCoverageSuite)) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref projectDataRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (sessionDataFile == null) {
                    DartCoverageRunner.$$$reportNull$$$0(10);
                }
                projectDataRef.set((Object)DartCoverageRunner.doLoadCoverageData(sessionDataFile, (DartCoverageSuite)baseCoverageSuite));
            }, "Loading Coverage Data...", true, baseCoverageSuite.getProject());
            return (ProjectData)projectDataRef.get();
        }
        return DartCoverageRunner.doLoadCoverageData(sessionDataFile, (DartCoverageSuite)baseCoverageSuite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ProjectData doLoadCoverageData(@NotNull File sessionDataFile, @NotNull DartCoverageSuite coverageSuite) {
        ProcessHandler coverageProcess;
        if (sessionDataFile == null) {
            DartCoverageRunner.$$$reportNull$$$0(1);
        }
        if (coverageSuite == null) {
            DartCoverageRunner.$$$reportNull$$$0(2);
        }
        if ((coverageProcess = coverageSuite.getCoverageProcess()) != null) {
            for (int i = 0; i < 100; ++i) {
                ProgressManager.checkCanceled();
                if (coverageProcess.waitFor(100L)) break;
            }
            if (!coverageProcess.isProcessTerminated()) {
                coverageProcess.destroyProcess();
                return null;
            }
        }
        Project project = coverageSuite.getProject();
        String contextFilePath = coverageSuite.getContextFilePath();
        if (project == null || contextFilePath == null) {
            return null;
        }
        String contextId = DartAnalysisServerService.getInstance(project).execution_createContext(contextFilePath);
        if (contextId == null) {
            return null;
        }
        ProjectData projectData = new ProjectData();
        try {
            DartCoverageData data = (DartCoverageData)new Gson().fromJson((Reader)new BufferedReader(new FileReader(sessionDataFile)), DartCoverageData.class);
            if (data == null) {
                LOG.warn("Coverage file does not contain valid data.");
                ProjectData projectData2 = null;
                return projectData2;
            }
            for (Map.Entry<String, SortedMap<Integer, Integer>> entry : data.getMergedDartFileCoverageData().entrySet()) {
                ProgressManager.checkCanceled();
                String filePath = DartCoverageRunner.getFileForUri(project, contextId, entry.getKey());
                if (filePath == null) continue;
                SortedMap<Integer, Integer> lineHits = entry.getValue();
                ClassData classData = projectData.getOrCreateClassData(filePath);
                if (lineHits.size() == 0) {
                    classData.setLines(new LineData[1]);
                    continue;
                }
                LineData[] lines = new LineData[lineHits.lastKey() + 1];
                for (Map.Entry<Integer, Integer> hit : lineHits.entrySet()) {
                    LineData lineData = new LineData(hit.getKey().intValue(), null);
                    lineData.setHits(hit.getValue().intValue());
                    lines[hit.getKey().intValue()] = lineData;
                }
                classData.setLines(lines);
            }
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            LOG.warn(e);
        }
        finally {
            DartAnalysisServerService.getInstance(project).execution_deleteContext(contextId);
        }
        return projectData;
    }

    @Nullable
    private static String getFileForUri(@NotNull Project project, @NotNull String contextId, @NotNull String uri) {
        if (project == null) {
            DartCoverageRunner.$$$reportNull$$$0(3);
        }
        if (contextId == null) {
            DartCoverageRunner.$$$reportNull$$$0(4);
        }
        if (uri == null) {
            DartCoverageRunner.$$$reportNull$$$0(5);
        }
        if (uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/")) {
            return null;
        }
        return DartAnalysisServerService.getInstance(project).execution_mapUri(contextId, null, uri);
    }

    @NotNull
    public String getPresentableName() {
        if ("Dart" == null) {
            DartCoverageRunner.$$$reportNull$$$0(6);
        }
        return "Dart";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            DartCoverageRunner.$$$reportNull$$$0(7);
        }
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        if ("json" == null) {
            DartCoverageRunner.$$$reportNull$$$0(8);
        }
        return "json";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            DartCoverageRunner.$$$reportNull$$$0(9);
        }
        return engine instanceof DartCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/coverage/DartCoverageRunner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/coverage/DartCoverageRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doLoadCoverageData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileForUri";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadCoverageData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

