/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.coverage.DartCoverageEnabledConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageProgramRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance((String)DartCoverageProgramRunner.class.getName());
    private static final String ID = "DartCoverageProgramRunner";
    private boolean myCoveragePackageActivated;

    @NotNull
    public String getRunnerId() {
        if (ID == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return executorId.equals("Coverage") && profile instanceof DartCommandLineRunConfiguration;
    }

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        DartCommandLineRunConfiguration runConfiguration = (DartCommandLineRunConfiguration)env.getRunProfile();
        DartSdk sdk = DartSdk.getDartSdk(runConfiguration.getProject());
        if (sdk == null) {
            throw new ExecutionException(DartBundle.message("dart.sdk.is.not.configured", new Object[0]));
        }
        String dartPubPath = DartSdkUtil.getPubPath(sdk);
        RunContentDescriptor result = DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)env, (ProgramRunner)this);
        if (result == null) {
            return null;
        }
        if (!this.myCoveragePackageActivated && !this.activateCoverage(runConfiguration.getProject(), dartPubPath)) {
            throw new ExecutionException("Cannot activate pub package 'coverage'.");
        }
        ProcessHandler dartAppProcessHandler = result.getProcessHandler();
        if (dartAppProcessHandler != null) {
            ((DartCommandLineRunningState)state).addObservatoryUrlConsumer((Consumer<String>)((Consumer)observatoryUrl -> {
                if (env == null) {
                    DartCoverageProgramRunner.$$$reportNull$$$0(12);
                }
                DartCoverageProgramRunner.startCollectingCoverage(env, dartAppProcessHandler, observatoryUrl);
            }));
        }
        return result;
    }

    private static void startCollectingCoverage(@NotNull ExecutionEnvironment env, @NotNull ProcessHandler dartAppProcessHandler, @NotNull String observatoryUrl) {
        if (env == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        if (dartAppProcessHandler == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        if (observatoryUrl == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        DartCommandLineRunConfiguration dartRC = (DartCommandLineRunConfiguration)env.getRunProfile();
        DartCoverageEnabledConfiguration coverageConfiguration = (DartCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)dartRC);
        String coverageFilePath = coverageConfiguration.getCoverageFilePath();
        DartSdk sdk = DartSdk.getDartSdk(env.getProject());
        LOG.assertTrue(sdk != null);
        GeneralCommandLine cmdline = new GeneralCommandLine().withExePath(DartSdkUtil.getPubPath(sdk)).withParameters(new String[]{"global", "run", "coverage:collect_coverage", "--uri", observatoryUrl, "--out", coverageFilePath, "--resume-isolates", "--wait-paused"});
        try {
            OSProcessHandler coverageProcess = new OSProcessHandler(cmdline);
            coverageProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    LOG.debug(event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            coverageProcess.startNotify();
            coverageConfiguration.setCoverageProcess((ProcessHandler)coverageProcess);
            CoverageHelper.attachToProcess((RunConfigurationBase)dartRC, (ProcessHandler)dartAppProcessHandler, (RunnerSettings)env.getRunnerSettings());
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean activateCoverage(@NotNull Project project, @NotNull String dartPubPath) {
        if (project == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if (dartPubPath == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator;
            if (dartPubPath == null) {
                DartCoverageProgramRunner.$$$reportNull$$$0(11);
            }
            if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
                indicator.setIndeterminate(true);
            }
            try {
                this.checkIfCoverageActivated(dartPubPath);
                ProcessOutput activateOutput = new CapturingProcessHandler(new GeneralCommandLine().withExePath(dartPubPath).withParameters(new String[]{"global", "activate", "coverage"}).withRedirectErrorStream(true)).runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
                if (activateOutput.getExitCode() != 0) {
                    LOG.warn("'pub global activate coverage' exit code: " + activateOutput.getExitCode() + ", stdout:\n" + activateOutput.getStdout());
                }
                if (!this.myCoveragePackageActivated) {
                    this.checkIfCoverageActivated(dartPubPath);
                }
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }, "Activating Coverage Package...", true, project);
        return this.myCoveragePackageActivated;
    }

    private void checkIfCoverageActivated(@NotNull String dartPubPath) throws ExecutionException {
        if (dartPubPath == null) {
            DartCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        ProcessOutput listOutput = new CapturingProcessHandler(new GeneralCommandLine().withExePath(dartPubPath).withParameters(new String[]{"global", "list"}).withRedirectErrorStream(true)).runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        String listOutputStdout = listOutput.getStdout();
        if (listOutput.getExitCode() == 0) {
            if (listOutputStdout.startsWith("coverage ") || listOutputStdout.contains("\ncoverage ")) {
                this.myCoveragePackageActivated = true;
            }
        } else {
            LOG.warn("'pub global list' exit code: " + listOutput.getExitCode() + ", stdout:\n" + listOutputStdout);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartAppProcessHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observatoryUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartPubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startCollectingCoverage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "activateCoverage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCoverageActivated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$activateCoverage$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

