/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;

public class QuickAssistSet {
    private List<SourceChange> lastSourceChanges = Lists.newArrayList();
    private long lastPsiModificationCount;
    private String lastFilePath;
    private int lastOffset;
    private int lastLength;

    public synchronized List<SourceChange> getQuickAssists(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            QuickAssistSet.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            QuickAssistSet.$$$reportNull$$$0(1);
        }
        long psiModificationCount = psiFile.getManager().getModificationTracker().getModificationCount();
        String filePath = psiFile.getVirtualFile().getPath();
        Caret currentCaret = editor.getCaretModel().getPrimaryCaret();
        int offset = currentCaret.getSelectionStart();
        int length = currentCaret.getSelectionEnd() - offset;
        if (this.lastPsiModificationCount == psiModificationCount && ObjectUtilities.equals(this.lastFilePath, filePath) && this.lastOffset == offset && this.lastLength == length) {
            return this.lastSourceChanges;
        }
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(psiFile.getProject());
        service.updateFilesContent();
        this.lastSourceChanges = service.edit_getAssists(psiFile.getVirtualFile(), offset, length);
        this.lastFilePath = filePath;
        this.lastOffset = offset;
        this.lastLength = length;
        this.lastPsiModificationCount = psiModificationCount;
        return this.lastSourceChanges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/assists/QuickAssistSet";
        objectArray[2] = "getQuickAssists";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

