/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.assists.QuickAssistSet;
import com.jetbrains.lang.dart.psi.DartFile;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartQuickAssistIntention
implements IntentionAction,
Comparable<IntentionAction> {
    @Nullable
    private final QuickAssistSet quickAssistSet;
    private final int index;
    @Nullable
    private SourceChange sourceChange;

    public DartQuickAssistIntention() {
        this.quickAssistSet = null;
        this.index = -1;
    }

    public DartQuickAssistIntention(@NotNull QuickAssistSet quickAssistSet, int index) {
        if (quickAssistSet == null) {
            DartQuickAssistIntention.$$$reportNull$$$0(0);
        }
        this.quickAssistSet = quickAssistSet;
        this.index = index;
    }

    @Override
    public int compareTo(IntentionAction o) {
        if (o instanceof DartQuickAssistIntention) {
            DartQuickAssistIntention other = (DartQuickAssistIntention)o;
            return this.index - other.index;
        }
        return 0;
    }

    @NotNull
    public String getFamilyName() {
        String message = DartBundle.message("dart.quick.assist.family.name", new Object[0]);
        String string = this.quickAssistSet == null ? message : "Dart/" + message;
        if (string == null) {
            DartQuickAssistIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.sourceChange == null ? "" : this.sourceChange.getMessage();
        if (string == null) {
            DartQuickAssistIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            DartQuickAssistIntention.$$$reportNull$$$0(3);
        }
        if (this.sourceChange != null) {
            try {
                AssistUtils.applySourceChange(project, this.sourceChange, true);
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DartQuickAssistIntention.$$$reportNull$$$0(4);
        }
        if (this.quickAssistSet == null || !(file instanceof DartFile)) {
            return false;
        }
        List<SourceChange> sourceChanges = this.quickAssistSet.getQuickAssists(editor, file);
        if (sourceChanges.size() <= this.index) {
            this.sourceChange = null;
            return false;
        }
        this.sourceChange = sourceChanges.get(this.index);
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickAssistSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/assists/DartQuickAssistIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/assists/DartQuickAssistIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

