/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.dartlang.analysis.server.protocol.LinkedEditSuggestion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartLookupExpression
extends Expression {
    @NotNull
    private final String myText;
    @NotNull
    private final List<LinkedEditSuggestion> mySuggestions;

    DartLookupExpression(@NotNull String text, @NotNull List<LinkedEditSuggestion> suggestions) {
        if (text == null) {
            DartLookupExpression.$$$reportNull$$$0(0);
        }
        if (suggestions == null) {
            DartLookupExpression.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.mySuggestions = suggestions;
    }

    @Nullable
    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        int length = this.mySuggestions.size();
        LookupElement[] elements = new LookupElement[length];
        for (int i = 0; i < length; ++i) {
            final LinkedEditSuggestion suggestion = this.mySuggestions.get(i);
            final String value = suggestion.getValue();
            elements[i] = LookupElementBuilder.create((String)value).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    Icon icon = DartLookupExpression.getIcon(suggestion.getKind());
                    presentation.setIcon(icon);
                    presentation.setItemText(value);
                }
            });
        }
        return elements;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return new TextResult(this.myText);
    }

    public Result calculateResult(ExpressionContext context) {
        return this.calculateQuickResult(context);
    }

    private static Icon getIcon(String suggestionKind) {
        if ("METHOD".equals(suggestionKind)) {
            return PlatformIcons.METHOD_ICON;
        }
        if ("PARAMETER".equals(suggestionKind)) {
            return PlatformIcons.PARAMETER_ICON;
        }
        if ("TYPE".equals(suggestionKind)) {
            return PlatformIcons.CLASS_ICON;
        }
        if ("VARIABLE".equals(suggestionKind)) {
            return PlatformIcons.VARIABLE_ICON;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "suggestions";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/assists/DartLookupExpression";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

