/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.ChangeTarget;
import com.jetbrains.lang.dart.assists.DartLookupExpression;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.analysis.server.protocol.LinkedEditGroup;
import org.dartlang.analysis.server.protocol.Position;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssistUtils {
    public static boolean applyFileEdit(@NotNull Project project, @NotNull SourceFileEdit fileEdit) {
        VirtualFile file;
        Document document;
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(0);
        }
        if (fileEdit == null) {
            AssistUtils.$$$reportNull$$$0(1);
        }
        Document document2 = document = (file = AssistUtils.findVirtualFile(fileEdit)) == null ? null : FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        long initialModStamp = document.getModificationStamp();
        AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), Collections.emptySet());
        return document.getModificationStamp() != initialModStamp;
    }

    public static void applySourceChange(@NotNull Project project, @NotNull SourceChange sourceChange, boolean withLinkedEdits) throws DartSourceEditException {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(2);
        }
        if (sourceChange == null) {
            AssistUtils.$$$reportNull$$$0(3);
        }
        AssistUtils.applySourceChange(project, sourceChange, withLinkedEdits, Collections.emptySet());
    }

    public static void applySourceChange(@NotNull Project project, @NotNull SourceChange sourceChange, boolean withLinkedEdits, @NotNull Set<String> excludedIds) throws DartSourceEditException {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(4);
        }
        if (sourceChange == null) {
            AssistUtils.$$$reportNull$$$0(5);
        }
        if (excludedIds == null) {
            AssistUtils.$$$reportNull$$$0(6);
        }
        Map<VirtualFile, SourceFileEdit> changeMap = AssistUtils.getContentFilesChanges(project, sourceChange, excludedIds);
        Set<VirtualFile> files = changeMap.keySet();
        boolean okToWrite = FileModificationService.getInstance().prepareVirtualFilesForWrite(project, files);
        if (!okToWrite) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                AssistUtils.$$$reportNull$$$0(31);
            }
            if (sourceChange == null) {
                AssistUtils.$$$reportNull$$$0(32);
            }
            if (excludedIds == null) {
                AssistUtils.$$$reportNull$$$0(33);
            }
            ChangeTarget linkedEditTarget = withLinkedEdits ? AssistUtils.findChangeTarget(project, sourceChange) : null;
            List<SourceEditInfo> sourceEditInfos = null;
            for (Map.Entry entry : changeMap.entrySet()) {
                VirtualFile file = (VirtualFile)entry.getKey();
                SourceFileEdit fileEdit = (SourceFileEdit)entry.getValue();
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) continue;
                List<SourceEditInfo> infos = AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), excludedIds);
                if (linkedEditTarget == null || !linkedEditTarget.virtualFile.equals(file)) continue;
                sourceEditInfos = infos;
            }
            if (withLinkedEdits) {
                Position selection;
                VirtualFile file;
                if (sourceEditInfos != null) {
                    AssistUtils.runLinkedEdits(project, sourceChange, linkedEditTarget, sourceEditInfos);
                } else if (sourceChange.getSelection() != null && (file = AssistUtils.findVirtualFile((selection = sourceChange.getSelection()).getFile())) != null) {
                    int offset = selection.getOffset();
                    offset = DartAnalysisServerService.getInstance(project).getConvertedOffset(file, offset);
                    AssistUtils.navigate(project, file, offset);
                }
            }
        }, sourceChange.getMessage(), null);
    }

    public static List<SourceEditInfo> applySourceEdits(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @NotNull List<SourceEdit> edits, @NotNull Set<String> excludedIds) {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AssistUtils.$$$reportNull$$$0(8);
        }
        if (document == null) {
            AssistUtils.$$$reportNull$$$0(9);
        }
        if (edits == null) {
            AssistUtils.$$$reportNull$$$0(10);
        }
        if (excludedIds == null) {
            AssistUtils.$$$reportNull$$$0(11);
        }
        ArrayList<SourceEditInfo> result = new ArrayList<SourceEditInfo>(edits.size());
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        for (SourceEdit edit : edits) {
            if (excludedIds.contains(edit.getId())) continue;
            int offset = service.getConvertedOffset(file, edit.getOffset());
            int length = service.getConvertedOffset(file, edit.getOffset() + edit.getLength()) - offset;
            String replacement = StringUtil.convertLineSeparators((String)edit.getReplacement());
            for (SourceEditInfo info : result) {
                if (info.resultingOriginalOffset <= edit.getOffset()) continue;
                SourceEditInfo sourceEditInfo = info;
                sourceEditInfo.resultingOriginalOffset = sourceEditInfo.resultingOriginalOffset - edit.getLength();
                sourceEditInfo = info;
                sourceEditInfo.resultingOriginalOffset = sourceEditInfo.resultingOriginalOffset + edit.getReplacement().length();
                sourceEditInfo = info;
                sourceEditInfo.resultingConvertedOffset = sourceEditInfo.resultingConvertedOffset - length;
                sourceEditInfo = info;
                sourceEditInfo.resultingConvertedOffset = sourceEditInfo.resultingConvertedOffset + replacement.length();
            }
            result.add(new SourceEditInfo(edit.getOffset(), offset, edit.getLength(), length, edit.getReplacement(), replacement));
            if (length == replacement.length() && replacement.equals(document.getText(TextRange.create((int)offset, (int)(offset + length))))) continue;
            document.replaceString(offset, offset + length, (CharSequence)replacement);
        }
        return result;
    }

    @NotNull
    public static Map<VirtualFile, SourceFileEdit> getContentFilesChanges(@NotNull Project project, @NotNull SourceChange sourceChange, @NotNull Set<String> excludedIds) throws DartSourceEditException {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(12);
        }
        if (sourceChange == null) {
            AssistUtils.$$$reportNull$$$0(13);
        }
        if (excludedIds == null) {
            AssistUtils.$$$reportNull$$$0(14);
        }
        HashMap map = Maps.newHashMap();
        List<SourceFileEdit> fileEdits = sourceChange.getEdits();
        for (SourceFileEdit fileEdit : fileEdits) {
            boolean allEditsExcluded = true;
            for (SourceEdit edit : fileEdit.getEdits()) {
                if (excludedIds.contains(edit.getId())) continue;
                allEditsExcluded = false;
                break;
            }
            if (allEditsExcluded) continue;
            VirtualFile file = AssistUtils.findVirtualFile(fileEdit);
            if (file == null) {
                throw new DartSourceEditException("Failed to edit file, file not found: " + fileEdit.getFile());
            }
            if (!AssistUtils.isInContent(project, file)) {
                throw new DartSourceEditException("Can't edit file outside of the project content: " + fileEdit.getFile());
            }
            map.put(file, fileEdit);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            AssistUtils.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @Nullable
    private static ChangeTarget findChangeTarget(@NotNull Project project, @NotNull SourceChange sourceChange) {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(16);
        }
        if (sourceChange == null) {
            AssistUtils.$$$reportNull$$$0(17);
        }
        for (LinkedEditGroup group : sourceChange.getLinkedEditGroups()) {
            List<Position> positions = group.getPositions();
            if (positions.isEmpty()) continue;
            Position position = positions.get(0);
            VirtualFile virtualFile = AssistUtils.findVirtualFile(position.getFile());
            if (virtualFile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return new ChangeTarget(project, virtualFile, psiFile, position.getOffset());
        }
        return null;
    }

    private static int getLinkedEditConvertedOffset(@NotNull Project project, @NotNull VirtualFile file, int linkedEditOffset, @NotNull List<SourceEditInfo> editInfos) {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(18);
        }
        if (file == null) {
            AssistUtils.$$$reportNull$$$0(19);
        }
        if (editInfos == null) {
            AssistUtils.$$$reportNull$$$0(20);
        }
        for (SourceEditInfo info : editInfos) {
            if (linkedEditOffset < info.resultingOriginalOffset || linkedEditOffset > info.resultingOriginalOffset + info.originalReplacement.length()) continue;
            String substring = info.originalReplacement.substring(0, linkedEditOffset - info.resultingOriginalOffset);
            int crlfCount = StringUtil.getOccurrenceCount((String)substring, (String)"\r\n");
            return info.resultingConvertedOffset + linkedEditOffset - info.resultingOriginalOffset - crlfCount;
        }
        int leOffset = linkedEditOffset;
        for (int i = editInfos.size() - 1; i >= 0; --i) {
            SourceEditInfo info = editInfos.get(i);
            if (linkedEditOffset < info.originalOffset) continue;
            leOffset -= info.originalReplacement.length();
            leOffset += info.originalLength;
        }
        leOffset = DartAnalysisServerService.getInstance(project).getConvertedOffset(file, leOffset);
        for (SourceEditInfo info : editInfos) {
            if (leOffset < info.convertedOffset) continue;
            leOffset -= info.convertedLength;
            leOffset += info.normalizedReplacement.length();
        }
        return leOffset;
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull SourceFileEdit fileEdit) {
        if (fileEdit == null) {
            AssistUtils.$$$reportNull$$$0(21);
        }
        String path = fileEdit.getFile();
        return AssistUtils.findVirtualFile(path);
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull String path) {
        if (path == null) {
            AssistUtils.$$$reportNull$$$0(22);
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private static boolean isInContent(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(23);
        }
        if (file == null) {
            AssistUtils.$$$reportNull$$$0(24);
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @Nullable
    public static Editor navigate(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(25);
        }
        if (file == null) {
            AssistUtils.$$$reportNull$$$0(26);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, offset);
        descriptor.setScrollType(ScrollType.MAKE_VISIBLE);
        descriptor.navigate(true);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        return fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
    }

    private static void runLinkedEdits(@NotNull Project project, @NotNull SourceChange sourceChange, @NotNull ChangeTarget target, @NotNull List<SourceEditInfo> sourceEditInfos) {
        int caretOffset;
        Editor editor;
        if (project == null) {
            AssistUtils.$$$reportNull$$$0(27);
        }
        if (sourceChange == null) {
            AssistUtils.$$$reportNull$$$0(28);
        }
        if (target == null) {
            AssistUtils.$$$reportNull$$$0(29);
        }
        if (sourceEditInfos == null) {
            AssistUtils.$$$reportNull$$$0(30);
        }
        if ((editor = AssistUtils.navigate(project, target.virtualFile, caretOffset = AssistUtils.getLinkedEditConvertedOffset(project, target.virtualFile, target.originalOffset, sourceEditInfos))) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)target.psiFile);
        boolean hasTextRanges = false;
        int groupIndex = 0;
        for (LinkedEditGroup group : sourceChange.getLinkedEditGroups()) {
            String mainVar = "group_" + groupIndex++;
            boolean firstPosition = true;
            ++groupIndex;
            for (Position position : group.getPositions()) {
                if (!FileUtil.toSystemIndependentName((String)position.getFile()).equals(target.virtualFile.getPath())) continue;
                hasTextRanges = true;
                int offset = AssistUtils.getLinkedEditConvertedOffset(project, target.virtualFile, position.getOffset(), sourceEditInfos);
                int end = offset + group.getLength();
                TextRange range = new TextRange(offset, end);
                if (firstPosition) {
                    firstPosition = false;
                    String text = editor.getDocument().getText(range);
                    DartLookupExpression expression = new DartLookupExpression(text, group.getSuggestions());
                    builder.replaceRange(range, mainVar, (Expression)expression, true);
                    continue;
                }
                String positionVar = mainVar + "_" + offset;
                builder.replaceElement(range, positionVar, mainVar, false);
            }
        }
        if (hasTextRanges) {
            builder.run(editor, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEdit";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 17: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceChange";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedIds";
                break;
            }
            case 8: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edits";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/assists/AssistUtils";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editInfos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/assists/AssistUtils";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFilesChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFileEdit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applySourceChange";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applySourceEdits";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentFilesChanges";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findChangeTarget";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedEditConvertedOffset";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runLinkedEdits";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applySourceChange$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SourceEditInfo {
        private final int originalOffset;
        private int resultingOriginalOffset;
        private final int convertedOffset;
        private int resultingConvertedOffset;
        private final int originalLength;
        private final int convertedLength;
        private final String originalReplacement;
        private final String normalizedReplacement;

        public SourceEditInfo(int originalOffset, int convertedOffset, int originalLength, int convertedLength, String originalReplacement, String normalizedReplacement) {
            this.originalOffset = originalOffset;
            this.resultingOriginalOffset = originalOffset;
            this.convertedOffset = convertedOffset;
            this.resultingConvertedOffset = convertedOffset;
            this.originalLength = originalLength;
            this.convertedLength = convertedLength;
            this.originalReplacement = originalReplacement;
            this.normalizedReplacement = normalizedReplacement;
        }
    }
}

