/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

class TextLabelCustomElementRenderer
implements EditorCustomElementRenderer {
    private static TextAttributesKey TEXT_ATTRIBUTES = DefaultLanguageHighlighterColors.LINE_COMMENT;
    private final String label;

    TextLabelCustomElementRenderer(@NotNull String label) {
        if (label == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(0);
        }
        this.label = " " + label;
    }

    private static FontInfo getFontInfo(@NotNull Editor editor) {
        if (editor == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(1);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        FontPreferences fontPreferences = colorsScheme.getFontPreferences();
        TextAttributes attributes = editor.getColorsScheme().getAttributes(TEXT_ATTRIBUTES);
        int fontStyle = attributes == null ? 0 : attributes.getFontType();
        return ComplementaryFontsRegistry.getFontAbleToDisplay((int)97, (int)fontStyle, (FontPreferences)fontPreferences, (FontRenderContext)FontInfo.getFontRenderContext((Component)editor.getContentComponent()));
    }

    public int calcWidthInPixels(@NotNull Editor editor) {
        if (editor == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(2);
        }
        FontInfo fontInfo = TextLabelCustomElementRenderer.getFontInfo(editor);
        return fontInfo.fontMetrics().stringWidth(this.label);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes attributes;
        if (editor == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(4);
        }
        if (r == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(5);
        }
        if (textAttributes == null) {
            TextLabelCustomElementRenderer.$$$reportNull$$$0(6);
        }
        if ((attributes = editor.getColorsScheme().getAttributes(TEXT_ATTRIBUTES)) == null) {
            return;
        }
        Color fgColor = attributes.getForegroundColor();
        if (fgColor == null) {
            return;
        }
        g.setColor(fgColor);
        FontInfo fontInfo = TextLabelCustomElementRenderer.getFontInfo(editor);
        int ascent = editor instanceof EditorImpl ? ((EditorImpl)editor).getAscent() : fontInfo.fontMetrics().getAscent();
        g.setFont(fontInfo.getFont());
        g.drawString(this.label, r.x, r.y + ascent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/analyzer/TextLabelCustomElementRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFontInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calcWidthInPixels";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

