/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.intellij.ProjectTopics;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartServerRootsHandler {
    private final Project myProject;
    private final List<String> myIncludedRoots = new SmartList();
    private final List<String> myExcludedRoots = new SmartList();

    public DartServerRootsHandler(Project project) {
        this.myProject = project;
    }

    public void reset() {
        this.myIncludedRoots.clear();
        this.myExcludedRoots.clear();
    }

    public void ensureProjectServed() {
        assert (this.myIncludedRoots.isEmpty());
        assert (this.myExcludedRoots.isEmpty());
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            this.updateRoots();
            DartAnalysisServerService das = DartAnalysisServerService.getInstance(this.myProject);
            das.updateCurrentFile();
            das.updateVisibleFiles();
        });
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DartServerRootsHandler.this.updateRoots();
            }
        });
    }

    private void updateRoots() {
        DartSdk sdk = DartSdk.getDartSdk(this.myProject);
        if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
            DartAnalysisServerService.getInstance(this.myProject).stopServer();
        }
        SmartList newIncludedRoots = new SmartList();
        SmartList newExcludedRoots = new SmartList();
        if (sdk != null) {
            String dotIdeaPath = PathUtil.getParentPath((String)this.myProject.getProjectFilePath());
            if (dotIdeaPath.endsWith("/.idea")) {
                newExcludedRoots.add(FileUtil.toSystemDependentName((String)dotIdeaPath));
            }
            for (Module module : DartSdkLibUtil.getModulesWithDartSdkEnabled(this.myProject)) {
                Set<String> excludedPackageSymlinkUrls = DartServerRootsHandler.getExcludedPackageSymlinkUrls(module);
                for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                    String contentEntryUrl = contentEntry.getUrl();
                    if (!contentEntryUrl.startsWith("file://")) continue;
                    newIncludedRoots.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)contentEntryUrl)));
                    for (String excludedUrl : contentEntry.getExcludeFolderUrls()) {
                        if (!excludedUrl.startsWith(contentEntryUrl) || excludedPackageSymlinkUrls.contains(excludedUrl)) continue;
                        newExcludedRoots.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)excludedUrl)));
                    }
                }
            }
        }
        if (!this.myIncludedRoots.equals(newIncludedRoots) || !this.myExcludedRoots.equals(newExcludedRoots)) {
            this.myIncludedRoots.clear();
            this.myExcludedRoots.clear();
            if (DartAnalysisServerService.getInstance(this.myProject).updateRoots((List<String>)newIncludedRoots, (List<String>)newExcludedRoots)) {
                this.myIncludedRoots.addAll((Collection<String>)newIncludedRoots);
                this.myExcludedRoots.addAll((Collection<String>)newExcludedRoots);
            }
        }
    }

    private static Set<String> getExcludedPackageSymlinkUrls(@NotNull Module module) {
        if (module == null) {
            DartServerRootsHandler.$$$reportNull$$$0(0);
        }
        THashSet result = new THashSet();
        Collection pubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)module.getProject(), (String)"pubspec.yaml", (GlobalSearchScope)module.getModuleContentScope());
        for (VirtualFile pubspecYamlFile : pubspecYamlFiles) {
            result.addAll(DartProjectComponent.getExcludedPackageSymlinkUrls(module.getProject(), pubspecYamlFile));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/analyzer/DartServerRootsHandler", "getExcludedPackageSymlinkUrls"));
    }
}

