/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartClosingLabelManager;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.ClosingLabel;
import org.dartlang.analysis.server.protocol.HighlightRegion;
import org.dartlang.analysis.server.protocol.ImplementedClass;
import org.dartlang.analysis.server.protocol.ImplementedMember;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.NavigationTarget;
import org.dartlang.analysis.server.protocol.Outline;
import org.dartlang.analysis.server.protocol.OverriddenMember;
import org.dartlang.analysis.server.protocol.OverrideMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerData {
    private final DartAnalysisServerService myService;
    private EventDispatcher<OutlineListener> myEventDispatcher;
    private final Map<String, List<DartError>> myErrorData;
    private final Map<String, List<DartHighlightRegion>> myHighlightData;
    private final Map<String, List<DartNavigationRegion>> myNavigationData;
    private final Map<String, List<DartOverrideMember>> myOverrideData;
    private final Map<String, List<DartRegion>> myImplementedClassData;
    private final Map<String, List<DartRegion>> myImplementedMemberData;
    private final Map<String, Outline> myOutlineData;
    private final Set<String> myFilePathsWithUnsentChanges;
    private final Set<String> myFilePathsWithLostErrorInfo;

    DartServerData(@NotNull DartAnalysisServerService service) {
        if (service == null) {
            DartServerData.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher = EventDispatcher.create(OutlineListener.class);
        this.myErrorData = Collections.synchronizedMap(new THashMap());
        this.myHighlightData = Collections.synchronizedMap(new THashMap());
        this.myNavigationData = Collections.synchronizedMap(new THashMap());
        this.myOverrideData = Collections.synchronizedMap(new THashMap());
        this.myImplementedClassData = Collections.synchronizedMap(new THashMap());
        this.myImplementedMemberData = Collections.synchronizedMap(new THashMap());
        this.myOutlineData = Collections.synchronizedMap(new THashMap());
        this.myFilePathsWithUnsentChanges = Sets.newConcurrentHashSet();
        this.myFilePathsWithLostErrorInfo = Sets.newConcurrentHashSet();
        this.myService = service;
    }

    boolean isErrorInfoLost(@NotNull String filePath) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(1);
        }
        return this.myFilePathsWithLostErrorInfo.contains(filePath);
    }

    boolean computedErrors(@NotNull String filePath, @NotNull List<AnalysisError> errors, boolean restartHighlighting) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(2);
        }
        if (errors == null) {
            DartServerData.$$$reportNull$$$0(3);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return false;
        }
        ArrayList<DartError> newErrors = new ArrayList<DartError>(errors.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (AnalysisError error : errors) {
            int offset = this.myService.getConvertedOffset(file, error.getLocation().getOffset());
            int length = this.myService.getConvertedOffset(file, error.getLocation().getOffset() + error.getLocation().getLength()) - offset;
            newErrors.add(new DartError(error, offset, length));
        }
        this.myFilePathsWithLostErrorInfo.remove(filePath);
        this.myErrorData.put(filePath, newErrors);
        if (restartHighlighting) {
            this.forceFileAnnotation(file, false);
        }
        return true;
    }

    void computedClosingLabels(@NotNull String filePath, @NotNull List<ClosingLabel> labels) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(4);
        }
        if (labels == null) {
            DartServerData.$$$reportNull$$$0(5);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        DartClosingLabelManager.getInstance().computedClosingLabels(this.myService.getProject(), FileUtil.toSystemIndependentName((String)filePath), labels);
    }

    void computedHighlights(@NotNull String filePath, @NotNull List<HighlightRegion> regions) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(6);
        }
        if (regions == null) {
            DartServerData.$$$reportNull$$$0(7);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartHighlightRegion> newRegions = new ArrayList<DartHighlightRegion>(regions.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (HighlightRegion region : regions) {
            if (region.getLength() <= 0) continue;
            int offset = this.myService.getConvertedOffset(file, region.getOffset());
            int length = this.myService.getConvertedOffset(file, region.getOffset() + region.getLength()) - offset;
            newRegions.add(new DartHighlightRegion(offset, length, region.getType()));
        }
        this.myHighlightData.put(filePath, newRegions);
        this.forceFileAnnotation(file, false);
    }

    void computedNavigation(@NotNull String filePath, @NotNull List<NavigationRegion> regions) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(8);
        }
        if (regions == null) {
            DartServerData.$$$reportNull$$$0(9);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartNavigationRegion> newRegions = new ArrayList<DartNavigationRegion>(regions.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (NavigationRegion region : regions) {
            if (region.getLength() <= 0) continue;
            DartNavigationRegion dartNavigationRegion = DartServerData.createDartNavigationRegion(this.myService, file, region);
            newRegions.add(dartNavigationRegion);
        }
        this.myNavigationData.put(filePath, newRegions);
        this.forceFileAnnotation(file, true);
    }

    void computedOutline(@NotNull String filePath, @NotNull Outline outline) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(10);
        }
        if (outline == null) {
            DartServerData.$$$reportNull$$$0(11);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        this.myOutlineData.put(filePath, outline);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (filePath == null) {
                DartServerData.$$$reportNull$$$0(43);
            }
            ((OutlineListener)this.myEventDispatcher.getMulticaster()).outlineUpdated(filePath);
        }, ModalityState.NON_MODAL, this.myService.getProject().getDisposed());
    }

    @NotNull
    static DartNavigationRegion createDartNavigationRegion(@NotNull DartAnalysisServerService service, @Nullable VirtualFile file, @NotNull NavigationRegion region) {
        if (service == null) {
            DartServerData.$$$reportNull$$$0(12);
        }
        if (region == null) {
            DartServerData.$$$reportNull$$$0(13);
        }
        int offset = service.getConvertedOffset(file, region.getOffset());
        int length = service.getConvertedOffset(file, region.getOffset() + region.getLength()) - offset;
        SmartList targets = new SmartList();
        for (NavigationTarget target : region.getTargetObjects()) {
            targets.add((Object)new DartNavigationTarget(target));
        }
        DartNavigationRegion dartNavigationRegion = new DartNavigationRegion(offset, length, (List<DartNavigationTarget>)targets);
        if (dartNavigationRegion == null) {
            DartServerData.$$$reportNull$$$0(14);
        }
        return dartNavigationRegion;
    }

    void computedOverrides(@NotNull String filePath, @NotNull List<OverrideMember> overrides) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(15);
        }
        if (overrides == null) {
            DartServerData.$$$reportNull$$$0(16);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartOverrideMember> newOverrides = new ArrayList<DartOverrideMember>(overrides.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (OverrideMember override : overrides) {
            if (override.getLength() <= 0) continue;
            int offset = this.myService.getConvertedOffset(file, override.getOffset());
            int length = this.myService.getConvertedOffset(file, override.getOffset() + override.getLength()) - offset;
            newOverrides.add(new DartOverrideMember(offset, length, override.getSuperclassMember(), override.getInterfaceMembers()));
        }
        this.myOverrideData.put(filePath, newOverrides);
        this.forceFileAnnotation(file, false);
    }

    void computedImplemented(@NotNull String filePath, @NotNull List<ImplementedClass> implementedClasses, @NotNull List<ImplementedMember> implementedMembers) {
        boolean bl;
        List<DartRegion> oldMembers;
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(17);
        }
        if (implementedClasses == null) {
            DartServerData.$$$reportNull$$$0(18);
        }
        if (implementedMembers == null) {
            DartServerData.$$$reportNull$$$0(19);
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        ArrayList<DartRegion> newImplementedClasses = new ArrayList<DartRegion>(implementedClasses.size());
        for (ImplementedClass implementedClass : implementedClasses) {
            int offset = this.myService.getConvertedOffset(file, implementedClass.getOffset());
            int length = this.myService.getConvertedOffset(file, implementedClass.getOffset() + implementedClass.getLength()) - offset;
            newImplementedClasses.add(new DartRegion(offset, length));
        }
        ArrayList<DartRegion> newImplementedMembers = new ArrayList<DartRegion>(implementedMembers.size());
        for (ImplementedMember implementedMember : implementedMembers) {
            int offset = this.myService.getConvertedOffset(file, implementedMember.getOffset());
            int length = this.myService.getConvertedOffset(file, implementedMember.getOffset() + implementedMember.getLength()) - offset;
            newImplementedMembers.add(new DartRegion(offset, length));
        }
        boolean bl2 = false;
        List<DartRegion> oldClasses = this.myImplementedClassData.get(filePath);
        if (oldClasses == null || !oldClasses.equals(newImplementedClasses)) {
            boolean bl3 = true;
            this.myImplementedClassData.put(filePath, newImplementedClasses);
        }
        if ((oldMembers = this.myImplementedMemberData.get(filePath)) == null || !oldMembers.equals(newImplementedMembers)) {
            bl = true;
            this.myImplementedMemberData.put(filePath, newImplementedMembers);
        }
        if (bl) {
            this.forceFileAnnotation(file, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<DartError> getErrors(@NotNull SearchScope scope) {
        if (scope == null) {
            DartServerData.$$$reportNull$$$0(20);
        }
        ArrayList<DartError> errors = new ArrayList<DartError>();
        Map<String, List<DartError>> map = this.myErrorData;
        synchronized (map) {
            for (Map.Entry<String, List<DartError>> entry : this.myErrorData.entrySet()) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(entry.getKey());
                if (file == null || !scope.contains(file)) continue;
                errors.addAll((Collection<DartError>)entry.getValue());
            }
        }
        ArrayList<DartError> arrayList = errors;
        if (arrayList == null) {
            DartServerData.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    List<DartError> getErrors(@NotNull VirtualFile file) {
        List<DartError> errors;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(22);
        }
        List<DartError> list = (errors = this.myErrorData.get(file.getPath())) != null ? errors : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    List<DartHighlightRegion> getHighlight(@NotNull VirtualFile file) {
        List<DartHighlightRegion> regions;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(24);
        }
        List<DartHighlightRegion> list = (regions = this.myHighlightData.get(file.getPath())) != null ? regions : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    List<DartNavigationRegion> getNavigation(@NotNull VirtualFile file) {
        List<DartNavigationRegion> regions;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(26);
        }
        List<DartNavigationRegion> list = (regions = this.myNavigationData.get(file.getPath())) != null ? regions : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    List<DartOverrideMember> getOverrideMembers(@NotNull VirtualFile file) {
        List<DartOverrideMember> regions;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(28);
        }
        List<DartOverrideMember> list = (regions = this.myOverrideData.get(file.getPath())) != null ? regions : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    List<DartRegion> getImplementedClasses(@NotNull VirtualFile file) {
        List<DartRegion> classes;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(30);
        }
        List<DartRegion> list = (classes = this.myImplementedClassData.get(file.getPath())) != null ? classes : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    List<DartRegion> getImplementedMembers(@NotNull VirtualFile file) {
        List<DartRegion> classes;
        if (file == null) {
            DartServerData.$$$reportNull$$$0(32);
        }
        List<DartRegion> list = (classes = this.myImplementedMemberData.get(file.getPath())) != null ? classes : Collections.emptyList();
        if (list == null) {
            DartServerData.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    Outline getOutline(@NotNull VirtualFile file) {
        if (file == null) {
            DartServerData.$$$reportNull$$$0(34);
        }
        return this.myOutlineData.get(file.getPath());
    }

    void addOutlineListener(@NotNull OutlineListener listener) {
        if (listener == null) {
            DartServerData.$$$reportNull$$$0(35);
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    void removeOutlineListener(@NotNull OutlineListener listener) {
        if (listener == null) {
            DartServerData.$$$reportNull$$$0(36);
        }
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private void forceFileAnnotation(@Nullable VirtualFile file, boolean clearCache) {
        if (file != null) {
            Project project = this.myService.getProject();
            if (clearCache) {
                ResolveCache.getInstance((Project)project).clearCache(true);
            }
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project).restart(), ModalityState.NON_MODAL, project.getDisposed());
        }
    }

    void onFilesContentUpdated() {
        this.myFilePathsWithUnsentChanges.clear();
    }

    void onFileClosed(@NotNull VirtualFile file) {
        if (file == null) {
            DartServerData.$$$reportNull$$$0(37);
        }
        this.myHighlightData.remove(file.getPath());
        this.myNavigationData.remove(file.getPath());
        this.myOverrideData.remove(file.getPath());
        this.myImplementedClassData.remove(file.getPath());
        this.myImplementedMemberData.remove(file.getPath());
        this.myOutlineData.remove(file.getPath());
    }

    void onFlushedResults(@NotNull List<String> filePaths) {
        if (filePaths == null) {
            DartServerData.$$$reportNull$$$0(38);
        }
        if (!this.myErrorData.isEmpty()) {
            for (String path : filePaths) {
                this.myErrorData.remove(path);
            }
        }
        if (!this.myHighlightData.isEmpty()) {
            for (String path : filePaths) {
                this.myHighlightData.remove(path);
            }
        }
        if (!this.myNavigationData.isEmpty()) {
            for (String path : filePaths) {
                this.myNavigationData.remove(path);
            }
        }
        if (!this.myOverrideData.isEmpty()) {
            for (String path : filePaths) {
                this.myOverrideData.remove(path);
            }
        }
        if (!this.myImplementedClassData.isEmpty()) {
            for (String path : filePaths) {
                this.myImplementedClassData.remove(path);
            }
        }
        if (!this.myImplementedMemberData.isEmpty()) {
            for (String path : filePaths) {
                this.myImplementedMemberData.remove(path);
            }
        }
        if (!this.myOutlineData.isEmpty()) {
            for (String path : filePaths) {
                this.myOutlineData.remove(path);
            }
        }
    }

    void clearData() {
        this.myErrorData.clear();
        this.myHighlightData.clear();
        this.myNavigationData.clear();
        this.myOverrideData.clear();
        this.myImplementedClassData.clear();
        this.myImplementedMemberData.clear();
        this.myOutlineData.clear();
    }

    void onDocumentChanged(@NotNull DocumentEvent e) {
        VirtualFile file;
        if (e == null) {
            DartServerData.$$$reportNull$$$0(39);
        }
        if (!DartAnalysisServerService.isLocalAnalyzableFile(file = FileDocumentManager.getInstance().getFile(e.getDocument()))) {
            return;
        }
        String filePath = file.getPath();
        this.myFilePathsWithUnsentChanges.add(filePath);
        boolean someRegionDeleted = DartServerData.updateRegionsDeletingTouched(filePath, this.myErrorData.get(filePath), e);
        if (someRegionDeleted) {
            this.myFilePathsWithLostErrorInfo.add(filePath);
        }
        DartServerData.updateRegionsUpdatingTouched(this.myHighlightData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myNavigationData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myOverrideData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myImplementedClassData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myImplementedMemberData.get(filePath), e);
    }

    private static boolean updateRegionsDeletingTouched(@NotNull String filePath, @Nullable List<? extends DartRegion> regions, @NotNull DocumentEvent e) {
        if (filePath == null) {
            DartServerData.$$$reportNull$$$0(40);
        }
        if (e == null) {
            DartServerData.$$$reportNull$$$0(41);
        }
        if (regions == null) {
            return false;
        }
        boolean regionDeleted = false;
        int eventOffset = e.getOffset();
        int deltaLength = e.getNewLength() - e.getOldLength();
        Iterator<? extends DartRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            DartRegion region = iterator.next();
            if (region instanceof DartNavigationRegion) {
                for (DartNavigationTarget target : ((DartNavigationRegion)region).getTargets()) {
                    if (!target.myFile.equals(filePath) || target.myConvertedOffset < eventOffset) continue;
                    DartNavigationTarget dartNavigationTarget = target;
                    dartNavigationTarget.myConvertedOffset = dartNavigationTarget.myConvertedOffset + deltaLength;
                }
            }
            if (deltaLength > 0) {
                if (eventOffset <= region.myOffset) {
                    region.myOffset += deltaLength;
                    continue;
                }
                if (region.myOffset >= eventOffset || eventOffset >= region.myOffset + region.myLength) continue;
                iterator.remove();
                regionDeleted = true;
                continue;
            }
            if (deltaLength >= 0) continue;
            int eventRightOffset = eventOffset - deltaLength;
            if (eventRightOffset <= region.myOffset) {
                region.myOffset += deltaLength;
                continue;
            }
            if (eventOffset >= region.myOffset + region.myLength) continue;
            iterator.remove();
            regionDeleted = true;
        }
        return regionDeleted;
    }

    private static void updateRegionsUpdatingTouched(@Nullable List<? extends DartRegion> regions, @NotNull DocumentEvent e) {
        if (e == null) {
            DartServerData.$$$reportNull$$$0(42);
        }
        if (regions == null) {
            return;
        }
        int eventOffset = e.getOffset();
        int deltaLength = e.getNewLength() - e.getOldLength();
        Iterator<? extends DartRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            DartRegion region = iterator.next();
            if (deltaLength > 0) {
                if (eventOffset <= region.myOffset) {
                    region.myOffset += deltaLength;
                    continue;
                }
                if (region.myOffset >= eventOffset || eventOffset >= region.myOffset + region.myLength) continue;
                region.myLength += deltaLength;
                continue;
            }
            if (deltaLength >= 0) continue;
            int eventRightOffset = eventOffset - deltaLength;
            int regionRightOffset = region.myOffset + region.myLength;
            if (eventRightOffset <= region.myOffset) {
                region.myOffset += deltaLength;
                continue;
            }
            if (region.myOffset <= eventOffset && eventRightOffset <= regionRightOffset && region.myLength != -deltaLength) {
                region.myLength += deltaLength;
                continue;
            }
            if (eventOffset >= regionRightOffset) continue;
            iterator.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/analyzer/DartServerData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrides";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedClasses";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedMembers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartServerData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDartNavigationRegion";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlight";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigation";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverrideMembers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedClasses";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isErrorInfoLost";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computedErrors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computedClosingLabels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computedHighlights";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computedNavigation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computedOutline";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDartNavigationRegion";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computedOverrides";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computedImplemented";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getHighlight";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNavigation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOverrideMembers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedClasses";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedMembers";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOutline";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addOutlineListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeOutlineListener";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "onFileClosed";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "onFlushedResults";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChanged";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateRegionsDeletingTouched";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateRegionsUpdatingTouched";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computedOutline$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartOverrideMember
    extends DartRegion {
        @Nullable
        private final OverriddenMember mySuperclassMember;
        @Nullable
        private final List<OverriddenMember> myInterfaceMembers;

        private DartOverrideMember(int offset, int length, @Nullable OverriddenMember superclassMember, @Nullable List<OverriddenMember> interfaceMembers) {
            super(offset, length);
            this.mySuperclassMember = superclassMember;
            this.myInterfaceMembers = interfaceMembers;
        }

        @Nullable
        public OverriddenMember getSuperclassMember() {
            return this.mySuperclassMember;
        }

        @Nullable
        public List<OverriddenMember> getInterfaceMembers() {
            return this.myInterfaceMembers;
        }
    }

    public static class DartNavigationTarget {
        private final String myFile;
        private final int myOriginalOffset;
        private final String myKind;
        private int myConvertedOffset;

        private DartNavigationTarget(@NotNull NavigationTarget target) {
            if (target == null) {
                DartNavigationTarget.$$$reportNull$$$0(0);
            }
            this.myConvertedOffset = -1;
            this.myFile = FileUtil.toSystemIndependentName((String)target.getFile().trim()).intern();
            this.myOriginalOffset = target.getOffset();
            this.myKind = target.getKind().intern();
        }

        public String getFile() {
            return this.myFile;
        }

        public int getOffset(@NotNull Project project, @Nullable VirtualFile file) {
            if (project == null) {
                DartNavigationTarget.$$$reportNull$$$0(1);
            }
            if (this.myConvertedOffset == -1) {
                this.myConvertedOffset = DartAnalysisServerService.getInstance(project).getConvertedOffset(file, this.myOriginalOffset);
            }
            return this.myConvertedOffset;
        }

        public String getKind() {
            return this.myKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartServerData$DartNavigationTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DartNavigationRegion
    extends DartRegion {
        private final List<DartNavigationTarget> myTargets;

        DartNavigationRegion(int offset, int length, @NotNull List<DartNavigationTarget> targets) {
            if (targets == null) {
                DartNavigationRegion.$$$reportNull$$$0(0);
            }
            super(offset, length);
            this.myTargets = targets;
        }

        public String toString() {
            return "DartNavigationRegion(" + this.myOffset + ", " + this.myLength + ")";
        }

        public List<DartNavigationTarget> getTargets() {
            return this.myTargets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/lang/dart/analyzer/DartServerData$DartNavigationRegion", "<init>"));
        }
    }

    public static class DartError
    extends DartRegion {
        private final String myAnalysisErrorFileSD;
        private final String mySeverity;
        @Nullable
        private final String myCode;
        private final String myMessage;

        private DartError(@NotNull AnalysisError error, int correctedOffset, int correctedLength) {
            if (error == null) {
                DartError.$$$reportNull$$$0(0);
            }
            super(correctedOffset, correctedLength);
            this.myAnalysisErrorFileSD = error.getLocation().getFile().intern();
            this.mySeverity = error.getSeverity().intern();
            this.myCode = error.getCode() == null ? null : error.getCode().intern();
            this.myMessage = error.getMessage();
        }

        public String getAnalysisErrorFileSD() {
            return this.myAnalysisErrorFileSD;
        }

        public String getSeverity() {
            return this.mySeverity;
        }

        public boolean isError() {
            return this.mySeverity.equals("ERROR");
        }

        @Nullable
        public String getCode() {
            return this.myCode;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/lang/dart/analyzer/DartServerData$DartError", "<init>"));
        }
    }

    public static class DartHighlightRegion
    extends DartRegion {
        private final String type;

        private DartHighlightRegion(int offset, int length, @NotNull String type) {
            if (type == null) {
                DartHighlightRegion.$$$reportNull$$$0(0);
            }
            super(offset, length);
            this.type = type.intern();
        }

        public String getType() {
            return this.type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/lang/dart/analyzer/DartServerData$DartHighlightRegion", "<init>"));
        }
    }

    public static class DartRegion {
        protected int myOffset;
        protected int myLength;

        DartRegion(int offset, int length) {
            this.myOffset = offset;
            this.myLength = length;
        }

        public final int getOffset() {
            return this.myOffset;
        }

        public final int getLength() {
            return this.myLength;
        }

        public boolean equals(Object o) {
            return o instanceof DartRegion && this.myOffset == ((DartRegion)o).myOffset && this.myLength == ((DartRegion)o).myLength;
        }

        public int hashCode() {
            return this.myOffset * 31 + this.myLength;
        }
    }

    public static interface OutlineListener
    extends EventListener {
        public void outlineUpdated(@NotNull String var1);
    }
}

