/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.TextLabelCustomElementRenderer;
import com.jetbrains.lang.dart.ide.codeInsight.DartCodeInsightSettings;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.dartlang.analysis.server.protocol.ClosingLabel;
import org.jetbrains.annotations.NotNull;

public class DartClosingLabelManager {
    private EventDispatcher<PreferenceChangeListener> myEventDispatcher = EventDispatcher.create(PreferenceChangeListener.class);

    public DartClosingLabelManager() {
        this.addListener(new PreferenceChangeListener(){

            @Override
            public void closingLabelPreferenceChanged() {
                if (!DartClosingLabelManager.this.getShowClosingLabels()) {
                    UIUtil.invokeLaterIfNeeded(() -> DartClosingLabelManager.clearAllInlays());
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public static DartClosingLabelManager getInstance() {
        return (DartClosingLabelManager)ServiceManager.getService(DartClosingLabelManager.class);
    }

    public void setShowClosingLabels(boolean value) {
        DartCodeInsightSettings settings = DartCodeInsightSettings.getInstance();
        if (settings.SHOW_CLOSING_LABELS != value) {
            settings.SHOW_CLOSING_LABELS = value;
            ((PreferenceChangeListener)this.myEventDispatcher.getMulticaster()).closingLabelPreferenceChanged();
        }
    }

    public boolean getShowClosingLabels() {
        return DartCodeInsightSettings.getInstance().SHOW_CLOSING_LABELS;
    }

    public void addListener(@NotNull PreferenceChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            DartClosingLabelManager.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DartClosingLabelManager.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    void computedClosingLabels(@NotNull Project project, @NotNull String filePath, @NotNull List<ClosingLabel> labels) {
        if (project == null) {
            DartClosingLabelManager.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            DartClosingLabelManager.$$$reportNull$$$0(3);
        }
        if (labels == null) {
            DartClosingLabelManager.$$$reportNull$$$0(4);
        }
        if (!this.getShowClosingLabels()) {
            return;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file == null) {
            return;
        }
        Runnable runnable = () -> {
            if (project == null) {
                DartClosingLabelManager.$$$reportNull$$$0(6);
            }
            if (labels == null) {
                DartClosingLabelManager.$$$reportNull$$$0(7);
            }
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                TextEditor textEditor = (TextEditor)fileEditor;
                Editor editor = textEditor.getEditor();
                InlayModel inlayModel = editor.getInlayModel();
                DartClosingLabelManager.clearEditorInlays(editor);
                labels.sort((label1, label2) -> label2.getOffset() - label1.getOffset());
                DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
                HashMap<Integer, String> lineText = new HashMap<Integer, String>();
                for (ClosingLabel label : labels) {
                    int offset = service.getConvertedOffset(file, label.getOffset() + label.getLength());
                    if (offset >= editor.getDocument().getTextLength()) {
                        lineText.clear();
                        break;
                    }
                    Integer line = editor.getDocument().getLineNumber(offset);
                    if (lineText.containsKey(line)) {
                        lineText.put(line, (String)lineText.get(line) + ", " + label.getLabel());
                        continue;
                    }
                    lineText.put(line, "// " + label.getLabel());
                }
                for (Integer line : lineText.keySet()) {
                    inlayModel.addInlineElement(editor.getDocument().getLineEndOffset(line.intValue()), true, (EditorCustomElementRenderer)new TextLabelCustomElementRenderer((String)lineText.get(line)));
                }
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void clearEditorInlays(@NotNull Editor editor) {
        if (editor == null) {
            DartClosingLabelManager.$$$reportNull$$$0(5);
        }
        List existingInlays = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        for (Inlay inlay : existingInlays) {
            if (!(inlay.getRenderer() instanceof TextLabelCustomElementRenderer)) continue;
            Disposer.dispose((Disposable)inlay);
        }
    }

    private static void clearAllInlays() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditor[] editors;
            for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                List existingInlays = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
                for (Inlay inlay : existingInlays) {
                    if (!(inlay.getRenderer() instanceof TextLabelCustomElementRenderer)) continue;
                    Disposer.dispose((Disposable)inlay);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartClosingLabelManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computedClosingLabels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearEditorInlays";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$computedClosingLabels$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface PreferenceChangeListener
    extends EventListener {
        public void closingLabelPreferenceChanged();
    }
}

