/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.AnalysisServerListenerAdapter;
import com.google.dart.server.CreateContextConsumer;
import com.google.dart.server.FindElementReferencesConsumer;
import com.google.dart.server.FormatConsumer;
import com.google.dart.server.GetAssistsConsumer;
import com.google.dart.server.GetErrorsConsumer;
import com.google.dart.server.GetFixesConsumer;
import com.google.dart.server.GetHoverConsumer;
import com.google.dart.server.GetImportedElementsConsumer;
import com.google.dart.server.GetNavigationConsumer;
import com.google.dart.server.GetPostfixCompletionConsumer;
import com.google.dart.server.GetRefactoringConsumer;
import com.google.dart.server.GetServerPortConsumer;
import com.google.dart.server.GetStatementCompletionConsumer;
import com.google.dart.server.GetSuggestionsConsumer;
import com.google.dart.server.GetTypeHierarchyConsumer;
import com.google.dart.server.ImportElementsConsumer;
import com.google.dart.server.IsPostfixCompletionApplicableConsumer;
import com.google.dart.server.ListPostfixCompletionTemplatesConsumer;
import com.google.dart.server.MapUriConsumer;
import com.google.dart.server.OrganizeDirectivesConsumer;
import com.google.dart.server.ResponseListener;
import com.google.dart.server.SortMembersConsumer;
import com.google.dart.server.generated.AnalysisServer;
import com.google.dart.server.internal.remote.DebugPrintStream;
import com.google.dart.server.internal.remote.RemoteAnalysisServerImpl;
import com.google.dart.server.internal.remote.StdioServerSocket;
import com.google.dart.server.utilities.logging.Logger;
import com.google.dart.server.utilities.logging.Logging;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileListener;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerMessages;
import com.jetbrains.lang.dart.analyzer.DartClosingLabelManager;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.analyzer.DartServerRootsHandler;
import com.jetbrains.lang.dart.analyzer.FileOffsetsManager;
import com.jetbrains.lang.dart.assists.DartQuickAssistIntention;
import com.jetbrains.lang.dart.assists.QuickAssistSet;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.ide.errorTreeView.DartFeedbackBuilder;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import com.jetbrains.lang.dart.ide.template.postfix.DartPostfixTemplateProvider;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateChecker;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.dartlang.analysis.server.protocol.AddContentOverlay;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.AnalysisErrorFixes;
import org.dartlang.analysis.server.protocol.AnalysisOptions;
import org.dartlang.analysis.server.protocol.AnalysisStatus;
import org.dartlang.analysis.server.protocol.ClosingLabel;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.HighlightRegion;
import org.dartlang.analysis.server.protocol.HoverInformation;
import org.dartlang.analysis.server.protocol.ImplementedClass;
import org.dartlang.analysis.server.protocol.ImplementedMember;
import org.dartlang.analysis.server.protocol.ImportedElements;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.Outline;
import org.dartlang.analysis.server.protocol.OverrideMember;
import org.dartlang.analysis.server.protocol.PostfixCompletionTemplate;
import org.dartlang.analysis.server.protocol.PubStatus;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.dartlang.analysis.server.protocol.RemoveContentOverlay;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SearchResult;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartAnalysisServerService
implements Disposable {
    public static final String MIN_SDK_VERSION = "1.12";
    private static final long UPDATE_FILES_TIMEOUT = 300L;
    private static final long CHECK_CANCELLED_PERIOD = 10L;
    private static final long SEND_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long EDIT_FORMAT_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private static final long EDIT_ORGANIZE_DIRECTIVES_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(300L);
    private static final long EDIT_SORT_MEMBERS_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private static final long GET_HOVER_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long GET_NAVIGATION_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long GET_ASSISTS_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long GET_FIXES_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long IMPORTED_ELEMENTS_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long POSTFIX_COMPLETION_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long POSTFIX_INITIALIZATION_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(5000L);
    private static final long STATEMENT_COMPLETION_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long GET_SUGGESTIONS_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long FIND_ELEMENT_REFERENCES_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long GET_TYPE_HIERARCHY_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long EXECUTION_CREATE_CONTEXT_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long EXECUTION_MAP_URI_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long ANALYSIS_IN_TESTS_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long TESTS_TIMEOUT_COEFF = 10L;
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance((String)"#com.jetbrains.lang.dart.analyzer.DartAnalysisServerService");
    private static final String STACK_TRACE_MARKER = "#0";
    private static final long MIN_DISRUPTION_TIME = 5000L;
    private static final int MAX_DISRUPTIONS_PER_SESSION = 20;
    private static final int DEBUG_LOG_CAPACITY = 30;
    private static final int MAX_DEBUG_LOG_LINE_LENGTH = 200;
    private static boolean ourIntentionsRegistered = false;
    @NotNull
    private final Project myProject;
    private boolean myInitializationOnServerStartupDone;
    private final Object myLock;
    @Nullable
    private AnalysisServer myServer;
    @Nullable
    private StdioServerSocket myServerSocket;
    @NotNull
    private String myServerVersion;
    @NotNull
    private String mySdkVersion;
    @Nullable
    private String mySdkHome;
    private final DartServerRootsHandler myRootsHandler;
    private final Map<String, Long> myFilePathWithOverlaidContentToTimestamp;
    private final List<String> myVisibleFiles;
    private final Set<Document> myChangedDocuments;
    private final Alarm myUpdateFilesAlarm;
    @NotNull
    private final Queue<CompletionInfo> myCompletionInfos;
    @NotNull
    private final Queue<SearchResultsSet> mySearchResultSets;
    @NotNull
    private final DartServerData myServerData;
    private volatile boolean myAnalysisInProgress;
    private volatile boolean myPubListInProgress;
    @NotNull
    private final Alarm myShowServerProgressAlarm;
    @Nullable
    private ProgressIndicator myProgressIndicator;
    private final Object myProgressLock;
    private boolean myHaveShownInitialProgress;
    private boolean mySentAnalysisBusy;
    @NotNull
    private final Set<String> myFilePathsWithErrors;
    @NotNull
    private final TObjectIntHashMap<String> myFolderPathsWithErrors;
    @NotNull
    private final TObjectIntHashMap<String> myFilePathToErrorsHash;
    @NotNull
    private final InteractiveErrorReporter myErrorReporter;
    @NotNull
    private final EvictingQueue<String> myDebugLog;
    @NotNull
    private final List<AnalysisServerListener> myAdditionalServerListeners;
    @NotNull
    private final List<ResponseListener> myResponseListeners;
    private static final String ENABLE_ANALYZED_FILES_SUBSCRIPTION_KEY = "com.jetbrains.lang.dart.analyzer.DartAnalysisServerService.enableAnalyzedFilesSubscription";
    private final AnalysisServerListener myAnalysisServerListener;

    public static String getClientId() {
        return ApplicationNamesInfo.getInstance().getFullProductName().replaceAll(" ", "-");
    }

    private static String getClientVersion() {
        return ApplicationInfo.getInstance().getApiVersion();
    }

    public static boolean isAnalyzedFilesSubscriptionEnabled() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return properties.getBoolean(ENABLE_ANALYZED_FILES_SUBSCRIPTION_KEY, false);
    }

    public static void setEnableAnalyzedFilesSubscription(boolean value) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(ENABLE_ANALYZED_FILES_SUBSCRIPTION_KEY, value, false);
    }

    private static int ensureNotZero(int i) {
        return i == 0 ? Integer.MAX_VALUE : i;
    }

    private void startShowingServerProgress() {
        if (!this.myHaveShownInitialProgress) {
            this.myHaveShownInitialProgress = true;
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, DartBundle.message("dart.analysis.progress.title", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (DartAnalysisServerService.this.myProject.isDisposed()) {
                        return;
                    }
                    if (!DartAnalysisServerService.this.myAnalysisInProgress && !DartAnalysisServerService.this.myPubListInProgress) {
                        return;
                    }
                    indicator.setText(DartBundle.message("dart.analysis.progress.title", new Object[0]));
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            LOG.error("wait() in EDT");
                        }
                    } else {
                        try {
                            DartAnalysisServerService.this.myProgressIndicator = indicator;
                            DartAnalysisServerService.this.waitWhileServerBusy();
                        }
                        finally {
                            DartAnalysisServerService.this.myProgressIndicator = null;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$2", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
        DartAnalysisServerMessages.sendAnalysisStarted(this.myProject, true);
        this.mySentAnalysisBusy = true;
    }

    public int getConvertedOffset(@Nullable VirtualFile file, int originalOffset) {
        if (originalOffset <= 0 || file == null) {
            return originalOffset;
        }
        return this.myFilePathWithOverlaidContentToTimestamp.containsKey(file.getPath()) ? originalOffset : FileOffsetsManager.getInstance().getConvertedOffset(file, originalOffset);
    }

    private int getOriginalOffset(@Nullable VirtualFile file, int convertedOffset) {
        if (file == null) {
            return convertedOffset;
        }
        return this.myFilePathWithOverlaidContentToTimestamp.containsKey(file.getPath()) ? convertedOffset : FileOffsetsManager.getInstance().getOriginalOffset(file, convertedOffset);
    }

    public int[] getConvertedOffsets(@NotNull VirtualFile file, int[] _offsets) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(0);
        }
        int[] offsets = new int[_offsets.length];
        for (int i = 0; i < _offsets.length; ++i) {
            offsets[i] = this.getConvertedOffset(file, _offsets[i]);
        }
        return offsets;
    }

    public int[] getConvertedLengths(@NotNull VirtualFile file, int[] _offsets, int[] _lengths) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(1);
        }
        int[] offsets = this.getConvertedOffsets(file, _offsets);
        int[] lengths = new int[_lengths.length];
        for (int i = 0; i < _lengths.length; ++i) {
            lengths[i] = this.getConvertedOffset(file, _offsets[i] + _lengths[i]) - offsets[i];
        }
        return lengths;
    }

    public static boolean isDartSdkVersionSufficient(@NotNull DartSdk sdk) {
        if (sdk == null) {
            DartAnalysisServerService.$$$reportNull$$$0(2);
        }
        return StringUtil.compareVersionNumbers((String)sdk.getVersion(), (String)MIN_SDK_VERSION) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletions(@NotNull VirtualFile file, @NotNull String completionId, @NotNull CompletionSuggestionConsumer consumer) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(3);
        }
        if (completionId == null) {
            DartAnalysisServerService.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            DartAnalysisServerService.$$$reportNull$$$0(5);
        }
        while (true) {
            ProgressManager.checkCanceled();
            Queue<CompletionInfo> queue = this.myCompletionInfos;
            synchronized (queue) {
                CompletionInfo completionInfo;
                while ((completionInfo = this.myCompletionInfos.poll()) != null) {
                    if (!completionInfo.myCompletionId.equals(completionId) || !completionInfo.isLast) continue;
                    for (CompletionSuggestion completion : completionInfo.myCompletions) {
                        int convertedReplacementOffset = this.getConvertedOffset(file, completionInfo.myOriginalReplacementOffset);
                        int convertedReplacementLength = this.getConvertedOffset(file, completionInfo.myOriginalReplacementLength);
                        consumer.consumeCompletionSuggestion(convertedReplacementOffset, convertedReplacementLength, completion);
                    }
                    return;
                }
                try {
                    this.myCompletionInfos.wait(10L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private void configureImportedLibraries(@NotNull Collection<String> filePaths) {
        if (filePaths == null) {
            DartAnalysisServerService.$$$reportNull$$$0(6);
        }
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
            if (filePaths == null) {
                DartAnalysisServerService.$$$reportNull$$$0(75);
            }
            DartAnalysisServerService.doConfigureImportedLibraries(this.myProject, filePaths);
        });
    }

    private static void doConfigureImportedLibraries(@NotNull Project project, @NotNull Collection<String> filePaths) {
        DartSdk sdk;
        if (project == null) {
            DartAnalysisServerService.$$$reportNull$$$0(7);
        }
        if (filePaths == null) {
            DartAnalysisServerService.$$$reportNull$$$0(8);
        }
        if ((sdk = DartSdk.getDartSdk(project)) == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        TreeSet<String> folderPaths = new TreeSet<String>();
        THashSet rootsToAddToLib = new THashSet();
        for (String path : filePaths) {
            if (path == null) continue;
            folderPaths.add(PathUtil.getParentPath((String)FileUtil.toSystemIndependentName((String)path)));
        }
        block1: for (String path : folderPaths) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (path.startsWith(sdk.getHomePath() + "/") || vFile != null && fileIndex.isInContent(vFile)) continue;
            for (String configuredPath : rootsToAddToLib) {
                if (!path.startsWith(configuredPath + "/")) continue;
                continue block1;
            }
            rootsToAddToLib.add(path);
        }
        Processor falseProcessor = item -> false;
        Condition moduleFilter = module -> {
            if (project == null) {
                DartAnalysisServerService.$$$reportNull$$$0(74);
            }
            return DartSdkLibUtil.isDartSdkEnabled(module) && !FilenameIndex.processFilesByName((String)"pubspec.yaml", (boolean)false, (Processor)falseProcessor, (GlobalSearchScope)module.getModuleContentScope(), (Project)project, null);
        };
        DartFileListener.DartLibInfo libInfo = new DartFileListener.DartLibInfo(true);
        libInfo.addRoots((Collection<String>)rootsToAddToLib);
        Library library = DartFileListener.updatePackagesLibraryRoots(project, libInfo);
        DartFileListener.updateDependenciesOnDartPackagesLibrary(project, (Condition<Module>)moduleFilter, library);
    }

    public DartAnalysisServerService(@NotNull Project project) {
        if (project == null) {
            DartAnalysisServerService.$$$reportNull$$$0(9);
        }
        this.myInitializationOnServerStartupDone = false;
        this.myLock = new Object();
        this.myServerVersion = "";
        this.mySdkVersion = "";
        this.mySdkHome = null;
        this.myFilePathWithOverlaidContentToTimestamp = new THashMap();
        this.myVisibleFiles = new ArrayList<String>();
        this.myChangedDocuments = new THashSet();
        this.myCompletionInfos = new LinkedList<CompletionInfo>();
        this.mySearchResultSets = new LinkedList<SearchResultsSet>();
        this.myProgressLock = new Object();
        this.myFilePathsWithErrors = new THashSet();
        this.myFolderPathsWithErrors = new TObjectIntHashMap();
        this.myFilePathToErrorsHash = new TObjectIntHashMap();
        this.myErrorReporter = new InteractiveErrorReporter();
        this.myDebugLog = EvictingQueue.create((int)30);
        this.myAdditionalServerListeners = new SmartList();
        this.myResponseListeners = new SmartList();
        this.myAnalysisServerListener = new AnalysisServerListenerAdapter(){

            @Override
            public void computedAnalyzedFiles(List<String> filePaths) {
                DartAnalysisServerService.this.configureImportedLibraries(filePaths);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void computedErrors(@NotNull String filePathSD, @NotNull List<AnalysisError> errors) {
                int newHash;
                int oldHash;
                if (filePathSD == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errors == null) {
                    1.$$$reportNull$$$0(1);
                }
                String fileName = PathUtil.getFileName((String)filePathSD);
                ProgressIndicator indicator = DartAnalysisServerService.this.myProgressIndicator;
                if (indicator != null) {
                    indicator.setText(DartBundle.message("dart.analysis.progress.with.file", fileName));
                }
                ArrayList<AnalysisError> errorsWithoutTodo = errors.isEmpty() ? Collections.emptyList() : new ArrayList<AnalysisError>(errors.size());
                boolean hasSevereProblems = false;
                for (AnalysisError error : errors) {
                    if ("ERROR".equals(error.getSeverity()) || "WARNING".equals(error.getSeverity())) {
                        hasSevereProblems = true;
                    }
                    if ("TODO".equals(error.getType())) continue;
                    errorsWithoutTodo.add(error);
                }
                String filePathSI = FileUtil.toSystemIndependentName((String)filePathSD);
                Set set = DartAnalysisServerService.this.myFilePathsWithErrors;
                synchronized (set) {
                    oldHash = DartAnalysisServerService.this.myFilePathToErrorsHash.get((Object)filePathSI);
                }
                int n = newHash = errorsWithoutTodo.isEmpty() ? 0 : DartAnalysisServerService.ensureNotZero(errorsWithoutTodo.hashCode());
                if (oldHash == newHash && !DartAnalysisServerService.this.myServerData.isErrorInfoLost(filePathSI)) {
                    return;
                }
                boolean visible = DartAnalysisServerService.this.myVisibleFiles.contains(filePathSD);
                if (DartAnalysisServerService.this.myServerData.computedErrors(filePathSI, errorsWithoutTodo, visible)) {
                    DartAnalysisServerService.this.onErrorsUpdated(filePathSI, errorsWithoutTodo, hasSevereProblems, newHash);
                }
            }

            @Override
            public void computedHighlights(@NotNull String filePath, @NotNull List<HighlightRegion> regions) {
                if (filePath == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (regions == null) {
                    1.$$$reportNull$$$0(3);
                }
                DartAnalysisServerService.this.myServerData.computedHighlights(FileUtil.toSystemIndependentName((String)filePath), regions);
            }

            @Override
            public void computedClosingLabels(@NotNull String filePath, List<ClosingLabel> labels) {
                if (filePath == null) {
                    1.$$$reportNull$$$0(4);
                }
                DartAnalysisServerService.this.myServerData.computedClosingLabels(FileUtil.toSystemIndependentName((String)filePath), labels);
            }

            @Override
            public void computedImplemented(String _filePath, List<ImplementedClass> implementedClasses, List<ImplementedMember> implementedMembers) {
                DartAnalysisServerService.this.myServerData.computedImplemented(FileUtil.toSystemIndependentName((String)_filePath), implementedClasses, implementedMembers);
            }

            @Override
            public void computedNavigation(@NotNull String _filePath, @NotNull List<NavigationRegion> regions) {
                if (_filePath == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (regions == null) {
                    1.$$$reportNull$$$0(6);
                }
                DartAnalysisServerService.this.myServerData.computedNavigation(FileUtil.toSystemIndependentName((String)_filePath), regions);
            }

            @Override
            public void computedOverrides(@NotNull String _filePath, @NotNull List<OverrideMember> overrides) {
                if (_filePath == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (overrides == null) {
                    1.$$$reportNull$$$0(8);
                }
                DartAnalysisServerService.this.myServerData.computedOverrides(FileUtil.toSystemIndependentName((String)_filePath), overrides);
            }

            @Override
            public void computedOutline(@NotNull String _filePath, @NotNull Outline outline) {
                if (_filePath == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (outline == null) {
                    1.$$$reportNull$$$0(10);
                }
                DartAnalysisServerService.this.myServerData.computedOutline(FileUtil.toSystemIndependentName((String)_filePath), outline);
            }

            @Override
            public void flushedResults(@NotNull List<String> _filePaths) {
                if (_filePaths == null) {
                    1.$$$reportNull$$$0(11);
                }
                ArrayList<String> filePaths = new ArrayList<String>(_filePaths.size());
                for (String path : _filePaths) {
                    filePaths.add(FileUtil.toSystemIndependentName((String)path));
                }
                DartAnalysisServerService.this.myServerData.onFlushedResults(filePaths);
                for (String filePath : filePaths) {
                    DartAnalysisServerService.this.onErrorsUpdated(filePath, AnalysisError.EMPTY_LIST, false, 0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void computedCompletion(@NotNull String completionId, int replacementOffset, int replacementLength, @NotNull List<CompletionSuggestion> completions, boolean isLast) {
                if (completionId == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (completions == null) {
                    1.$$$reportNull$$$0(13);
                }
                Queue queue = DartAnalysisServerService.this.myCompletionInfos;
                synchronized (queue) {
                    DartAnalysisServerService.this.myCompletionInfos.add(new CompletionInfo(completionId, replacementOffset, replacementLength, completions, isLast));
                    DartAnalysisServerService.this.myCompletionInfos.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void computedSearchResults(String searchId, List<SearchResult> results, boolean last) {
                Queue queue = DartAnalysisServerService.this.mySearchResultSets;
                synchronized (queue) {
                    DartAnalysisServerService.this.mySearchResultSets.add(new SearchResultsSet(searchId, results, last));
                    DartAnalysisServerService.this.mySearchResultSets.notifyAll();
                }
            }

            @Override
            public void serverConnected(@Nullable String version) {
                DartAnalysisServerService.this.myServerVersion = version != null ? version : "";
            }

            @Override
            public void serverError(boolean isFatal, @Nullable String message, @Nullable String stackTrace) {
                if (message == null) {
                    message = "<no error message>";
                }
                if (stackTrace == null) {
                    stackTrace = "<no stack trace>";
                }
                if (!isFatal && stackTrace.startsWith("#0      checkValidPackageUri (package:package_config/src/util.dart:72)")) {
                    return;
                }
                String errorMessage = "Dart analysis server, SDK version " + DartAnalysisServerService.this.mySdkVersion + ", server version " + DartAnalysisServerService.this.myServerVersion + ", " + (isFatal ? "FATAL " : "") + "error: " + message + "\n" + stackTrace;
                DartAnalysisServerService.this.myErrorReporter.report(errorMessage);
            }

            @Override
            public void serverStatus(@Nullable AnalysisStatus analysisStatus, @Nullable PubStatus pubStatus) {
                boolean wasBusy;
                boolean bl = wasBusy = DartAnalysisServerService.this.myAnalysisInProgress || DartAnalysisServerService.this.myPubListInProgress;
                if (analysisStatus != null) {
                    DartAnalysisServerService.this.myAnalysisInProgress = analysisStatus.isAnalyzing();
                }
                if (pubStatus != null) {
                    DartAnalysisServerService.this.myPubListInProgress = pubStatus.isListingPackageDirs();
                }
                if (!wasBusy && (DartAnalysisServerService.this.myAnalysisInProgress || DartAnalysisServerService.this.myPubListInProgress)) {
                    Runnable delayedRunnable = () -> {
                        if (DartAnalysisServerService.this.myAnalysisInProgress || DartAnalysisServerService.this.myPubListInProgress) {
                            DartAnalysisServerService.this.startShowingServerProgress();
                        }
                    };
                    int delay = pubStatus != null && pubStatus.isListingPackageDirs() ? 50 : 300;
                    DartAnalysisServerService.this.myShowServerProgressAlarm.addRequest(delayedRunnable, delay, ModalityState.any());
                }
                if (!DartAnalysisServerService.this.myAnalysisInProgress && !DartAnalysisServerService.this.myPubListInProgress) {
                    DartAnalysisServerService.this.stopShowingServerProgress();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filePathSD";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errors";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filePath";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "regions";
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_filePath";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overrides";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outline";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_filePaths";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "completionId";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "completions";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedErrors";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedHighlights";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedClosingLabels";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedNavigation";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedOverrides";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedOutline";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "flushedResults";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedCompletion";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myProject = project;
        this.myRootsHandler = new DartServerRootsHandler(project);
        this.myServerData = new DartServerData(this);
        this.myUpdateFilesAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myShowServerProgressAlarm = new Alarm((Disposable)project);
        DartClosingLabelManager.getInstance().addListener(this::handleClosingLabelPreferenceChanged, this);
    }

    public void addAnalysisServerListener(@NotNull AnalysisServerListener serverListener) {
        if (serverListener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(10);
        }
        if (!this.myAdditionalServerListeners.contains(serverListener)) {
            this.myAdditionalServerListeners.add(serverListener);
            if (this.myServer != null && this.isServerProcessActive()) {
                this.myServer.addAnalysisServerListener(serverListener);
            }
        }
    }

    public void removeAnalysisServerListener(@NotNull AnalysisServerListener serverListener) {
        if (serverListener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(11);
        }
        this.myAdditionalServerListeners.remove(serverListener);
        if (this.myServer != null) {
            this.myServer.removeAnalysisServerListener(serverListener);
        }
    }

    public void addResponseListener(@NotNull ResponseListener responseListener) {
        if (responseListener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(12);
        }
        if (!this.myResponseListeners.contains(responseListener)) {
            this.myResponseListeners.add(responseListener);
            if (this.myServer != null && this.isServerProcessActive()) {
                this.myServer.addResponseListener(responseListener);
            }
        }
    }

    public void removeResponseListener(@NotNull ResponseListener responseListener) {
        if (responseListener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(13);
        }
        this.myResponseListeners.remove(responseListener);
        if (this.myServer != null) {
            this.myServer.removeResponseListener(responseListener);
        }
    }

    private static void setDasLogger() {
        if (Logging.getLogger() != Logger.NULL) {
            return;
        }
        Logging.setLogger(new Logger(){

            @Override
            public void logError(String message) {
                LOG.error(message);
            }

            @Override
            public void logError(String message, Throwable exception) {
                LOG.error(message, exception);
            }

            @Override
            public void logInformation(String message) {
                LOG.debug(message);
            }

            @Override
            public void logInformation(String message, Throwable exception) {
                LOG.debug(message, exception);
            }
        });
    }

    private void registerFileEditorManagerListener() {
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ("pubspec.yaml".equals(file.getName()) || file.getFileType() == DartFileType.INSTANCE) {
                    DartSdkUpdateChecker.mayBeCheckForSdkUpdate(source.getProject());
                }
                DartAnalysisServerService.this.updateCurrentFile();
                if (DartAnalysisServerService.isLocalAnalyzableFile(file)) {
                    DartAnalysisServerService.this.updateVisibleFiles();
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(2);
                }
                DartAnalysisServerService.this.updateCurrentFile();
                if (DartAnalysisServerService.isLocalAnalyzableFile(event.getOldFile()) || DartAnalysisServerService.isLocalAnalyzableFile(event.getNewFile())) {
                    DartAnalysisServerService.this.updateVisibleFiles();
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    4.$$$reportNull$$$0(4);
                }
                DartAnalysisServerService.this.updateCurrentFile();
                if (DartAnalysisServerService.isLocalAnalyzableFile(file)) {
                    if (FileEditorManager.getInstance((Project)DartAnalysisServerService.this.myProject).getSelectedEditor(file) == null) {
                        DartAnalysisServerService.this.myServerData.onFileClosed(file);
                    }
                    DartAnalysisServerService.this.updateVisibleFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void registerDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeDocumentChange(DocumentEvent e) {
                if (DartAnalysisServerService.this.myServer == null) {
                    return;
                }
                DartAnalysisServerService.this.myServerData.onDocumentChanged(e);
                VirtualFile file = FileDocumentManager.getInstance().getFile(e.getDocument());
                if (DartAnalysisServerService.isLocalAnalyzableFile(file)) {
                    for (VirtualFile fileInEditor : FileEditorManager.getInstance((Project)DartAnalysisServerService.this.myProject).getOpenFiles()) {
                        if (!fileInEditor.equals(file)) continue;
                        Object object = DartAnalysisServerService.this.myLock;
                        synchronized (object) {
                            DartAnalysisServerService.this.myChangedDocuments.add(e.getDocument());
                            break;
                        }
                    }
                }
                DartAnalysisServerService.this.myUpdateFilesAlarm.cancelAllRequests();
                DartAnalysisServerService.this.myUpdateFilesAlarm.addRequest(DartAnalysisServerService.this::updateFilesContent, 300L);
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @NotNull
    public static DartAnalysisServerService getInstance(@NotNull Project project) {
        if (project == null) {
            DartAnalysisServerService.$$$reportNull$$$0(14);
        }
        DartAnalysisServerService dartAnalysisServerService = (DartAnalysisServerService)ServiceManager.getService((Project)project, DartAnalysisServerService.class);
        if (dartAnalysisServerService == null) {
            DartAnalysisServerService.$$$reportNull$$$0(15);
        }
        return dartAnalysisServerService;
    }

    @NotNull
    public String getSdkVersion() {
        String string = this.mySdkVersion;
        if (string == null) {
            DartAnalysisServerService.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DartAnalysisServerService.$$$reportNull$$$0(17);
        }
        return project;
    }

    public void dispose() {
        this.stopServer();
    }

    private void handleClosingLabelPreferenceChanged() {
        this.analysis_setSubscriptions();
    }

    @NotNull
    public List<DartServerData.DartError> getErrors(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(18);
        }
        List<DartServerData.DartError> list = this.myServerData.getErrors(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(19);
        }
        return list;
    }

    public List<DartServerData.DartError> getErrors(@NotNull SearchScope scope) {
        if (scope == null) {
            DartAnalysisServerService.$$$reportNull$$$0(20);
        }
        return this.myServerData.getErrors(scope);
    }

    @NotNull
    public List<DartServerData.DartHighlightRegion> getHighlight(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(21);
        }
        List<DartServerData.DartHighlightRegion> list = this.myServerData.getHighlight(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<DartServerData.DartNavigationRegion> getNavigation(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(23);
        }
        List<DartServerData.DartNavigationRegion> list = this.myServerData.getNavigation(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public List<DartServerData.DartOverrideMember> getOverrideMembers(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(25);
        }
        List<DartServerData.DartOverrideMember> list = this.myServerData.getOverrideMembers(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public List<DartServerData.DartRegion> getImplementedClasses(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(27);
        }
        List<DartServerData.DartRegion> list = this.myServerData.getImplementedClasses(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public List<DartServerData.DartRegion> getImplementedMembers(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(29);
        }
        List<DartServerData.DartRegion> list = this.myServerData.getImplementedMembers(file);
        if (list == null) {
            DartAnalysisServerService.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    @Contract(value="null -> null")
    public Outline getOutline(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return this.myServerData.getOutline(file);
    }

    void updateCurrentFile() {
        UIUtil.invokeLaterIfNeeded(() -> {
            VirtualFile[] files = FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles();
            if (files.length > 0) {
                DartProblemsView.getInstance(this.myProject).setCurrentFile(files[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVisibleFiles() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> newVisibleFiles = new ArrayList<String>();
            for (VirtualFile file : FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()) {
                if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) continue;
                newVisibleFiles.add(FileUtil.toSystemDependentName((String)file.getPath()));
            }
            if (!Comparing.haveEqualElements(this.myVisibleFiles, newVisibleFiles)) {
                this.myVisibleFiles.clear();
                this.myVisibleFiles.addAll(newVisibleFiles);
                this.analysis_setPriorityFiles();
                this.analysis_setSubscriptions();
            }
        }
    }

    @Contract(value="null->false")
    public static boolean isLocalAnalyzableFile(@Nullable VirtualFile file) {
        if (file != null && file.isInLocalFileSystem()) {
            return file.getFileType() == DartFileType.INSTANCE || HtmlUtil.isHtmlFile((VirtualFile)file) || file.getName().equals("pubspec.yaml") || file.getName().equals(".analysis_options");
        }
        return false;
    }

    public void updateFilesContent() {
        if (this.myServer != null) {
            ApplicationManager.getApplication().runReadAction(this::doUpdateFilesContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateFilesContent() {
        AnalysisServer server = this.myServer;
        if (server == null) {
            return;
        }
        this.myUpdateFilesAlarm.cancelAllRequests();
        THashMap filesToUpdate = new THashMap();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            THashSet oldTrackedFiles = new THashSet(this.myFilePathWithOverlaidContentToTimestamp.keySet());
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            THashSet documents = new THashSet(this.myChangedDocuments);
            this.myChangedDocuments.clear();
            ContainerUtil.addAll((Collection)documents, (Object[])fileDocumentManager.getUnsavedDocuments());
            for (Document document : documents) {
                VirtualFile file = fileDocumentManager.getFile(document);
                if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) continue;
                oldTrackedFiles.remove(file.getPath());
                Long oldTimestamp = this.myFilePathWithOverlaidContentToTimestamp.get(file.getPath());
                if (oldTimestamp != null && document.getModificationStamp() == oldTimestamp.longValue()) continue;
                filesToUpdate.put(FileUtil.toSystemDependentName((String)file.getPath()), new AddContentOverlay(document.getText()));
                this.myFilePathWithOverlaidContentToTimestamp.put(file.getPath(), document.getModificationStamp());
            }
            for (String oldPath : oldTrackedFiles) {
                Long removed = this.myFilePathWithOverlaidContentToTimestamp.remove(oldPath);
                LOG.assertTrue(removed != null, (Object)oldPath);
                filesToUpdate.put(FileUtil.toSystemDependentName((String)oldPath), new RemoveContentOverlay());
            }
            if (LOG.isDebugEnabled()) {
                THashSet overlaid = new THashSet(filesToUpdate.keySet());
                for (String removeOverlaid : oldTrackedFiles) {
                    overlaid.remove(FileUtil.toSystemDependentName((String)removeOverlaid));
                }
                if (!overlaid.isEmpty()) {
                    LOG.debug("Sending overlaid content: " + StringUtil.join((Collection)overlaid, (String)",\n"));
                }
                if (!oldTrackedFiles.isEmpty()) {
                    LOG.debug("Removing overlaid content: " + StringUtil.join((Collection)oldTrackedFiles, (String)",\n"));
                }
            }
        }
        if (!filesToUpdate.isEmpty()) {
            server.analysis_updateContent((Map<String, Object>)filesToUpdate, this.myServerData::onFilesContentUpdated);
        }
    }

    public boolean updateRoots(@NotNull List<String> includedRoots, @NotNull List<String> excludedRoots) {
        AnalysisServer server;
        if (includedRoots == null) {
            DartAnalysisServerService.$$$reportNull$$$0(31);
        }
        if (excludedRoots == null) {
            DartAnalysisServerService.$$$reportNull$$$0(32);
        }
        if ((server = this.myServer) == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("analysis_setAnalysisRoots, included:\n" + StringUtil.join(includedRoots, (String)",\n") + "\nexcluded:\n" + StringUtil.join(excludedRoots, (String)",\n"));
        }
        server.analysis_setAnalysisRoots(includedRoots, excludedRoots, null);
        return true;
    }

    private void onErrorsUpdated(@NotNull String filePath, @NotNull List<AnalysisError> errors, boolean hasSevereProblems, int errorsHash) {
        if (filePath == null) {
            DartAnalysisServerService.$$$reportNull$$$0(33);
        }
        if (errors == null) {
            DartAnalysisServerService.$$$reportNull$$$0(34);
        }
        this.updateFilesWithErrorsSet(filePath, hasSevereProblems, errorsHash);
        DartProblemsView.getInstance(this.myProject).updateErrorsForFile(filePath, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilesWithErrorsSet(@NotNull String filePath, boolean hasSevereProblems, int errorsHash) {
        if (filePath == null) {
            DartAnalysisServerService.$$$reportNull$$$0(35);
        }
        Set<String> set = this.myFilePathsWithErrors;
        synchronized (set) {
            if (errorsHash == 0) {
                this.myFilePathToErrorsHash.remove((Object)filePath);
            } else {
                this.myFilePathToErrorsHash.put((Object)filePath, errorsHash);
            }
            if (hasSevereProblems) {
                if (this.myFilePathsWithErrors.add(filePath)) {
                    String parentPath = PathUtil.getParentPath((String)filePath);
                    while (!parentPath.isEmpty()) {
                        int count = this.myFolderPathsWithErrors.get((Object)parentPath);
                        this.myFolderPathsWithErrors.put((Object)parentPath, count + 1);
                        parentPath = PathUtil.getParentPath((String)parentPath);
                    }
                }
            } else if (this.myFilePathsWithErrors.remove(filePath)) {
                String parentPath = PathUtil.getParentPath((String)filePath);
                while (!parentPath.isEmpty()) {
                    int count = this.myFolderPathsWithErrors.remove((Object)parentPath);
                    if (count > 1) {
                        this.myFolderPathsWithErrors.put((Object)parentPath, count - 1);
                    }
                    parentPath = PathUtil.getParentPath((String)parentPath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllErrors() {
        Set<String> set = this.myFilePathsWithErrors;
        synchronized (set) {
            this.myFilePathsWithErrors.clear();
            this.myFilePathToErrorsHash.clear();
            this.myFolderPathsWithErrors.clear();
        }
        if (!this.myProject.isDisposed() && this.myInitializationOnServerStartupDone) {
            DartProblemsView.getInstance(this.myProject).clearAll();
        }
    }

    @NotNull
    public List<HoverInformation> analysis_getHover(@NotNull VirtualFile file, int _offset) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(36);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final ArrayList result = Lists.newArrayList();
        AnalysisServer server = this.myServer;
        if (server == null) {
            List<HoverInformation> list = HoverInformation.EMPTY_LIST;
            if (list == null) {
                DartAnalysisServerService.$$$reportNull$$$0(37);
            }
            return list;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.analysis_getHover(filePath, offset, new GetHoverConsumer(){

            @Override
            public void computedHovers(HoverInformation[] hovers) {
                Collections.addAll(result, hovers);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("analysis_getHover()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_HOVER_TIMEOUT);
        ArrayList arrayList = result;
        if (arrayList == null) {
            DartAnalysisServerService.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @Nullable
    public List<DartServerData.DartNavigationRegion> analysis_getNavigation(final @NotNull VirtualFile file, int _offset, int length) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(39);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = Ref.create();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        LOG.debug("analysis_getNavigation(" + filePath + ")");
        int offset = this.getOriginalOffset(file, _offset);
        server.analysis_getNavigation(filePath, offset, length, new GetNavigationConsumer(){

            @Override
            public void computedNavigation(List<NavigationRegion> regions) {
                ArrayList<DartServerData.DartNavigationRegion> dartRegions = new ArrayList<DartServerData.DartNavigationRegion>(regions.size());
                for (NavigationRegion region : regions) {
                    if (region.getLength() <= 0) continue;
                    dartRegions.add(DartServerData.createDartNavigationRegion(DartAnalysisServerService.this, file, region));
                }
                resultRef.set(dartRegions);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if ("GET_NAVIGATION_INVALID_FILE".equals(error.getCode())) {
                    LOG.info(DartAnalysisServerService.this.getShortErrorMessage("analysis_getNavigation()", filePath, error));
                } else {
                    DartAnalysisServerService.this.logError("analysis_getNavigation()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_NAVIGATION_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("analysis_getNavigation() took more than " + GET_NAVIGATION_TIMEOUT + "ms for file " + filePath);
        }
        return (List)resultRef.get();
    }

    @NotNull
    public List<SourceChange> edit_getAssists(@NotNull VirtualFile file, int _offset, int _length) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(40);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final ArrayList results = Lists.newArrayList();
        AnalysisServer server = this.myServer;
        if (server == null) {
            ArrayList arrayList = results;
            if (arrayList == null) {
                DartAnalysisServerService.$$$reportNull$$$0(41);
            }
            return arrayList;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        int length = this.getOriginalOffset(file, _offset + _length) - offset;
        server.edit_getAssists(filePath, offset, length, new GetAssistsConsumer(){

            @Override
            public void computedSourceChanges(List<SourceChange> sourceChanges) {
                results.addAll(sourceChanges);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("edit_getAssists()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_ASSISTS_TIMEOUT);
        ArrayList arrayList = results;
        if (arrayList == null) {
            DartAnalysisServerService.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    public boolean edit_isPostfixCompletionApplicable(VirtualFile file, int _offset, String key) {
        AnalysisServer server = this.myServer;
        if (server == null) {
            return false;
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = Ref.create((Object)false);
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.edit_isPostfixCompletionApplicable(filePath, key, offset, new IsPostfixCompletionApplicableConsumer(){

            @Override
            public void isPostfixCompletionApplicable(Boolean value) {
                resultRef.set((Object)value);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, POSTFIX_COMPLETION_TIMEOUT);
        return (Boolean)resultRef.get();
    }

    @Nullable
    public PostfixCompletionTemplate[] edit_listPostfixCompletionTemplates() {
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final Ref resultRef = Ref.create();
        final CountDownLatch latch = new CountDownLatch(1);
        server.edit_listPostfixCompletionTemplates(new ListPostfixCompletionTemplatesConsumer(){

            @Override
            public void postfixCompletionTemplates(PostfixCompletionTemplate[] templates) {
                resultRef.set((Object)templates);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("edit_listPostfixCompletionTemplates()", null, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, POSTFIX_INITIALIZATION_TIMEOUT);
        return (PostfixCompletionTemplate[])resultRef.get();
    }

    @Nullable
    public SourceChange edit_getPostfixCompletion(@NotNull VirtualFile file, int _offset, String key) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(43);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final Ref resultRef = Ref.create();
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.edit_getPostfixCompletion(filePath, key, offset, new GetPostfixCompletionConsumer(){

            @Override
            public void computedSourceChange(SourceChange sourceChange) {
                resultRef.set((Object)sourceChange);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("edit_getPostfixCompletion()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, POSTFIX_COMPLETION_TIMEOUT);
        return (SourceChange)resultRef.get();
    }

    @Nullable
    public SourceChange edit_getStatementCompletion(@NotNull VirtualFile file, int _offset) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(44);
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final Ref resultRef = Ref.create();
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.edit_getStatementCompletion(filePath, offset, new GetStatementCompletionConsumer(){

            @Override
            public void computedSourceChange(SourceChange sourceChange) {
                resultRef.set((Object)sourceChange);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, STATEMENT_COMPLETION_TIMEOUT);
        return (SourceChange)resultRef.get();
    }

    public void diagnostic_getServerPort(GetServerPortConsumer consumer) {
        AnalysisServer server = this.myServer;
        if (server == null) {
            consumer.onError(new RequestError("INVALID_SERVER_RESPONSE", "The analysis server is not running.", null));
        } else {
            server.diagnostic_getServerPort(consumer);
        }
    }

    public void askForFixesAndWaitABitIfReceivedQuickly(@NotNull VirtualFile file, int _offset, final @NotNull Consumer<List<AnalysisErrorFixes>> consumer) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(45);
        }
        if (consumer == null) {
            DartAnalysisServerService.$$$reportNull$$$0(46);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        AnalysisServer server = this.myServer;
        if (server == null) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.edit_getFixes(filePath, offset, new GetFixesConsumer(){

            @Override
            public void computedFixes(List<AnalysisErrorFixes> fixes) {
                consumer.consume(fixes);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("edit_getFixes()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_FIXES_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search_findElementReferences(@NotNull VirtualFile file, int _offset, @NotNull Consumer<SearchResult> consumer) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(47);
        }
        if (consumer == null) {
            DartAnalysisServerService.$$$reportNull$$$0(48);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref searchIdRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.search_findElementReferences(filePath, offset, true, new FindElementReferencesConsumer(){

            @Override
            public void computedElementReferences(String searchId, Element element) {
                searchIdRef.set((Object)searchId);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                LOG.info(DartAnalysisServerService.this.getShortErrorMessage("search_findElementReferences()", filePath, error));
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, FIND_ELEMENT_REFERENCES_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("search_findElementReferences() took too long for " + filePath + "@" + offset);
            return;
        }
        String searchId = (String)searchIdRef.get();
        if (searchId == null) {
            return;
        }
        while (true) {
            ProgressManager.checkCanceled();
            Queue<SearchResultsSet> queue = this.mySearchResultSets;
            synchronized (queue) {
                SearchResultsSet resultSet;
                while ((resultSet = this.mySearchResultSets.poll()) != null) {
                    if (!resultSet.id.equals(searchId)) continue;
                    for (SearchResult searchResult : resultSet.results) {
                        consumer.consume((Object)searchResult);
                    }
                    if (!resultSet.isLast) continue;
                    return;
                }
                try {
                    this.mySearchResultSets.wait(10L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @NotNull
    public List<TypeHierarchyItem> search_getTypeHierarchy(@NotNull VirtualFile file, int _offset, boolean superOnly) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(49);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final ArrayList results = Lists.newArrayList();
        AnalysisServer server = this.myServer;
        if (server == null) {
            ArrayList arrayList = results;
            if (arrayList == null) {
                DartAnalysisServerService.$$$reportNull$$$0(50);
            }
            return arrayList;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.search_getTypeHierarchy(filePath, offset, superOnly, new GetTypeHierarchyConsumer(){

            @Override
            public void computedHierarchy(List<TypeHierarchyItem> hierarchyItems) {
                results.addAll(hierarchyItems);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("search_getTypeHierarchy()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_TYPE_HIERARCHY_TIMEOUT);
        ArrayList arrayList = results;
        if (arrayList == null) {
            DartAnalysisServerService.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @Nullable
    public String completion_getSuggestions(@NotNull VirtualFile file, int _offset) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(52);
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int offset = this.getOriginalOffset(file, _offset);
        server.completion_getSuggestions(filePath, offset, new GetSuggestionsConsumer(){

            @Override
            public void computedCompletionId(@NotNull String completionId) {
                if (completionId == null) {
                    16.$$$reportNull$$$0(0);
                }
                resultRef.set((Object)completionId);
                latch.countDown();
            }

            @Override
            public void onError(@NotNull RequestError error) {
                if (error == null) {
                    16.$$$reportNull$$$0(1);
                }
                latch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "completionId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$16";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computedCompletionId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, GET_SUGGESTIONS_TIMEOUT);
        return (String)resultRef.get();
    }

    @Nullable
    public FormatResult edit_format(@NotNull VirtualFile file, int _selectionOffset, int _selectionLength, int lineLength) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(53);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int selectionOffset = this.getOriginalOffset(file, _selectionOffset);
        int selectionLength = this.getOriginalOffset(file, _selectionOffset + _selectionLength) - selectionOffset;
        server.edit_format(filePath, selectionOffset, selectionLength, lineLength, new FormatConsumer(){

            @Override
            public void computedFormat(List<SourceEdit> edits, int selectionOffset, int selectionLength) {
                resultRef.set((Object)new FormatResult(edits, selectionOffset, selectionLength));
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if ("FORMAT_WITH_ERRORS".equals(error.getCode()) || "FORMAT_INVALID_FILE".equals(error.getCode())) {
                    LOG.info(DartAnalysisServerService.this.getShortErrorMessage("edit_format()", filePath, error));
                } else {
                    DartAnalysisServerService.this.logError("edit_format()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, EDIT_FORMAT_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("edit_format() took too long for file " + filePath);
        }
        return (FormatResult)resultRef.get();
    }

    @Nullable
    public List<ImportedElements> analysis_getImportedElements(@NotNull VirtualFile file, int _selectionOffset, int _selectionLength) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(54);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null || StringUtil.compareVersionNumbers((String)this.mySdkVersion, (String)"1.25") < 0) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int selectionOffset = this.getOriginalOffset(file, _selectionOffset);
        int selectionLength = this.getOriginalOffset(file, _selectionOffset + _selectionLength) - selectionOffset;
        server.analysis_getImportedElements(filePath, selectionOffset, selectionLength, new GetImportedElementsConsumer(){

            @Override
            public void computedImportedElements(List<ImportedElements> importedElements) {
                resultRef.set(importedElements);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if (!"GET_IMPORTED_ELEMENTS_INVALID_FILE".equals(error.getCode())) {
                    DartAnalysisServerService.this.logError("analysis_getImportedElements()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, IMPORTED_ELEMENTS_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("analysis_getImportedElements() took too long for file " + filePath);
        }
        return (List)resultRef.get();
    }

    @Nullable
    public SourceFileEdit edit_importElements(@NotNull VirtualFile file, @NotNull List<ImportedElements> importedElements) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(55);
        }
        if (importedElements == null) {
            DartAnalysisServerService.$$$reportNull$$$0(56);
        }
        final String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null || StringUtil.compareVersionNumbers((String)this.mySdkVersion, (String)"1.25") < 0) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.edit_importElements(filePath, importedElements, new ImportElementsConsumer(){

            @Override
            public void computedImportedElements(SourceFileEdit edit) {
                resultRef.set((Object)edit);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if (!"IMPORT_ELEMENTS_INVALID_FILE".equals(error.getCode())) {
                    DartAnalysisServerService.this.logError("edit_importElements()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, IMPORTED_ELEMENTS_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("edit_importElements() took too long for file " + filePath);
        }
        return (SourceFileEdit)resultRef.get();
    }

    public boolean edit_getRefactoring(String kind, VirtualFile file, int _offset, int _length, boolean validateOnly, RefactoringOptions options, GetRefactoringConsumer consumer) {
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        AnalysisServer server = this.myServer;
        if (server == null) {
            return false;
        }
        int offset = this.getOriginalOffset(file, _offset);
        int length = this.getOriginalOffset(file, _offset + _length) - offset;
        server.edit_getRefactoring(kind, filePath, offset, length, validateOnly, options, consumer);
        return true;
    }

    @Nullable
    public SourceFileEdit edit_organizeDirectives(@NotNull String _filePath) {
        if (_filePath == null) {
            DartAnalysisServerService.$$$reportNull$$$0(57);
        }
        final String filePath = FileUtil.toSystemDependentName((String)_filePath);
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.edit_organizeDirectives(filePath, new OrganizeDirectivesConsumer(){

            @Override
            public void computedEdit(SourceFileEdit edit) {
                resultRef.set((Object)edit);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if ("FILE_NOT_ANALYZED".equals(error.getCode()) || "ORGANIZE_DIRECTIVES_ERROR".equals(error.getCode())) {
                    LOG.info(DartAnalysisServerService.this.getShortErrorMessage("edit_organizeDirectives()", filePath, error));
                } else {
                    DartAnalysisServerService.this.logError("edit_organizeDirectives()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, EDIT_ORGANIZE_DIRECTIVES_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("edit_organizeDirectives() took too long for file " + filePath);
        }
        return (SourceFileEdit)resultRef.get();
    }

    @Nullable
    public SourceFileEdit edit_sortMembers(@NotNull String _filePath) {
        if (_filePath == null) {
            DartAnalysisServerService.$$$reportNull$$$0(58);
        }
        final String filePath = FileUtil.toSystemDependentName((String)_filePath);
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.edit_sortMembers(filePath, new SortMembersConsumer(){

            @Override
            public void computedEdit(SourceFileEdit edit) {
                resultRef.set((Object)edit);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                if ("SORT_MEMBERS_PARSE_ERRORS".equals(error.getCode()) || "SORT_MEMBERS_INVALID_FILE".equals(error.getCode())) {
                    LOG.info(DartAnalysisServerService.this.getShortErrorMessage("edit_sortMembers()", filePath, error));
                } else {
                    DartAnalysisServerService.this.logError("edit_sortMembers()", filePath, error);
                }
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, EDIT_SORT_MEMBERS_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("edit_sortMembers() took too long for file " + filePath);
        }
        return (SourceFileEdit)resultRef.get();
    }

    public void analysis_reanalyze() {
        AnalysisServer server = this.myServer;
        if (server == null) {
            return;
        }
        server.analysis_reanalyze(null);
        ApplicationManager.getApplication().invokeLater(this::clearAllErrors, ModalityState.NON_MODAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysis_setPriorityFiles() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myServer == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("analysis_setPriorityFiles, files:\n" + StringUtil.join(this.myVisibleFiles, (String)",\n"));
            }
            this.myServer.analysis_setPriorityFiles(this.myVisibleFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysis_setSubscriptions() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myServer == null) {
                return;
            }
            THashMap subscriptions = new THashMap();
            subscriptions.put("HIGHLIGHTS", this.myVisibleFiles);
            subscriptions.put("NAVIGATION", this.myVisibleFiles);
            subscriptions.put("OVERRIDES", this.myVisibleFiles);
            subscriptions.put("OUTLINE", this.myVisibleFiles);
            if (StringUtil.compareVersionNumbers((String)this.mySdkVersion, (String)"1.13") >= 0) {
                subscriptions.put("IMPLEMENTED", this.myVisibleFiles);
            }
            if (DartClosingLabelManager.getInstance().getShowClosingLabels() && StringUtil.compareVersionNumbers((String)this.mySdkVersion, (String)"1.25.0") >= 0) {
                subscriptions.put("CLOSING_LABELS", this.myVisibleFiles);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("analysis_setSubscriptions, subscriptions:\n" + subscriptions);
            }
            this.myServer.analysis_setSubscriptions((Map<String, List<String>>)subscriptions);
        }
    }

    @Nullable
    public String execution_createContext(@NotNull String _filePath) {
        if (_filePath == null) {
            DartAnalysisServerService.$$$reportNull$$$0(59);
        }
        final String filePath = FileUtil.toSystemDependentName((String)_filePath);
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.execution_createContext(filePath, new CreateContextConsumer(){

            @Override
            public void computedExecutionContext(String contextId) {
                resultRef.set((Object)contextId);
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                DartAnalysisServerService.this.logError("execution_createContext()", filePath, error);
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, EXECUTION_CREATE_CONTEXT_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("execution_createContext() took too long for file " + filePath);
        }
        return (String)resultRef.get();
    }

    public void execution_deleteContext(@NotNull String contextId) {
        AnalysisServer server;
        if (contextId == null) {
            DartAnalysisServerService.$$$reportNull$$$0(60);
        }
        if ((server = this.myServer) != null) {
            server.execution_deleteContext(contextId);
        }
    }

    @Nullable
    public String execution_mapUri(final @NotNull String _id, @Nullable String _filePath, final @Nullable String _uri) {
        if (_id == null) {
            DartAnalysisServerService.$$$reportNull$$$0(61);
        }
        if (_filePath == null && _uri == null || _filePath != null && _uri != null) {
            LOG.error("One of _filePath and _uri must be non-null.");
            return null;
        }
        final String filePath = _filePath != null ? FileUtil.toSystemDependentName((String)_filePath) : null;
        final Ref resultRef = new Ref();
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.execution_mapUri(_id, filePath, _uri, new MapUriConsumer(){

            @Override
            public void computedFileOrUri(String file, String uri) {
                if (uri != null) {
                    resultRef.set((Object)uri);
                } else {
                    resultRef.set((Object)file);
                }
                latch.countDown();
            }

            @Override
            public void onError(RequestError error) {
                LOG.warn("execution_mapUri(" + _id + ", " + filePath + ", " + _uri + ") returned error " + error.getCode() + ": " + error.getMessage());
                latch.countDown();
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, EXECUTION_MAP_URI_TIMEOUT);
        if (latch.getCount() > 0L) {
            LOG.info("execution_mapUri() took too long for contextID " + _id + " and file or uri " + (filePath != null ? filePath : _uri));
            return null;
        }
        if (_uri != null && !resultRef.isNull()) {
            return FileUtil.toSystemIndependentName((String)((String)resultRef.get()));
        }
        return (String)resultRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(@NotNull DartSdk sdk) {
        if (sdk == null) {
            DartAnalysisServerService.$$$reportNull$$$0(62);
        }
        if (DartPubActionBase.isInProgress()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            String vmArgsRaw;
            this.mySdkHome = sdk.getHomePath();
            String runtimePath = FileUtil.toSystemDependentName((String)DartSdkUtil.getDartExePath(sdk));
            String analysisServerPath = FileUtil.toSystemDependentName((String)(this.mySdkHome + "/bin/snapshots/analysis_server.dart.snapshot"));
            analysisServerPath = System.getProperty("dart.server.path", analysisServerPath);
            String dasStartupErrorMessage = "";
            File runtimePathFile = new File(runtimePath);
            File dasSnapshotFile = new File(analysisServerPath);
            if (!runtimePathFile.exists()) {
                dasStartupErrorMessage = "the Dart VM file does not exist at location: " + runtimePath;
            } else if (!dasSnapshotFile.exists()) {
                dasStartupErrorMessage = "the Dart Analysis Server snapshot file does not exist at location: " + analysisServerPath;
            } else if (!runtimePathFile.canExecute()) {
                dasStartupErrorMessage = "the Dart VM file is not executable at location: " + runtimePath;
            } else if (!dasSnapshotFile.canRead()) {
                dasStartupErrorMessage = "the Dart Analysis Server snapshot file is not readable at location: " + analysisServerPath;
            }
            if (!dasStartupErrorMessage.isEmpty()) {
                LOG.warn("Failed to start Dart analysis server: " + dasStartupErrorMessage);
                this.stopServer();
                return;
            }
            DebugPrintStream debugStream = str -> {
                str = str.substring(0, Math.min(str.length(), 200));
                EvictingQueue<String> evictingQueue = this.myDebugLog;
                synchronized (evictingQueue) {
                    this.myDebugLog.add((Object)str);
                }
            };
            try {
                vmArgsRaw = Registry.stringValue((String)"dart.server.vm.options");
            }
            catch (MissingResourceException e) {
                vmArgsRaw = "";
            }
            String serverArgsRaw = "";
            serverArgsRaw = serverArgsRaw + " --useAnalysisHighlight2";
            try {
                serverArgsRaw = serverArgsRaw + " " + Registry.stringValue((String)"dart.server.additional.arguments");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.myServerSocket = new StdioServerSocket(runtimePath, StringUtil.split((String)vmArgsRaw, (String)" "), analysisServerPath, StringUtil.split((String)serverArgsRaw, (String)" "), debugStream);
            this.myServerSocket.setClientId(DartAnalysisServerService.getClientId());
            this.myServerSocket.setClientVersion(DartAnalysisServerService.getClientVersion());
            RemoteAnalysisServerImpl startedServer = new RemoteAnalysisServerImpl(this.myServerSocket);
            try {
                startedServer.start();
                startedServer.server_setSubscriptions(Collections.singletonList("STATUS"));
                if (Registry.is((String)"dart.projects.without.pubspec", (boolean)false) && DartAnalysisServerService.isAnalyzedFilesSubscriptionEnabled()) {
                    startedServer.analysis_setGeneralSubscriptions(Collections.singletonList("ANALYZED_FILES"));
                }
                if (!this.myInitializationOnServerStartupDone) {
                    this.myInitializationOnServerStartupDone = true;
                    this.registerFileEditorManagerListener();
                    this.registerDocumentListener();
                    DartAnalysisServerService.setDasLogger();
                }
                startedServer.addAnalysisServerListener(this.myAnalysisServerListener);
                for (AnalysisServerListener analysisServerListener : this.myAdditionalServerListeners) {
                    startedServer.addAnalysisServerListener(analysisServerListener);
                }
                for (ResponseListener responseListener : this.myResponseListeners) {
                    startedServer.addResponseListener(responseListener);
                }
                this.myHaveShownInitialProgress = false;
                startedServer.addStatusListener(isAlive -> {
                    if (!isAlive) {
                        Object object = this.myLock;
                        synchronized (object) {
                            if (startedServer == this.myServer) {
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    DartProblemsView problemsView = DartProblemsView.getInstance(this.myProject);
                                    problemsView.showErrorNotificationTerse("Analysis server has terminated");
                                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
                                this.stopServer();
                            }
                        }
                    }
                });
                this.mySdkVersion = sdk.getVersion();
                startedServer.analysis_updateOptions(new AnalysisOptions(true, true, true, true, true, false, true, false));
                this.myServer = startedServer;
                ApplicationManager.getApplication().invokeLater(() -> {
                    DartProblemsView problemsView = DartProblemsView.getInstance(this.myProject);
                    problemsView.clearNotifications();
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
                this.registerPostfixCompletionTemplates();
                if (!ourIntentionsRegistered) {
                    ourIntentionsRegistered = true;
                    DartAnalysisServerService.registerQuickAssistIntentions();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to start Dart analysis server", (Throwable)e);
                this.stopServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerProcessActive() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myServer != null && this.myServer.isSocketOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serverReadyForRequest(@NotNull Project project) {
        DartSdk sdk;
        if (project == null) {
            DartAnalysisServerService.$$$reportNull$$$0(63);
        }
        if ((sdk = DartSdk.getDartSdk(project)) == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
            this.stopServer();
            return false;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            if (!(this.myServer != null && sdk.getHomePath().equals(this.mySdkHome) && sdk.getVersion().equals(this.mySdkVersion) && this.myServer.isSocketOpen())) {
                this.stopServer();
                this.startServer(sdk);
                if (this.myServer != null) {
                    this.myRootsHandler.ensureProjectServed();
                }
            }
            return this.myServer != null;
        }
    }

    public void restartServer() {
        this.stopServer();
        this.serverReadyForRequest(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServer() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myServer != null) {
                LOG.debug("stopping server");
                this.myServer.removeAnalysisServerListener(this.myAnalysisServerListener);
                for (AnalysisServerListener analysisServerListener : this.myAdditionalServerListeners) {
                    this.myServer.removeAnalysisServerListener(analysisServerListener);
                }
                for (ResponseListener responseListener : this.myResponseListeners) {
                    this.myServer.removeResponseListener(responseListener);
                }
                this.myServer.server_shutdown();
                long startTime = System.currentTimeMillis();
                while (this.myServerSocket != null && this.myServerSocket.isOpen()) {
                    if (System.currentTimeMillis() - startTime > SEND_REQUEST_TIMEOUT) {
                        this.myServerSocket.stop();
                        break;
                    }
                    Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            this.stopShowingServerProgress();
            this.myUpdateFilesAlarm.cancelAllRequests();
            this.myServerSocket = null;
            this.myServer = null;
            this.mySdkHome = null;
            this.myFilePathWithOverlaidContentToTimestamp.clear();
            this.myVisibleFiles.clear();
            this.myChangedDocuments.clear();
            this.myServerData.clearData();
            this.myRootsHandler.reset();
            if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
                ApplicationManager.getApplication().invokeLater(this::clearAllErrors, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
    }

    public void waitForAnalysisToComplete_TESTS_ONLY(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(64);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        AnalysisServer server = this.myServer;
        if (server == null) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        server.analysis_getErrors(FileUtil.toSystemDependentName((String)file.getPath()), new GetErrorsConsumer(){

            @Override
            public void computedErrors(AnalysisError[] errors) {
                latch.countDown();
            }

            @Override
            public void onError(RequestError requestError) {
                latch.countDown();
                LOG.error(requestError.getMessage());
            }
        });
        DartAnalysisServerService.awaitForLatchCheckingCanceled(server, latch, ANALYSIS_IN_TESTS_TIMEOUT / 10L);
        assert (latch.getCount() == 0L) : "Analysis did't complete in " + ANALYSIS_IN_TESTS_TIMEOUT + "ms.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileServerBusy() {
        try {
            Object object = this.myProgressLock;
            synchronized (object) {
                while (this.myAnalysisInProgress || this.myPubListInProgress) {
                    this.myProgressLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopShowingServerProgress() {
        this.myShowServerProgressAlarm.cancelAllRequests();
        Object object = this.myProgressLock;
        synchronized (object) {
            this.myAnalysisInProgress = false;
            this.myPubListInProgress = false;
            this.myProgressLock.notifyAll();
            if (this.mySentAnalysisBusy) {
                this.mySentAnalysisBusy = false;
                DartAnalysisServerMessages.sendAnalysisStarted(this.myProject, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileWithErrors(@NotNull VirtualFile file) {
        if (file == null) {
            DartAnalysisServerService.$$$reportNull$$$0(65);
        }
        Set<String> set = this.myFilePathsWithErrors;
        synchronized (set) {
            return file.isDirectory() ? this.myFolderPathsWithErrors.get((Object)file.getPath()) > 0 : this.myFilePathsWithErrors.contains(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilePathsWithErrorsHash() {
        Set<String> set = this.myFilePathsWithErrors;
        synchronized (set) {
            return this.myFilePathsWithErrors.hashCode();
        }
    }

    private void logError(@NotNull String methodName, @Nullable String filePath, @NotNull RequestError error) {
        String trace;
        if (methodName == null) {
            DartAnalysisServerService.$$$reportNull$$$0(66);
        }
        if (error == null) {
            DartAnalysisServerService.$$$reportNull$$$0(67);
        }
        String partialTrace = (trace = error.getStackTrace()) == null || trace.isEmpty() ? "" : trace.substring(0, Math.min(trace.length(), 1000));
        String message = this.getShortErrorMessage(methodName, filePath, error) + "\n" + partialTrace + "...";
        LOG.error(message);
    }

    private String getShortErrorMessage(@NotNull String methodName, @Nullable String filePath, @NotNull RequestError error) {
        if (methodName == null) {
            DartAnalysisServerService.$$$reportNull$$$0(68);
        }
        if (error == null) {
            DartAnalysisServerService.$$$reportNull$$$0(69);
        }
        return "Error from " + methodName + (filePath == null ? "" : ", file = " + filePath) + ", SDK version = " + this.mySdkVersion + ", server version = " + this.myServerVersion + ", error code = " + error.getCode() + ": " + error.getMessage();
    }

    private static boolean awaitForLatchCheckingCanceled(@NotNull AnalysisServer server, @NotNull CountDownLatch latch, long timeoutInMillis) {
        if (server == null) {
            DartAnalysisServerService.$$$reportNull$$$0(70);
        }
        if (latch == null) {
            DartAnalysisServerService.$$$reportNull$$$0(71);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            timeoutInMillis *= 10L;
        }
        long startTime = System.currentTimeMillis();
        do {
            ProgressManager.checkCanceled();
            if (!server.isSocketOpen()) {
                return false;
            }
            if (timeoutInMillis == -1L || System.currentTimeMillis() <= startTime + timeoutInMillis) continue;
            return false;
        } while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
        return true;
    }

    private void registerPostfixCompletionTemplates() {
        ApplicationManager.getApplication().invokeLater(() -> DartPostfixTemplateProvider.initializeTemplates(this), ModalityState.NON_MODAL);
    }

    private static void registerQuickAssistIntentions() {
        IntentionManager intentionManager = IntentionManager.getInstance();
        QuickAssistSet quickAssistSet = new QuickAssistSet();
        int i = 0;
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
        intentionManager.addAction((IntentionAction)new DartQuickAssistIntention(quickAssistSet, i++){});
    }

    public void addOutlineListener(@NotNull DartServerData.OutlineListener listener) {
        if (listener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(72);
        }
        this.myServerData.addOutlineListener(listener);
    }

    public void removeOutlineListener(@NotNull DartServerData.OutlineListener listener) {
        if (listener == null) {
            DartAnalysisServerService.$$$reportNull$$$0(73);
        }
        this.myServerData.removeOutlineListener(listener);
    }

    public String generateUniqueId() {
        AnalysisServer server = this.myServer;
        if (server == null) {
            return null;
        }
        return server.generateUniqueId();
    }

    public void sendRequest(String id, JsonObject request) {
        AnalysisServer server = this.myServer;
        if (server != null) {
            server.sendRequestToServer(id, request);
        }
    }

    public void sendRequestToServer(String id, JsonObject request, com.google.dart.server.Consumer consumer) {
        AnalysisServer server = this.myServer;
        if (server != null) {
            server.sendRequestToServer(id, request, consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionId";
                break;
            }
            case 5: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 8: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 63: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseListener";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedRoots";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedElements";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_filePath";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextId";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_id";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latch";
                break;
            }
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlight";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverrideMembers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedClasses";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedMembers";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "analysis_getHover";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "edit_getAssists";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "search_getTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedOffsets";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedLengths";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDartSdkVersionSufficient";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureImportedLibraries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doConfigureImportedLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAnalysisServerListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeAnalysisServerListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addResponseListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeResponseListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErrors";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getHighlight";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNavigation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOverrideMembers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedClasses";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedMembers";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "onErrorsUpdated";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateFilesWithErrorsSet";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "analysis_getHover";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "analysis_getNavigation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "edit_getAssists";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "edit_getPostfixCompletion";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "edit_getStatementCompletion";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "askForFixesAndWaitABitIfReceivedQuickly";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "search_findElementReferences";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "search_getTypeHierarchy";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "completion_getSuggestions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "edit_format";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "analysis_getImportedElements";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "edit_importElements";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "edit_organizeDirectives";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "edit_sortMembers";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "execution_createContext";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "execution_deleteContext";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "execution_mapUri";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "serverReadyForRequest";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "waitForAnalysisToComplete_TESTS_ONLY";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithErrors";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getShortErrorMessage";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "awaitForLatchCheckingCanceled";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addOutlineListener";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeOutlineListener";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doConfigureImportedLibraries$2";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureImportedLibraries$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InteractiveErrorReporter {
        @NotNull
        private final QueueProcessor<Runnable> myErrorReporter = QueueProcessor.createRunnableQueueProcessor();
        private long myPreviousTime;
        @NotNull
        private String myPreviousMessage = "";
        private int myDisruptionCount = 0;

        private InteractiveErrorReporter() {
        }

        public void report(@NotNull String errorMessage) {
            if (errorMessage == null) {
                InteractiveErrorReporter.$$$reportNull$$$0(0);
            }
            if (this.myDisruptionCount > 20) {
                return;
            }
            long timeStamp = System.currentTimeMillis();
            if (timeStamp - this.myPreviousTime < 5000L) {
                if (this.messageDiffers(errorMessage)) {
                    LOG.warn(errorMessage);
                    if (this.myDisruptionCount > 0) {
                        ++this.myDisruptionCount;
                    }
                }
                return;
            }
            this.myPreviousTime = timeStamp;
            if (this.messageDiffers(errorMessage)) {
                String debugLog = this.debugLogContent();
                this.myErrorReporter.add(() -> {
                    if (errorMessage == null) {
                        InteractiveErrorReporter.$$$reportNull$$$0(2);
                    }
                    DartFeedbackBuilder builder = DartFeedbackBuilder.getFeedbackBuilder();
                    ++this.myDisruptionCount;
                    builder.showNotification(DartBundle.message("dart.analysis.server.error", new Object[0]), DartAnalysisServerService.this.myProject, errorMessage, debugLog);
                });
            }
            this.myPreviousMessage = errorMessage;
        }

        private boolean messageDiffers(@NotNull String errorMessage) {
            int prevIdx;
            if (errorMessage == null) {
                InteractiveErrorReporter.$$$reportNull$$$0(1);
            }
            if ((prevIdx = this.myPreviousMessage.indexOf(DartAnalysisServerService.STACK_TRACE_MARKER)) < 0) {
                return !errorMessage.equals(this.myPreviousMessage);
            }
            int errIdx = errorMessage.indexOf(DartAnalysisServerService.STACK_TRACE_MARKER);
            if (errIdx < 0) {
                return !errorMessage.equals(this.myPreviousMessage);
            }
            return !errorMessage.substring(errIdx).equals(this.myPreviousMessage.substring(prevIdx));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String debugLogContent() {
            StringBuilder log = new StringBuilder();
            log.append("```\n");
            EvictingQueue evictingQueue = DartAnalysisServerService.this.myDebugLog;
            synchronized (evictingQueue) {
                for (String s : DartAnalysisServerService.this.myDebugLog) {
                    log.append(s).append('\n');
                }
            }
            log.append("```\n");
            return log.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "errorMessage";
            objectArray2[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$InteractiveErrorReporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "report";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageDiffers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$report$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SearchResultsSet {
        @NotNull
        final String id;
        @NotNull
        final List<SearchResult> results;
        final boolean isLast;

        public SearchResultsSet(@NotNull String id, @NotNull List<SearchResult> results, boolean isLast) {
            if (id == null) {
                SearchResultsSet.$$$reportNull$$$0(0);
            }
            if (results == null) {
                SearchResultsSet.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.results = results;
            this.isLast = isLast;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "results";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$SearchResultsSet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompletionInfo {
        @NotNull
        private final String myCompletionId;
        private final int myOriginalReplacementOffset;
        private final int myOriginalReplacementLength;
        @NotNull
        private final List<CompletionSuggestion> myCompletions;
        private final boolean isLast;

        public CompletionInfo(@NotNull String completionId, int replacementOffset, int originalReplacementLength, @NotNull List<CompletionSuggestion> completions, boolean isLast) {
            if (completionId == null) {
                CompletionInfo.$$$reportNull$$$0(0);
            }
            if (completions == null) {
                CompletionInfo.$$$reportNull$$$0(1);
            }
            this.myCompletionId = completionId;
            this.myOriginalReplacementOffset = replacementOffset;
            this.myOriginalReplacementLength = originalReplacementLength;
            this.myCompletions = completions;
            this.isLast = isLast;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/analyzer/DartAnalysisServerService$CompletionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface CompletionSuggestionConsumer {
        public void consumeCompletionSuggestion(int var1, int var2, @NotNull CompletionSuggestion var3);
    }

    public static class FormatResult {
        @Nullable
        private final List<SourceEdit> myEdits;
        private final int myOffset;
        private final int myLength;

        public FormatResult(@Nullable List<SourceEdit> edits, int selectionOffset, int selectionLength) {
            this.myEdits = edits;
            this.myOffset = selectionOffset;
            this.myLength = selectionLength;
        }

        public int getLength() {
            return this.myLength;
        }

        public int getOffset() {
            return this.myOffset;
        }

        @Nullable
        public List<SourceEdit> getEdits() {
            return this.myEdits;
        }
    }
}

