/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileListener;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProjectComponent
extends AbstractProjectComponent {
    private final SimpleModificationTracker myProjectRootsModificationTracker;

    protected DartProjectComponent(@NotNull Project project) {
        if (project == null) {
            DartProjectComponent.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProjectRootsModificationTracker = new SimpleModificationTracker();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new DartFileListener(project), (Disposable)project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DartProjectComponent.this.myProjectRootsModificationTracker.incModificationCount();
                DartFileListener.scheduleDartPackageRootsUpdate(DartProjectComponent.this.myProject);
            }
        });
    }

    @NotNull
    public static ModificationTracker getProjectRootsModificationTracker(@NotNull Project project) {
        if (project == null) {
            DartProjectComponent.$$$reportNull$$$0(1);
        }
        if (project.isDefault()) {
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            if (modificationTracker == null) {
                DartProjectComponent.$$$reportNull$$$0(2);
            }
            return modificationTracker;
        }
        DartProjectComponent component = (DartProjectComponent)((Object)project.getComponent(DartProjectComponent.class));
        assert (component != null);
        SimpleModificationTracker simpleModificationTracker = component.myProjectRootsModificationTracker;
        if (simpleModificationTracker == null) {
            DartProjectComponent.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            this.removeGlobalDartSdkLib();
            this.convertOrderEntriesTargetingGlobalDartSdkLib();
            DartiumUtil.resetDartiumFlags();
            Collection pubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            for (VirtualFile pubspecYamlFile : pubspecYamlFiles) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)pubspecYamlFile, (Project)this.myProject);
                if (module == null || !FileTypeIndex.containsFileOfType((FileType)DartFileType.INSTANCE, (GlobalSearchScope)module.getModuleContentScope())) continue;
                DartProjectComponent.excludeBuildAndPackagesFolders(module, pubspecYamlFile);
            }
            DartFileListener.scheduleDartPackageRootsUpdate(this.myProject);
        });
    }

    private void removeGlobalDartSdkLib() {
        for (Library library : ApplicationLibraryTable.getApplicationTable().getLibraries()) {
            if (!"Dart SDK".equals(library.getName())) continue;
            DartSdk oldGlobalSdk = DartSdk.getSdkByLibrary(library);
            if (oldGlobalSdk != null) {
                DartSdkUtil.updateKnownSdkPaths(this.myProject, oldGlobalSdk.getHomePath());
            }
            ApplicationManager.getApplication().runWriteAction(() -> ApplicationLibraryTable.getApplicationTable().removeLibrary(library));
            return;
        }
    }

    private void convertOrderEntriesTargetingGlobalDartSdkLib() {
        DartSdk correctSdk = DartSdk.getDartSdk(this.myProject);
        if (correctSdk != null) {
            return;
        }
        if (!this.hasIncorrectModuleDependencies()) {
            return;
        }
        String sdkPath = DartSdkUtil.getFirstKnownDartSdkPath();
        if (sdkPath == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            DartSdkLibUtil.ensureDartSdkConfigured(this.myProject, sdkPath);
            SmartList modelsToCommit = new SmartList();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                boolean hasCorrectDependency = false;
                boolean needsCorrectDependency = false;
                SmartList orderEntriesToRemove = new SmartList();
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (DartProjectComponent.isOldGlobalDartSdkLibEntry(orderEntry)) {
                        needsCorrectDependency = true;
                        orderEntriesToRemove.add(orderEntry);
                        continue;
                    }
                    if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                    hasCorrectDependency = true;
                }
                if (needsCorrectDependency && !hasCorrectDependency || !orderEntriesToRemove.isEmpty()) {
                    if (needsCorrectDependency && !hasCorrectDependency) {
                        model.addInvalidLibrary("Dart SDK", "project");
                    }
                    for (OrderEntry entry : orderEntriesToRemove) {
                        model.removeOrderEntry(entry);
                    }
                    modelsToCommit.add(model);
                    continue;
                }
                model.dispose();
            }
            DartProjectComponent.commitModifiableModels(this.myProject, (Collection<ModifiableRootModel>)modelsToCommit);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitModifiableModels(@NotNull Project project, @NotNull Collection<ModifiableRootModel> modelsToCommit) {
        if (project == null) {
            DartProjectComponent.$$$reportNull$$$0(4);
        }
        if (modelsToCommit == null) {
            DartProjectComponent.$$$reportNull$$$0(5);
        }
        if (!modelsToCommit.isEmpty()) {
            try {
                ModifiableModelCommitter.multiCommit(modelsToCommit, (ModifiableModuleModel)ModuleManager.getInstance((Project)project).getModifiableModel());
            }
            finally {
                for (ModifiableRootModel model : modelsToCommit) {
                    if (model.isDisposed()) continue;
                    model.dispose();
                }
            }
        }
    }

    private boolean hasIncorrectModuleDependencies() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!DartProjectComponent.isOldGlobalDartSdkLibEntry(orderEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOldGlobalDartSdkLibEntry(OrderEntry orderEntry) {
        return orderEntry instanceof LibraryOrderEntry && "application".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) && "Dart SDK".equals(((LibraryOrderEntry)orderEntry).getLibraryName());
    }

    public static void excludeBuildAndPackagesFolders(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile) {
        VirtualFile root;
        VirtualFile contentRoot;
        if (module == null) {
            DartProjectComponent.$$$reportNull$$$0(6);
        }
        if (pubspecYamlFile == null) {
            DartProjectComponent.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = contentRoot = (root = pubspecYamlFile.getParent()) == null ? null : ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(root);
        if (contentRoot == null) {
            return;
        }
        List oldExcludedUrls = ContainerUtil.filter((Object[])ModuleRootManager.getInstance((Module)module).getExcludeRootUrls(), (Condition)new Condition<String>(){
            final String rootUrl;
            {
                this.rootUrl = root.getUrl();
            }

            public boolean value(String url) {
                if (url.equals(this.rootUrl + "/.dart_tool")) {
                    return true;
                }
                if (url.equals(this.rootUrl + "/.pub")) {
                    return true;
                }
                if (url.equals(this.rootUrl + "/build")) {
                    return true;
                }
                if (url.equals(this.rootUrl + "/packages")) {
                    return true;
                }
                if (url.startsWith(root + "/packages/")) {
                    return true;
                }
                return url.endsWith("/packages") && (url.startsWith(this.rootUrl + "/bin/") || url.startsWith(this.rootUrl + "/benchmark/") || url.startsWith(this.rootUrl + "/example/") || url.startsWith(this.rootUrl + "/test/") || url.startsWith(this.rootUrl + "/tool/") | url.startsWith(this.rootUrl + "/web/"));
            }
        });
        Set<String> newExcludedUrls = DartProjectComponent.collectFolderUrlsToExclude(module, pubspecYamlFile);
        if (oldExcludedUrls.size() != newExcludedUrls.size() || !newExcludedUrls.containsAll(oldExcludedUrls)) {
            ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, (Collection)oldExcludedUrls, newExcludedUrls);
        }
    }

    private static Set<String> collectFolderUrlsToExclude(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile) {
        if (module == null) {
            DartProjectComponent.$$$reportNull$$$0(8);
        }
        if (pubspecYamlFile == null) {
            DartProjectComponent.$$$reportNull$$$0(9);
        }
        THashSet newExcludedPackagesUrls = new THashSet();
        VirtualFile root = pubspecYamlFile.getParent();
        DartSdk sdk = DartSdk.getDartSdk(module.getProject());
        if (sdk != null && StringUtil.compareVersionNumbers((String)sdk.getVersion(), (String)"2.0") >= 0) {
            newExcludedPackagesUrls.add((Object)(root.getUrl() + "/.dart_tool"));
        }
        newExcludedPackagesUrls.add((Object)(root.getUrl() + "/.pub"));
        newExcludedPackagesUrls.add((Object)(root.getUrl() + "/build"));
        newExcludedPackagesUrls.addAll(DartProjectComponent.getExcludedPackageSymlinkUrls(module.getProject(), root));
        return newExcludedPackagesUrls;
    }

    public static THashSet<String> getExcludedPackageSymlinkUrls(@NotNull Project project, @NotNull VirtualFile dartProjectRoot) {
        VirtualFile binFolder;
        if (project == null) {
            DartProjectComponent.$$$reportNull$$$0(10);
        }
        if (dartProjectRoot == null) {
            DartProjectComponent.$$$reportNull$$$0(11);
        }
        THashSet result = new THashSet();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (new File(dartProjectRoot.getPath() + "/packages").isDirectory()) {
            result.add((Object)(dartProjectRoot.getUrl() + "/packages"));
        }
        if ((binFolder = dartProjectRoot.findChild("bin")) != null && binFolder.isDirectory() && fileIndex.isInContent(binFolder) && new File(binFolder.getPath() + "/packages").isDirectory()) {
            result.add((Object)(binFolder.getUrl() + "/packages"));
        }
        DartProjectComponent.appendPackagesFolders((Collection<String>)result, dartProjectRoot.findChild("benchmark"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)result, dartProjectRoot.findChild("example"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)result, dartProjectRoot.findChild("test"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)result, dartProjectRoot.findChild("tool"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)result, dartProjectRoot.findChild("web"), fileIndex);
        return result;
    }

    private static void appendPackagesFolders(final @NotNull Collection<String> excludedPackagesUrls, @Nullable VirtualFile folder, final @NotNull ProjectFileIndex fileIndex) {
        if (excludedPackagesUrls == null) {
            DartProjectComponent.$$$reportNull$$$0(12);
        }
        if (fileIndex == null) {
            DartProjectComponent.$$$reportNull$$$0(13);
        }
        if (folder == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!fileIndex.isInContent(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (file.isDirectory()) {
                    if ("packages".equals(file.getName())) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return result;
                    }
                    if (new File(file.getPath() + "/packages").isDirectory()) {
                        excludedPackagesUrls.add(file.getUrl() + "/packages");
                    }
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    3.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/lang/dart/DartProjectComponent$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/lang/dart/DartProjectComponent$3";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/DartProjectComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsToCommit";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecYamlFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartProjectRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPackagesUrls";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/DartProjectComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRootsModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootsModificationTracker";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commitModifiableModels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "excludeBuildAndPackagesFolders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectFolderUrlsToExclude";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedPackageSymlinkUrls";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendPackagesFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

