/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryProperties;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryType;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFileListener
implements VirtualFileListener {
    private static final Key<Boolean> DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS = Key.create((String)"DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS");
    private final Project myProject;

    public DartFileListener(Project project) {
        this.myProject = project;
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(0);
        }
        this.propertyChanged(event);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(1);
        }
        if ("name".equals(event.getPropertyName())) {
            DartFileListener.fileChanged(this.myProject, event.getFile());
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(2);
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(3);
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(4);
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(5);
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            DartFileListener.$$$reportNull$$$0(6);
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    private static void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile pubspec;
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DartFileListener.$$$reportNull$$$0(8);
        }
        if (!".packages".equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = pubspec = parent == null ? null : parent.findChild("pubspec.yaml");
        if (pubspec != null) {
            DartFileListener.scheduleDartPackageRootsUpdate(project);
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)pubspec, (Project)project);
            if (module != null && !module.isDisposed() && !project.isDisposed()) {
                DartProjectComponent.excludeBuildAndPackagesFolders(module, pubspec);
            }
        }
    }

    public static void setDartPackageRootUpdateScheduledOrInProgress(@NotNull Project project, boolean scheduledOrInProgress) {
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(9);
        }
        if (scheduledOrInProgress) {
            project.putUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS, (Object)true);
        } else {
            project.putUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS, null);
        }
    }

    public static void scheduleDartPackageRootsUpdate(@NotNull Project project) {
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(10);
        }
        if (Registry.is((String)"dart.projects.without.pubspec", (boolean)false)) {
            return;
        }
        if (project.getUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS) == Boolean.TRUE) {
            return;
        }
        DartFileListener.setDartPackageRootUpdateScheduledOrInProgress(project, Boolean.TRUE);
        Runnable runnable = () -> {
            if (project == null) {
                DartFileListener.$$$reportNull$$$0(29);
            }
            try {
                Library library = DartFileListener.actualizePackagesLibrary(project);
                if (library == null) {
                    DartFileListener.removeDartPackagesLibraryAndDependencies(project);
                } else {
                    Condition moduleFilter = DartSdkLibUtil::isDartSdkEnabled;
                    DartFileListener.updateDependenciesOnDartPackagesLibrary(project, (Condition<Module>)moduleFilter, library);
                }
            }
            finally {
                DartFileListener.setDartPackageRootUpdateScheduledOrInProgress(project, false);
            }
        };
        DumbService.getInstance((Project)project).smartInvokeLater(runnable, ModalityState.NON_MODAL);
    }

    @Nullable
    private static Library actualizePackagesLibrary(@NotNull Project project) {
        DartLibInfo libInfo;
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(11);
        }
        if ((libInfo = DartFileListener.collectPackagesLibraryRoots(project)).getLibRootUrls().isEmpty()) {
            return null;
        }
        return DartFileListener.updatePackagesLibraryRoots(project, libInfo);
    }

    @NotNull
    private static DartLibInfo collectPackagesLibraryRoots(@NotNull Project project) {
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(12);
        }
        DartLibInfo libInfo = new DartLibInfo(false);
        Collection pubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile pubspecFile : pubspecYamlFiles) {
            Map<String, String> packagesMap;
            VirtualFile dotPackagesFile;
            Module module = fileIndex.getModuleForFile(pubspecFile);
            if (module == null || !DartSdkLibUtil.isDartSdkEnabled(module) || (dotPackagesFile = DartFileListener.findDotPackagesFile(pubspecFile.getParent())) == null || (packagesMap = DotPackagesFileUtil.getPackagesMap(dotPackagesFile)) == null) continue;
            for (Map.Entry<String, String> entry : packagesMap.entrySet()) {
                String packageName = entry.getKey();
                String packagePath = entry.getValue();
                if (!DartFileListener.isPathOutsideProjectContent(fileIndex, packagePath)) continue;
                libInfo.addPackage(packageName, packagePath);
            }
        }
        DartLibInfo dartLibInfo = libInfo;
        if (dartLibInfo == null) {
            DartFileListener.$$$reportNull$$$0(13);
        }
        return dartLibInfo;
    }

    @Nullable
    private static VirtualFile findDotPackagesFile(@Nullable VirtualFile dir) {
        while (dir != null) {
            VirtualFile file = dir.findChild(".packages");
            if (file != null && !file.isDirectory()) {
                return file;
            }
            dir = dir.getParent();
        }
        return null;
    }

    @NotNull
    public static Library updatePackagesLibraryRoots(@NotNull Project project, @NotNull DartLibInfo libInfo) {
        LibraryTable projectLibraryTable;
        Library existingLibrary;
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(14);
        }
        if (libInfo == null) {
            DartFileListener.$$$reportNull$$$0(15);
        }
        Library library = (existingLibrary = (projectLibraryTable = ProjectLibraryTable.getInstance((Project)project)).getLibraryByName("Dart Packages")) != null ? existingLibrary : (Library)WriteAction.compute(() -> {
            if (project == null) {
                DartFileListener.$$$reportNull$$$0(28);
            }
            LibraryTable.ModifiableModel libTableModel = ProjectLibraryTable.getInstance((Project)project).getModifiableModel();
            Library lib = libTableModel.createLibrary("Dart Packages", DartPackagesLibraryType.LIBRARY_KIND);
            libTableModel.commit();
            return lib;
        });
        String[] existingUrls = library.getUrls(OrderRootType.CLASSES);
        Set<String> libRootUrls = libInfo.getLibRootUrls();
        if (!libInfo.isProjectWithoutPubspec() && DartFileListener.isBrokenPackageMap(((LibraryEx)library).getProperties()) || existingUrls.length != libRootUrls.size() || !libRootUrls.containsAll(Arrays.asList(existingUrls))) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (libInfo == null) {
                    DartFileListener.$$$reportNull$$$0(27);
                }
                LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
                for (String url : existingUrls) {
                    model.removeRoot(url, OrderRootType.CLASSES);
                }
                for (String url : libRootUrls) {
                    model.addRoot(url, OrderRootType.CLASSES);
                }
                DartPackagesLibraryProperties libraryProperties = new DartPackagesLibraryProperties();
                libraryProperties.setPackageNameToDirsMap(libInfo.getPackagesMap());
                model.setProperties((LibraryProperties)libraryProperties);
                model.commit();
            });
        }
        Library library2 = library;
        if (library2 == null) {
            DartFileListener.$$$reportNull$$$0(16);
        }
        return library2;
    }

    private static boolean isBrokenPackageMap(@Nullable LibraryProperties properties) {
        if (!(properties instanceof DartPackagesLibraryProperties)) {
            return true;
        }
        for (Map.Entry<String, List<String>> entry : ((DartPackagesLibraryProperties)properties).getPackageNameToDirsMap().entrySet()) {
            if (entry != null && entry.getKey() != null && entry.getValue() != null) continue;
            return true;
        }
        return false;
    }

    private static void removeDartPackagesLibraryAndDependencies(@NotNull Project project) {
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(17);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            DartFileListener.removeDependencyOnDartPackagesLibrary(module);
        }
        Library library = ProjectLibraryTable.getInstance((Project)project).getLibraryByName("Dart Packages");
        if (library != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    DartFileListener.$$$reportNull$$$0(26);
                }
                ProjectLibraryTable.getInstance((Project)project).removeLibrary(library);
            });
        }
    }

    public static void updateDependenciesOnDartPackagesLibrary(@NotNull Project project, @NotNull Condition<Module> moduleFilter, @NotNull Library library) {
        if (project == null) {
            DartFileListener.$$$reportNull$$$0(18);
        }
        if (moduleFilter == null) {
            DartFileListener.$$$reportNull$$$0(19);
        }
        if (library == null) {
            DartFileListener.$$$reportNull$$$0(20);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (moduleFilter.value((Object)module)) {
                DartFileListener.addDependencyOnDartPackagesLibrary(module, library);
                continue;
            }
            DartFileListener.removeDependencyOnDartPackagesLibrary(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDependencyOnDartPackagesLibrary(@NotNull Module module) {
        if (module == null) {
            DartFileListener.$$$reportNull$$$0(21);
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (modifiableModel.isChanged()) {
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
            }
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDependencyOnDartPackagesLibrary(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            DartFileListener.$$$reportNull$$$0(22);
        }
        if (library == null) {
            DartFileListener.$$$reportNull$$$0(23);
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                return;
            }
            modifiableModel.addLibraryEntry(library);
            ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    private static boolean isPathOutsideProjectContent(@NotNull ProjectFileIndex fileIndex, @NotNull String path) {
        if (fileIndex == null) {
            DartFileListener.$$$reportNull$$$0(24);
        }
        if (path == null) {
            DartFileListener.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && path.contains("/pub/global/cache/")) {
            return true;
        }
        while (!path.isEmpty()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null) {
                path = PathUtil.getParentPath((String)path);
                continue;
            }
            return !fileIndex.isInContent(file);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/DartFileListener";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilter";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/DartFileListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesLibraryRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePackagesLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileCreated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileMoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileCopied";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDartPackageRootUpdateScheduledOrInProgress";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleDartPackageRootsUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "actualizePackagesLibrary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesLibraryRoots";
                break;
            }
            case 13: 
            case 16: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesLibraryRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeDartPackagesLibraryAndDependencies";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnDartPackagesLibrary";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeDependencyOnDartPackagesLibrary";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyOnDartPackagesLibrary";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isPathOutsideProjectContent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeDartPackagesLibraryAndDependencies$3";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updatePackagesLibraryRoots$2";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updatePackagesLibraryRoots$1";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleDartPackageRootsUpdate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartLibInfo {
        private final boolean myProjectWithoutPubspec;
        private final Set<String> myLibRootUrls = new TreeSet<String>();
        private final Map<String, List<String>> myPackagesMap = new TreeMap<String, List<String>>();

        public DartLibInfo(boolean projectWithoutPubspec) {
            this.myProjectWithoutPubspec = projectWithoutPubspec;
        }

        private void addPackage(@NotNull String packageName, @NotNull String packagePath) {
            if (packageName == null) {
                DartLibInfo.$$$reportNull$$$0(0);
            }
            if (packagePath == null) {
                DartLibInfo.$$$reportNull$$$0(1);
            }
            this.myLibRootUrls.add(VfsUtilCore.pathToUrl((String)packagePath));
            SmartList paths = this.myPackagesMap.get(packageName);
            if (paths == null) {
                paths = new SmartList();
                this.myPackagesMap.put(packageName, (List<String>)paths);
            }
            if (!paths.contains(packagePath)) {
                paths.add(packagePath);
            }
        }

        public void addRoots(Collection<String> dirPaths) {
            for (String path : dirPaths) {
                this.myLibRootUrls.add(VfsUtilCore.pathToUrl((String)path));
            }
        }

        public boolean isProjectWithoutPubspec() {
            return this.myProjectWithoutPubspec;
        }

        public Set<String> getLibRootUrls() {
            return this.myLibRootUrls;
        }

        public Map<String, List<String>> getPackagesMap() {
            return this.myPackagesMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packagePath";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/DartFileListener$DartLibInfo";
            objectArray[2] = "addPackage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

