/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartEnumDefinition;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartForInPart;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartFunctionExpression;
import com.jetbrains.lang.dart.psi.DartFunctionFormalParameter;
import com.jetbrains.lang.dart.psi.DartFunctionTypeAlias;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartLabel;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DartComponentType {
    CLASS(AllIcons.Nodes.Class){

        @Override
        public Icon getIcon(@NotNull DartComponent component) {
            if (component == null) {
                1.$$$reportNull$$$0(0);
            }
            return component instanceof DartEnumDefinition ? AllIcons.Nodes.Enum : (component.isAbstract() ? AllIcons.Nodes.AbstractClass : this.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/DartComponentType$1", "getIcon"));
        }
    }
    ,
    FUNCTION(AllIcons.Nodes.Function){

        @Override
        public Icon getIcon(@NotNull DartComponent component) {
            if (component == null) {
                2.$$$reportNull$$$0(0);
            }
            if (component.isGetter()) {
                return AllIcons.Nodes.PropertyReadStatic;
            }
            if (component.isSetter()) {
                return AllIcons.Nodes.PropertyWriteStatic;
            }
            return this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/DartComponentType$2", "getIcon"));
        }
    }
    ,
    METHOD(AllIcons.Nodes.Method){

        @Override
        public Icon getIcon(@NotNull DartComponent component) {
            if (component == null) {
                3.$$$reportNull$$$0(0);
            }
            if (component.isGetter()) {
                return component.isStatic() ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
            }
            if (component.isSetter()) {
                return component.isStatic() ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
            }
            return component.isAbstract() ? AllIcons.Nodes.AbstractMethod : this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/DartComponentType$3", "getIcon"));
        }
    }
    ,
    VARIABLE(AllIcons.Nodes.Variable),
    FIELD(AllIcons.Nodes.Field),
    PARAMETER(AllIcons.Nodes.Parameter),
    TYPEDEF(AllIcons.Nodes.Annotationtype),
    CONSTRUCTOR(AllIcons.Nodes.Method),
    OPERATOR(AllIcons.Nodes.ClassInitializer),
    LABEL(AllIcons.Nodes.Variable);

    private final Icon myIcon;

    private DartComponentType(Icon icon) {
        this.myIcon = icon;
    }

    public int getKey() {
        return this.ordinal();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getIcon(@NotNull DartComponent component) {
        if (component == null) {
            DartComponentType.$$$reportNull$$$0(0);
        }
        return this.getIcon();
    }

    @Nullable
    public static DartComponentType valueOf(int key) {
        return key >= 0 && key < DartComponentType.values().length ? DartComponentType.values()[key] : null;
    }

    @Nullable
    public static DartComponentType typeOf(@Nullable PsiElement element) {
        if (element instanceof DartComponentName) {
            return DartComponentType.typeOf(element.getParent());
        }
        if (element instanceof DartComponent && PsiTreeUtil.getParentOfType((PsiElement)element, DartNormalFormalParameter.class, (boolean)false) != null || element instanceof DartNormalFormalParameter) {
            return PARAMETER;
        }
        if (element instanceof DartClass) {
            return CLASS;
        }
        if (element instanceof DartEnumConstantDeclaration) {
            return FIELD;
        }
        if (element instanceof DartFunctionTypeAlias) {
            return TYPEDEF;
        }
        if (element instanceof DartNamedConstructorDeclaration || element instanceof DartFactoryConstructorDeclaration) {
            return CONSTRUCTOR;
        }
        if (element instanceof DartFunctionFormalParameter || element instanceof DartFunctionDeclarationWithBody || element instanceof DartFunctionDeclarationWithBodyOrNative || element instanceof DartFunctionExpression) {
            return FUNCTION;
        }
        if (element instanceof DartGetterDeclaration || element instanceof DartSetterDeclaration) {
            PsiElement dartClassCandidate = PsiTreeUtil.getParentOfType((PsiElement)element, DartComponent.class);
            return dartClassCandidate instanceof DartClass ? METHOD : FUNCTION;
        }
        if (element instanceof DartMethodDeclaration) {
            if (((DartMethodDeclaration)element).isOperator()) {
                return OPERATOR;
            }
            DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class);
            String dartClassName = dartClass != null ? dartClass.getName() : null;
            return dartClassName != null && dartClassName.equals(((DartComponent)element).getName()) ? CONSTRUCTOR : METHOD;
        }
        if (element instanceof DartVarAccessDeclaration || element instanceof DartVarDeclarationListPart) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, DartComponent.class) instanceof DartClass ? FIELD : VARIABLE;
        }
        if (element instanceof DartForInPart) {
            return VARIABLE;
        }
        if (element instanceof DartLabel) {
            return LABEL;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/DartComponentType", "getIcon"));
    }
}

