/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.utilities.instrumentation;

import com.google.dart.server.utilities.instrumentation.InstrumentationBuilder;
import com.google.dart.server.utilities.instrumentation.InstrumentationLevel;
import com.google.dart.server.utilities.instrumentation.InstrumentationLogger;

public final class Instrumentation {
    private static final InstrumentationBuilder NULL_INSTRUMENTATION_BUILDER = new InstrumentationBuilder(){

        @Override
        public InstrumentationBuilder data(String name, boolean value) {
            return this;
        }

        @Override
        public InstrumentationBuilder data(String name, long value) {
            return this;
        }

        @Override
        public InstrumentationBuilder data(String name, String value) {
            return this;
        }

        @Override
        public InstrumentationBuilder data(String name, String[] value) {
            return this;
        }

        @Override
        public InstrumentationLevel getInstrumentationLevel() {
            return InstrumentationLevel.OFF;
        }

        @Override
        public void log() {
        }

        @Override
        public void log(int minTimeToLong) {
        }

        @Override
        public InstrumentationBuilder metric(String name, boolean value) {
            return this;
        }

        @Override
        public InstrumentationBuilder metric(String name, long value) {
            return this;
        }

        @Override
        public InstrumentationBuilder metric(String name, String value) {
            return this;
        }

        @Override
        public InstrumentationBuilder metric(String name, String[] value) {
            return this;
        }

        @Override
        public InstrumentationBuilder record(Throwable exception) {
            return this;
        }
    };
    private static final InstrumentationLogger NULL_LOGGER;
    private static InstrumentationLogger CURRENT_LOGGER;

    public static InstrumentationBuilder builder(Class<?> clazz) {
        return CURRENT_LOGGER.createBuilder(clazz.getSimpleName());
    }

    public static InstrumentationBuilder builder(String name) {
        return CURRENT_LOGGER.createBuilder(name);
    }

    public static InstrumentationLogger getLogger() {
        return CURRENT_LOGGER;
    }

    public static InstrumentationBuilder getNullBuilder() {
        return NULL_INSTRUMENTATION_BUILDER;
    }

    public static boolean isNullLogger() {
        return CURRENT_LOGGER == NULL_LOGGER;
    }

    public static void setLogger(InstrumentationLogger logger) {
        CURRENT_LOGGER = logger == null ? NULL_LOGGER : logger;
    }

    private Instrumentation() {
    }

    static {
        CURRENT_LOGGER = NULL_LOGGER = new InstrumentationLogger(){

            @Override
            public InstrumentationBuilder createBuilder(String name) {
                return NULL_INSTRUMENTATION_BUILDER;
            }
        };
    }
}

