/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.utilities.general;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.List;

public final class StringUtilities {
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final List<String> EMPTY_LIST = Lists.newArrayList();
    private static final Interner<String> INTERNER = Interners.newWeakInterner();

    public static String abbreviateLeft(String s, int width) {
        int length = s.length();
        if (length > width) {
            if (width < 4) {
                throw new IllegalArgumentException("Minimal width is 4");
            }
            return "..." + s.substring(length - (width - 3));
        }
        return s;
    }

    public static boolean endsWith3(String string, int char1, int char2, int char3) {
        int length = string.length();
        return length >= 3 && string.charAt(length - 3) == char1 && string.charAt(length - 2) == char2 && string.charAt(length - 1) == char3;
    }

    public static boolean endsWithChar(String string, int character) {
        int length = string.length();
        return length > 0 && string.charAt(length - 1) == character;
    }

    public static int indexOf1(String string, int startIndex, int char1) {
        int last = string.length();
        for (int index = startIndex; index < last; ++index) {
            if (string.charAt(index) != char1) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf2(String string, int startIndex, int char1, int char2) {
        int last = string.length() - 1;
        for (int index = startIndex; index < last; ++index) {
            if (string.charAt(index) != char1 || string.charAt(index + 1) != char2) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf4(String string, int startIndex, int char1, int char2, int char3, int char4) {
        int last = string.length() - 3;
        for (int index = startIndex; index < last; ++index) {
            if (string.charAt(index) != char1 || string.charAt(index + 1) != char2 || string.charAt(index + 2) != char3 || string.charAt(index + 3) != char4) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf5(String string, int startIndex, int char1, int char2, int char3, int char4, int char5) {
        int last = string.length() - 4;
        for (int index = startIndex; index < last; ++index) {
            if (string.charAt(index) != char1 || string.charAt(index + 1) != char2 || string.charAt(index + 2) != char3 || string.charAt(index + 3) != char4 || string.charAt(index + 4) != char5) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfFirstNotLetterDigit(String string, int startIndex) {
        int last = string.length();
        for (int index = startIndex; index < last; ++index) {
            char c = string.charAt(index);
            if (Character.isLetterOrDigit(c)) continue;
            return index;
        }
        return last;
    }

    public static String intern(String str) {
        if (str == null) {
            return null;
        }
        str = new String(str);
        return (String)INTERNER.intern((Object)str);
    }

    public static boolean isAlpha(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isTagName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int sz = s.length();
        for (int i = 0; i < sz; ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) continue;
            if (i == 0) {
                return false;
            }
            if (Character.isDigit(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    public static String printListOfQuotedNames(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("The list must not be null");
        }
        int count = names.length;
        if (count < 2) {
            throw new IllegalArgumentException("The list must contain at least two names");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        builder.append(names[0]);
        builder.append("'");
        for (int i = 1; i < count - 1; ++i) {
            builder.append(", '");
            builder.append(names[i]);
            builder.append("'");
        }
        builder.append(" and '");
        builder.append(names[count - 1]);
        builder.append("'");
        return builder.toString();
    }

    public static boolean startsWith2(String string, int startIndex, int char1, int char2) {
        return string.length() - startIndex >= 2 && string.charAt(startIndex) == char1 && string.charAt(startIndex + 1) == char2;
    }

    public static boolean startsWith3(String string, int startIndex, int char1, int char2, int char3) {
        return string.length() - startIndex >= 3 && string.charAt(startIndex) == char1 && string.charAt(startIndex + 1) == char2 && string.charAt(startIndex + 2) == char3;
    }

    public static boolean startsWith4(String string, int startIndex, int char1, int char2, int char3, int char4) {
        return string.length() - startIndex >= 4 && string.charAt(startIndex) == char1 && string.charAt(startIndex + 1) == char2 && string.charAt(startIndex + 2) == char3 && string.charAt(startIndex + 3) == char4;
    }

    public static boolean startsWith5(String string, int startIndex, int char1, int char2, int char3, int char4, int char5) {
        return string.length() - startIndex >= 5 && string.charAt(startIndex) == char1 && string.charAt(startIndex + 1) == char2 && string.charAt(startIndex + 2) == char3 && string.charAt(startIndex + 3) == char4 && string.charAt(startIndex + 4) == char5;
    }

    public static boolean startsWith6(String string, int startIndex, int char1, int char2, int char3, int char4, int char5, int char6) {
        return string.length() - startIndex >= 6 && string.charAt(startIndex) == char1 && string.charAt(startIndex + 1) == char2 && string.charAt(startIndex + 2) == char3 && string.charAt(startIndex + 3) == char4 && string.charAt(startIndex + 4) == char5 && string.charAt(startIndex + 5) == char6;
    }

    public static boolean startsWithChar(String string, int character) {
        return string.length() > 0 && string.charAt(0) == character;
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtilities.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtilities.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBeforeChar(String str, int separator) {
        if (StringUtilities.isEmpty(str)) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos < 0) {
            return str;
        }
        return str.substring(0, pos);
    }

    private StringUtilities() {
    }
}

