/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.utilities.general;

import com.google.dart.server.utilities.general.StringUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonUtilities {
    public static Boolean[] decodeBooleanArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return new Boolean[0];
        }
        int i = 0;
        Boolean[] booleanArray = new Boolean[jsonArray.size()];
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            booleanArray[i] = ((JsonElement)iterator.next()).getAsBoolean();
            ++i;
        }
        return booleanArray;
    }

    public static int[] decodeIntArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return new int[0];
        }
        int i = 0;
        int[] intArray = new int[jsonArray.size()];
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            intArray[i] = ((JsonElement)iterator.next()).getAsInt();
            ++i;
        }
        return intArray;
    }

    public static Integer[] decodeIntegerArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return new Integer[0];
        }
        int i = 0;
        Integer[] intArray = new Integer[jsonArray.size()];
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            intArray[i] = ((JsonElement)iterator.next()).getAsInt();
            ++i;
        }
        return intArray;
    }

    public static List<String> decodeStringList(JsonArray jsonArray) {
        if (jsonArray == null) {
            return StringUtilities.EMPTY_LIST;
        }
        ArrayList<String> stringList = new ArrayList<String>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            stringList.add(((JsonElement)iterator.next()).getAsString());
        }
        return stringList;
    }
}

