/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.ListPostfixCompletionTemplatesConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.dartlang.analysis.server.protocol.PostfixCompletionTemplate;
import org.dartlang.analysis.server.protocol.RequestError;

public class ListPostfixCompletionTemplatesProcessor
extends ResultProcessor {
    private final ListPostfixCompletionTemplatesConsumer consumer;

    public ListPostfixCompletionTemplatesProcessor(ListPostfixCompletionTemplatesConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                JsonArray items = resultObject.get("templates").getAsJsonArray();
                ArrayList templates = new ArrayList();
                items.forEach(item -> {
                    JsonObject temp = item.getAsJsonObject();
                    templates.add(PostfixCompletionTemplate.fromJson(temp));
                });
                this.consumer.postfixCompletionTemplates(templates.toArray(new PostfixCompletionTemplate[items.size()]));
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
    }
}

