/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.StringUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class JsonProcessor {
    protected int[] constructIntArray(JsonArray intJsonArray) {
        if (intJsonArray == null) {
            return new int[0];
        }
        int i = 0;
        int[] ints = new int[intJsonArray.size()];
        Iterator iterator = intJsonArray.iterator();
        while (iterator.hasNext()) {
            ints[i] = ((JsonElement)iterator.next()).getAsInt();
            ++i;
        }
        return ints;
    }

    protected String[] constructStringArray(JsonArray strJsonArray) {
        if (strJsonArray == null) {
            return StringUtilities.EMPTY_ARRAY;
        }
        ArrayList strings = Lists.newArrayList();
        Iterator iterator = strJsonArray.iterator();
        while (iterator.hasNext()) {
            strings.add(((JsonElement)iterator.next()).getAsString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected int safelyGetAsInt(JsonObject jsonObject, String memberName, int defaultValue) {
        JsonElement jsonElement = jsonObject.get(memberName);
        if (jsonElement == null) {
            return defaultValue;
        }
        return jsonElement.getAsInt();
    }

    protected JsonArray safelyGetAsJsonArray(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.getAsJsonArray();
    }

    protected JsonObject safelyGetAsJsonObject(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.getAsJsonObject();
    }

    protected String safelyGetAsString(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.getAsString();
    }
}

