/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetHoverConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.dartlang.analysis.server.protocol.HoverInformation;
import org.dartlang.analysis.server.protocol.RequestError;

public class HoverProcessor
extends ResultProcessor {
    private final GetHoverConsumer consumer;

    public HoverProcessor(GetHoverConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                ArrayList<HoverInformation> hovers = new ArrayList<HoverInformation>();
                Iterator iter = resultObject.get("hovers").getAsJsonArray().iterator();
                while (iter.hasNext()) {
                    JsonObject hoverJsonObject = ((JsonElement)iter.next()).getAsJsonObject();
                    hovers.add(HoverInformation.fromJson(hoverJsonObject));
                }
                this.consumer.computedHovers(hovers.toArray(new HoverInformation[hovers.size()]));
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

