/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetImportedElementsConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.ImportedElements;
import org.dartlang.analysis.server.protocol.RequestError;

public class GetImportedElementsProcessor
extends ResultProcessor {
    private final GetImportedElementsConsumer consumer;

    public GetImportedElementsProcessor(GetImportedElementsConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                List<ImportedElements> elements = ImportedElements.fromJsonArray(resultObject.getAsJsonArray("elements"));
                this.consumer.computedImportedElements(elements);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

