/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetFixesConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.AnalysisErrorFixes;
import org.dartlang.analysis.server.protocol.RequestError;

public class FixesProcessor
extends ResultProcessor {
    private final GetFixesConsumer consumer;

    public FixesProcessor(GetFixesConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                List<AnalysisErrorFixes> errorFixesArray = AnalysisErrorFixes.fromJsonArray(resultObject.get("fixes").getAsJsonArray());
                this.consumer.computedFixes(errorFixesArray);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

