/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetErrorsConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.RequestError;

public class AnalysisErrorsProcessor
extends ResultProcessor {
    private final GetErrorsConsumer consumer;

    public AnalysisErrorsProcessor(GetErrorsConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                ArrayList<AnalysisError> errors = new ArrayList<AnalysisError>();
                Iterator iter = resultObject.get("errors").getAsJsonArray().iterator();
                while (iter.hasNext()) {
                    JsonObject errorJsonObject = ((JsonElement)iter.next()).getAsJsonObject();
                    errors.add(AnalysisError.fromJson(errorJsonObject));
                }
                this.consumer.computedErrors(errors.toArray(new AnalysisError[errors.size()]));
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

