/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.dart.server.AnalysisServerSocket;
import com.google.dart.server.internal.remote.ByteLineReaderStream;
import com.google.dart.server.internal.remote.ByteRequestSink;
import com.google.dart.server.internal.remote.ByteResponseStream;
import com.google.dart.server.internal.remote.DebugPrintStream;
import com.google.dart.server.internal.remote.RequestSink;
import com.google.dart.server.internal.remote.ResponseStream;
import com.google.dart.server.utilities.logging.Logging;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class StdioServerSocket
implements AnalysisServerSocket {
    private final String runtimePath;
    private final List<String> vmArguments;
    private final String analysisServerPath;
    private final List<String> serverArguments;
    private final DebugPrintStream debugStream;
    private RequestSink requestSink;
    private ResponseStream responseStream;
    private ByteLineReaderStream errorStream;
    private Process process;
    private String clientId;
    private String clientVersion;

    public StdioServerSocket(String runtimePath, List<String> additionalVmArguments, String analysisServerPath, List<String> additionalServerArguments, DebugPrintStream debugStream) {
        this.runtimePath = runtimePath;
        this.vmArguments = (List)ObjectUtils.defaultIfNull(additionalVmArguments, (Object)Lists.newArrayList());
        this.analysisServerPath = analysisServerPath;
        this.serverArguments = (List)ObjectUtils.defaultIfNull(additionalServerArguments, (Object)Lists.newArrayList());
        this.debugStream = debugStream;
    }

    @Override
    public ByteLineReaderStream getErrorStream() {
        Preconditions.checkNotNull((Object)this.errorStream, (Object)"Server is not started.");
        return this.errorStream;
    }

    @Override
    public RequestSink getRequestSink() {
        Preconditions.checkNotNull((Object)this.requestSink, (Object)"Server is not started.");
        return this.requestSink;
    }

    @Override
    public ResponseStream getResponseStream() {
        Preconditions.checkNotNull((Object)this.responseStream, (Object)"Server is not started.");
        return this.responseStream;
    }

    @Override
    public boolean isOpen() {
        try {
            if (this.process != null) {
                this.process.exitValue();
            }
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public void start() throws Exception {
        String[] arguments = this.computeProcessArguments();
        if (this.debugStream != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("  ");
            int count = arguments.length;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(arguments[i]);
            }
            this.debugStream.println(System.currentTimeMillis() + " started analysis server:");
            this.debugStream.println(builder.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        this.process = processBuilder.start();
        this.requestSink = new ByteRequestSink(this.process.getOutputStream(), this.debugStream);
        this.responseStream = new ByteResponseStream(this.process.getInputStream(), this.debugStream, () -> this.requestSink.close());
        this.errorStream = new ByteLineReaderStream(this.process.getErrorStream());
    }

    @Override
    public void stop() {
        if (this.process == null) {
            return;
        }
        Process processToStop = this.process;
        this.process = null;
        long endTime = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < endTime) {
            try {
                int exit = processToStop.exitValue();
                if (exit != 0) {
                    Logging.getLogger().logInformation("Non-zero exit code: " + exit + " for\n   " + this.analysisServerPath);
                }
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        processToStop.destroy();
        Logging.getLogger().logInformation("Terminated " + this.analysisServerPath);
    }

    private String[] computeProcessArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.runtimePath);
        args.addAll(this.vmArguments);
        args.add(this.analysisServerPath);
        if (this.clientId != null) {
            args.add("--client-id=" + this.clientId);
        }
        if (this.clientVersion != null) {
            args.add("--client-version=" + this.clientVersion);
        }
        args.addAll(this.serverArguments);
        return args.toArray(new String[args.size()]);
    }
}

