/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.internal.remote.LineReaderStream;
import com.google.dart.server.internal.remote.processor.NotificationServerErrorProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.PrintStream;

public class ServerErrorReaderThread
extends Thread {
    private final LineReaderStream stream;
    private final NotificationServerErrorProcessor processor;
    private final PrintStream syserr;

    public ServerErrorReaderThread(LineReaderStream errorStream, AnalysisServerListener listener) {
        this(errorStream, new NotificationServerErrorProcessor(listener), System.err);
    }

    public ServerErrorReaderThread(LineReaderStream stream, NotificationServerErrorProcessor processor, PrintStream errorStream) {
        this.processor = processor;
        this.stream = stream;
        this.syserr = errorStream;
        this.setDaemon(true);
        this.setName("ServerErrorReaderThread");
    }

    public void processStream() throws Exception {
        String line;
        while ((line = this.stream.readLine()) != null) {
            this.syserr.println(line);
            if (!line.startsWith("Unhandled exception:")) continue;
            StringBuilder message = new StringBuilder(200);
            while ((line = this.readAvailableLine()) != null && !(line = line.trim()).startsWith("#")) {
                if (line.length() <= 0) continue;
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(line);
            }
            StringBuilder stack = new StringBuilder();
            if (line != null) {
                while (true) {
                    stack.append(line);
                    line = this.readAvailableLine();
                    if (line == null) break;
                    stack.append("\n");
                }
            }
            JsonObject response = new JsonObject();
            response.addProperty("event", "server.error");
            JsonObject paramsObject = new JsonObject();
            paramsObject.addProperty("isFatal", Boolean.valueOf(true));
            paramsObject.addProperty("message", message.toString());
            paramsObject.addProperty("stackTrace", stack.toString());
            response.add("params", (JsonElement)paramsObject);
            this.processor.process(response);
        }
        return;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.processStream();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private String readAvailableLine() throws Exception {
        if (!this.stream.ready()) {
            return null;
        }
        String line = this.stream.readLine();
        if (line != null) {
            this.syserr.println(line);
        }
        return line;
    }
}

