/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.AnalysisServerSocket;
import com.google.dart.server.AnalysisServerStatusListener;
import com.google.dart.server.BasicConsumer;
import com.google.dart.server.Consumer;
import com.google.dart.server.CreateContextConsumer;
import com.google.dart.server.FindElementReferencesConsumer;
import com.google.dart.server.FindMemberDeclarationsConsumer;
import com.google.dart.server.FindMemberReferencesConsumer;
import com.google.dart.server.FindTopLevelDeclarationsConsumer;
import com.google.dart.server.FormatConsumer;
import com.google.dart.server.GetAssistsConsumer;
import com.google.dart.server.GetAvailableRefactoringsConsumer;
import com.google.dart.server.GetDiagnosticsConsumer;
import com.google.dart.server.GetErrorsConsumer;
import com.google.dart.server.GetFixesConsumer;
import com.google.dart.server.GetHoverConsumer;
import com.google.dart.server.GetImportedElementsConsumer;
import com.google.dart.server.GetLibraryDependenciesConsumer;
import com.google.dart.server.GetNavigationConsumer;
import com.google.dart.server.GetPostfixCompletionConsumer;
import com.google.dart.server.GetReachableSourcesConsumer;
import com.google.dart.server.GetRefactoringConsumer;
import com.google.dart.server.GetServerPortConsumer;
import com.google.dart.server.GetStatementCompletionConsumer;
import com.google.dart.server.GetSuggestionsConsumer;
import com.google.dart.server.GetTypeHierarchyConsumer;
import com.google.dart.server.GetVersionConsumer;
import com.google.dart.server.ImportElementsConsumer;
import com.google.dart.server.IsPostfixCompletionApplicableConsumer;
import com.google.dart.server.JsonConsumer;
import com.google.dart.server.ListPostfixCompletionTemplatesConsumer;
import com.google.dart.server.MapUriConsumer;
import com.google.dart.server.OrganizeDirectivesConsumer;
import com.google.dart.server.ResponseListener;
import com.google.dart.server.SortMembersConsumer;
import com.google.dart.server.UpdateContentConsumer;
import com.google.dart.server.generated.AnalysisServer;
import com.google.dart.server.internal.BroadcastAnalysisServerListener;
import com.google.dart.server.internal.remote.BlockingRequestSink;
import com.google.dart.server.internal.remote.LineReaderStream;
import com.google.dart.server.internal.remote.RequestSink;
import com.google.dart.server.internal.remote.ResponseSink;
import com.google.dart.server.internal.remote.ResponseStream;
import com.google.dart.server.internal.remote.ServerErrorReaderThread;
import com.google.dart.server.internal.remote.processor.AnalysisErrorsProcessor;
import com.google.dart.server.internal.remote.processor.AssistsProcessor;
import com.google.dart.server.internal.remote.processor.CompletionIdProcessor;
import com.google.dart.server.internal.remote.processor.CreateContextProcessor;
import com.google.dart.server.internal.remote.processor.FindElementReferencesProcessor;
import com.google.dart.server.internal.remote.processor.FindMemberDeclarationsProcessor;
import com.google.dart.server.internal.remote.processor.FindMemberReferencesProcessor;
import com.google.dart.server.internal.remote.processor.FindTopLevelDeclarationsProcessor;
import com.google.dart.server.internal.remote.processor.FixesProcessor;
import com.google.dart.server.internal.remote.processor.FormatProcessor;
import com.google.dart.server.internal.remote.processor.GetImportedElementsProcessor;
import com.google.dart.server.internal.remote.processor.GetNavigationProcessor;
import com.google.dart.server.internal.remote.processor.GetRefactoringProcessor;
import com.google.dart.server.internal.remote.processor.GetServerPortProcessor;
import com.google.dart.server.internal.remote.processor.HoverProcessor;
import com.google.dart.server.internal.remote.processor.ImportElementsProcessor;
import com.google.dart.server.internal.remote.processor.IsPostfixCompletionApplicableProcessor;
import com.google.dart.server.internal.remote.processor.LibraryDependenciesProcessor;
import com.google.dart.server.internal.remote.processor.ListPostfixCompletionTemplatesProcessor;
import com.google.dart.server.internal.remote.processor.MapUriProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisAnalyzedFilesProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisClosingLabelsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisErrorsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisFlushResultsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisHighlightsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisImplementedProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisNavigationProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisOccurrencesProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisOutlineProcessor;
import com.google.dart.server.internal.remote.processor.NotificationAnalysisOverridesProcessor;
import com.google.dart.server.internal.remote.processor.NotificationCompletionResultsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationExecutionLaunchDataProcessor;
import com.google.dart.server.internal.remote.processor.NotificationSearchResultsProcessor;
import com.google.dart.server.internal.remote.processor.NotificationServerConnectedProcessor;
import com.google.dart.server.internal.remote.processor.NotificationServerErrorProcessor;
import com.google.dart.server.internal.remote.processor.NotificationServerStatusProcessor;
import com.google.dart.server.internal.remote.processor.OrganizeDirectivesProcessor;
import com.google.dart.server.internal.remote.processor.PostfixCompletionProcessor;
import com.google.dart.server.internal.remote.processor.RefactoringGetAvailableProcessor;
import com.google.dart.server.internal.remote.processor.SortMembersProcessor;
import com.google.dart.server.internal.remote.processor.StatementCompletionProcessor;
import com.google.dart.server.internal.remote.processor.TypeHierarchyProcessor;
import com.google.dart.server.internal.remote.processor.VersionProcessor;
import com.google.dart.server.internal.remote.utilities.RequestUtilities;
import com.google.dart.server.utilities.general.StringUtilities;
import com.google.dart.server.utilities.instrumentation.Instrumentation;
import com.google.dart.server.utilities.instrumentation.InstrumentationBuilder;
import com.google.dart.server.utilities.logging.Logging;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.dartlang.analysis.server.protocol.AnalysisOptions;
import org.dartlang.analysis.server.protocol.ImportedElements;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.dartlang.analysis.server.protocol.RequestError;
import org.osgi.framework.Version;

public class RemoteAnalysisServerImpl
implements AnalysisServer {
    public static final String SERVER_NOTIFICATION_ERROR = "server.error";
    private static final Version MIN_SERVER_VERSION = Version.parseVersion("1.9.0");
    private static final Version MAX_SERVER_VERSION = Version.parseVersion("2.0.0");
    private static final String SERVER_NOTIFICATION_CONNECTED = "server.connected";
    private static final String SERVER_NOTIFICATION_STATUS = "server.status";
    private static final String ANALYSIS_NOTIFICATION_ANALYZED_FILES = "analysis.analyzedFiles";
    private static final String ANALYSIS_NOTIFICATION_ERRORS = "analysis.errors";
    private static final String ANALYSIS_NOTIFICATION_FLUSH_RESULTS = "analysis.flushResults";
    private static final String ANALYSIS_NOTIFICATION_HIGHTLIGHTS = "analysis.highlights";
    private static final String ANALYSIS_NOTIFICATION_IMPLEMENTED = "analysis.implemented";
    private static final String ANALYSIS_NOTIFICATION_NAVIGATION = "analysis.navigation";
    private static final String ANALYSIS_NOTIFICATION_OCCURRENCES = "analysis.occurrences";
    private static final String ANALYSIS_NOTIFICATION_OUTLINE = "analysis.outline";
    private static final String ANALYSIS_NOTIFICATION_OVERRIDES = "analysis.overrides";
    private static final String ANALYSIS_NOTIFICATION_CLOSING_LABELS = "analysis.closingLabels";
    private static final String COMPLETION_NOTIFICATION_RESULTS = "completion.results";
    private static final String SEARCH_NOTIFICATION_RESULTS = "search.results";
    private static final String LAUNCH_DATA_NOTIFICATION_RESULTS = "execution.launchData";
    private final AnalysisServerSocket socket;
    private final Object requestSinkLock = new Object();
    private RequestSink requestSink;
    private ResponseStream responseStream;
    private LineReaderStream errorStream;
    private final AtomicLong lastResponseTime = new AtomicLong(0L);
    private final AtomicLong lastRequestTime = new AtomicLong(0L);
    private final BroadcastAnalysisServerListener listener = new BroadcastAnalysisServerListener();
    private final List<ResponseListener> responseListenerList = new ArrayList<ResponseListener>();
    private final List<AnalysisServerStatusListener> statusListenerList = new ArrayList<AnalysisServerStatusListener>();
    private final Map<String, Consumer> consumerMap = Maps.newHashMap();
    private final Object consumerMapLock = new Object();
    private final AtomicInteger nextId = new AtomicInteger();
    private final Map<String, String> requestToRefactoringKindMap = Maps.newHashMap();
    private Thread watcher;
    private boolean watch;
    private boolean shutdownRequested;
    private final boolean checkServerVersion;

    public RemoteAnalysisServerImpl(AnalysisServerSocket socket) {
        this(socket, true);
    }

    public RemoteAnalysisServerImpl(AnalysisServerSocket socket, boolean checkServerVersion) {
        this.socket = socket;
        this.checkServerVersion = checkServerVersion;
    }

    @Override
    public void addAnalysisServerListener(AnalysisServerListener listener) {
        this.listener.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResponseListener(ResponseListener listener) {
        List<ResponseListener> list = this.responseListenerList;
        synchronized (list) {
            if (!this.responseListenerList.contains(listener)) {
                this.responseListenerList.add(listener);
            }
        }
    }

    @Override
    public void addStatusListener(AnalysisServerStatusListener listener) {
        this.statusListenerList.add(listener);
    }

    @Override
    public void analysis_getErrors(String file, GetErrorsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisGetErrors(id, file), consumer);
    }

    @Override
    public void analysis_getHover(String file, int offset, GetHoverConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisGetHover(id, file, offset), consumer);
    }

    @Override
    public void analysis_getImportedElements(String file, int offset, int length, GetImportedElementsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisGetImportedElements(id, file, offset, length), consumer);
    }

    @Override
    public void analysis_getLibraryDependencies(GetLibraryDependenciesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisGetLibraryDependencies(id), consumer);
    }

    @Override
    public void analysis_getNavigation(String file, int offset, int length, GetNavigationConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisGetNavigation(id, file, offset, length), consumer);
    }

    @Override
    public void analysis_getReachableSources(String file, GetReachableSourcesConsumer consumer) {
    }

    @Override
    public void analysis_reanalyze(List<String> roots) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisReanalyze(id, roots));
    }

    @Override
    public void analysis_setAnalysisRoots(List<String> includedPaths, List<String> excludedPaths, Map<String, String> packageRoots) {
        String id = this.generateUniqueId();
        if (includedPaths == null) {
            includedPaths = StringUtilities.EMPTY_LIST;
        }
        if (excludedPaths == null) {
            excludedPaths = StringUtilities.EMPTY_LIST;
        }
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisSetAnalysisRoots(id, includedPaths, excludedPaths, packageRoots));
    }

    @Override
    public void analysis_setGeneralSubscriptions(List<String> subscriptions) {
        String id = this.generateUniqueId();
        if (subscriptions == null) {
            subscriptions = StringUtilities.EMPTY_LIST;
        }
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisSetGeneralSubscriptions(id, subscriptions));
    }

    @Override
    public void analysis_setPriorityFiles(List<String> files) {
        String id = this.generateUniqueId();
        if (files == null) {
            files = StringUtilities.EMPTY_LIST;
        }
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisSetPriorityFiles(id, files));
    }

    @Override
    public void analysis_setSubscriptions(Map<String, List<String>> subscriptions) {
        String id = this.generateUniqueId();
        if (subscriptions == null) {
            subscriptions = Maps.newHashMap();
        }
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisSetSubscriptions(id, subscriptions));
    }

    @Override
    public void analysis_updateContent(Map<String, Object> files, UpdateContentConsumer consumer) {
        String id = this.generateUniqueId();
        if (files == null) {
            files = Maps.newHashMap();
        }
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisUpdateContent(id, files), consumer);
    }

    @Override
    public void analysis_updateOptions(AnalysisOptions options) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateAnalysisUpdateOptions(id, options));
    }

    @Override
    public void completion_getSuggestions(String file, int offset, GetSuggestionsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateCompletionGetSuggestions(id, file, offset), consumer);
    }

    @Override
    public void diagnostic_getDiagnostics(GetDiagnosticsConsumer consumer) {
    }

    @Override
    public void diagnostic_getServerPort(GetServerPortConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateDiagnosticGetServerPort(id), consumer);
    }

    @Override
    public void edit_format(String file, int selectionOffset, int selectionLength, int lineLength, FormatConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditFormat(id, file, selectionOffset, selectionLength, lineLength), consumer);
    }

    @Override
    public void edit_getAssists(String file, int offset, int length, GetAssistsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditGetAssists(id, file, offset, length), consumer);
    }

    @Override
    public void edit_getAvailableRefactorings(String file, int offset, int length, GetAvailableRefactoringsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditGetAvaliableRefactorings(id, file, offset, length), consumer);
    }

    @Override
    public void edit_getFixes(String file, int offset, GetFixesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditGetFixes(id, file, offset), consumer);
    }

    @Override
    public void edit_isPostfixCompletionApplicable(String path, String key, int offset, IsPostfixCompletionApplicableConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateIsPostfixCompletionApplicable(id, path, offset, key), consumer);
    }

    @Override
    public void edit_listPostfixCompletionTemplates(ListPostfixCompletionTemplatesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateListPostfixCompletionTeamplates(id), consumer);
    }

    @Override
    public void edit_getPostfixCompletion(String file, String key, int offset, GetPostfixCompletionConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditPostfixCompletion(id, file, offset, key), consumer);
    }

    @Override
    public void edit_getRefactoring(String kindId, String file, int offset, int length, boolean validateOnly, RefactoringOptions options, GetRefactoringConsumer consumer) {
        String id = this.generateUniqueId();
        this.requestToRefactoringKindMap.put(id, kindId);
        this.sendRequestToServer(id, RequestUtilities.generateEditGetRefactoring(id, kindId, file, offset, length, validateOnly, options), consumer);
    }

    @Override
    public void edit_getStatementCompletion(String file, int offset, GetStatementCompletionConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditStatementCompletion(id, file, offset), consumer);
    }

    @Override
    public void edit_importElements(String file, List<ImportedElements> elements, ImportElementsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditImportElements(id, file, elements), consumer);
    }

    @Override
    public void edit_organizeDirectives(String file, OrganizeDirectivesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditOrganizeDirectives(id, file), consumer);
    }

    @Override
    public void edit_sortMembers(String file, SortMembersConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateEditSortMembers(id, file), consumer);
    }

    @Override
    public void execution_createContext(String contextRoot, CreateContextConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateExecutionCreateContext(id, contextRoot), consumer);
    }

    @Override
    public void execution_deleteContext(String contextId) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateExecutionDeleteContext(id, contextId));
    }

    @Override
    public void execution_mapUri(String contextId, String file, String uri, MapUriConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateExecutionMapUri(id, contextId, file, uri), consumer);
    }

    @Override
    public void execution_setSubscriptions(List<String> subscriptions) {
        String id = this.generateUniqueId();
        if (subscriptions == null) {
            subscriptions = StringUtilities.EMPTY_LIST;
        }
        this.sendRequestToServer(id, RequestUtilities.generateExecutionSetSubscriptions(id, subscriptions));
    }

    @Override
    public boolean isSocketOpen() {
        return this.socket.isOpen();
    }

    @Override
    public void removeAnalysisServerListener(AnalysisServerListener listener) {
        this.listener.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponseListener(ResponseListener listener) {
        List<ResponseListener> list = this.responseListenerList;
        synchronized (list) {
            this.responseListenerList.remove(listener);
        }
    }

    @Override
    public void search_findElementReferences(String file, int offset, boolean includePotential, FindElementReferencesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateSearchFindElementReferences(id, file, offset, includePotential), consumer);
    }

    @Override
    public void search_findMemberDeclarations(String name, FindMemberDeclarationsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateSearchFindMemberDeclarations(id, name), consumer);
    }

    @Override
    public void search_findMemberReferences(String name, FindMemberReferencesConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateSearchFindMemberReferences(id, name), consumer);
    }

    @Override
    public void search_findTopLevelDeclarations(String pattern, FindTopLevelDeclarationsConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateSearchFindTopLevelDeclarations(id, pattern), consumer);
    }

    @Override
    public void search_getTypeHierarchy(String file, int offset, boolean superOnly, GetTypeHierarchyConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateSearchGetTypeHierarchy(id, file, offset, superOnly), consumer);
    }

    @Override
    public void server_getVersion(GetVersionConsumer consumer) {
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateServerGetVersion(id), consumer);
    }

    @Override
    public void server_setSubscriptions(List<String> subscriptions) {
        String id = this.generateUniqueId();
        if (subscriptions == null) {
            subscriptions = StringUtilities.EMPTY_LIST;
        }
        this.sendRequestToServer(id, RequestUtilities.generateServerSetSubscriptions(id, subscriptions));
    }

    @Override
    public void server_shutdown() {
        this.shutdownRequested = true;
        this.stopWatcher();
        String id = this.generateUniqueId();
        this.sendRequestToServer(id, RequestUtilities.generateServerShutdown(id), new BasicConsumer(){

            @Override
            public void received() {
                RemoteAnalysisServerImpl.this.requestSink.close();
                for (AnalysisServerStatusListener listener : RemoteAnalysisServerImpl.this.statusListenerList) {
                    listener.isAliveServer(false);
                }
            }
        });
        this.stopServer();
    }

    @Override
    public void start() throws Exception {
        this.startServer();
        this.startWatcher(5000L);
    }

    @VisibleForTesting
    public void test_waitForWorkerComplete() {
        while (!this.consumerMap.isEmpty()) {
            Thread.yield();
        }
    }

    @Override
    public String generateUniqueId() {
        return Integer.toString(this.nextId.getAndIncrement());
    }

    private boolean processNotification(JsonObject response) throws Exception {
        JsonElement eventElement = response.get("event");
        if (eventElement == null || !eventElement.isJsonPrimitive()) {
            return false;
        }
        String event = eventElement.getAsString();
        if (event.equals(ANALYSIS_NOTIFICATION_ERRORS)) {
            new NotificationAnalysisErrorsProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_FLUSH_RESULTS)) {
            new NotificationAnalysisFlushResultsProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_HIGHTLIGHTS)) {
            new NotificationAnalysisHighlightsProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_IMPLEMENTED)) {
            new NotificationAnalysisImplementedProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_NAVIGATION)) {
            new NotificationAnalysisNavigationProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_OCCURRENCES)) {
            new NotificationAnalysisOccurrencesProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_OUTLINE)) {
            new NotificationAnalysisOutlineProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_OVERRIDES)) {
            new NotificationAnalysisOverridesProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_CLOSING_LABELS)) {
            new NotificationAnalysisClosingLabelsProcessor(this.listener).process(response);
        } else if (event.equals(ANALYSIS_NOTIFICATION_ANALYZED_FILES)) {
            new NotificationAnalysisAnalyzedFilesProcessor(this.listener).process(response);
        } else if (event.equals(COMPLETION_NOTIFICATION_RESULTS)) {
            new NotificationCompletionResultsProcessor(this.listener).process(response);
        } else if (event.equals(SEARCH_NOTIFICATION_RESULTS)) {
            new NotificationSearchResultsProcessor(this.listener).process(response);
        } else if (event.equals(SERVER_NOTIFICATION_STATUS)) {
            new NotificationServerStatusProcessor(this.listener).process(response);
        } else if (event.equals(SERVER_NOTIFICATION_ERROR)) {
            new NotificationServerErrorProcessor(this.listener).process(response);
        } else if (event.equals(SERVER_NOTIFICATION_CONNECTED)) {
            new NotificationServerConnectedProcessor(this.listener).process(response);
        } else if (event.equals(LAUNCH_DATA_NOTIFICATION_RESULTS)) {
            new NotificationExecutionLaunchDataProcessor(this.listener).process(response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(JsonObject response) throws Exception {
        Consumer consumer;
        this.notifyResponseListeners(response);
        if (this.processNotification(response)) {
            return;
        }
        JsonPrimitive idJsonPrimitive = (JsonPrimitive)response.get("id");
        if (idJsonPrimitive == null) {
            return;
        }
        String idString = idJsonPrimitive.getAsString();
        Object object = this.consumerMapLock;
        synchronized (object) {
            consumer = this.consumerMap.get(idString);
        }
        JsonObject errorObject = (JsonObject)response.get("error");
        RequestError requestError = null;
        if (errorObject != null) {
            requestError = RemoteAnalysisServerImpl.processErrorResponse(errorObject);
            this.listener.requestError(requestError);
        }
        JsonObject resultObject = (JsonObject)response.get("result");
        if (consumer instanceof UpdateContentConsumer) {
            ((UpdateContentConsumer)consumer).onResponse();
        } else if (consumer instanceof GetSuggestionsConsumer) {
            new CompletionIdProcessor((GetSuggestionsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof FindElementReferencesConsumer) {
            new FindElementReferencesProcessor((FindElementReferencesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof FindMemberDeclarationsConsumer) {
            new FindMemberDeclarationsProcessor((FindMemberDeclarationsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof FindMemberReferencesConsumer) {
            new FindMemberReferencesProcessor((FindMemberReferencesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof FindTopLevelDeclarationsConsumer) {
            new FindTopLevelDeclarationsProcessor((FindTopLevelDeclarationsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetTypeHierarchyConsumer) {
            new TypeHierarchyProcessor((GetTypeHierarchyConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof FormatConsumer) {
            new FormatProcessor((FormatConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetHoverConsumer) {
            new HoverProcessor((GetHoverConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetRefactoringConsumer) {
            new GetRefactoringProcessor(this.requestToRefactoringKindMap, (GetRefactoringConsumer)consumer).process(idString, resultObject, requestError);
        } else if (consumer instanceof GetAssistsConsumer) {
            new AssistsProcessor((GetAssistsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetFixesConsumer) {
            new FixesProcessor((GetFixesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetStatementCompletionConsumer) {
            new StatementCompletionProcessor((GetStatementCompletionConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetPostfixCompletionConsumer) {
            new PostfixCompletionProcessor((GetPostfixCompletionConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof IsPostfixCompletionApplicableConsumer) {
            new IsPostfixCompletionApplicableProcessor((IsPostfixCompletionApplicableConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof ListPostfixCompletionTemplatesConsumer) {
            new ListPostfixCompletionTemplatesProcessor((ListPostfixCompletionTemplatesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetImportedElementsConsumer) {
            new GetImportedElementsProcessor((GetImportedElementsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetLibraryDependenciesConsumer) {
            new LibraryDependenciesProcessor((GetLibraryDependenciesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetNavigationConsumer) {
            new GetNavigationProcessor((GetNavigationConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetAvailableRefactoringsConsumer) {
            new RefactoringGetAvailableProcessor((GetAvailableRefactoringsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetErrorsConsumer) {
            new AnalysisErrorsProcessor((GetErrorsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof ImportElementsConsumer) {
            new ImportElementsProcessor((ImportElementsConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof OrganizeDirectivesConsumer) {
            new OrganizeDirectivesProcessor((OrganizeDirectivesConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof SortMembersConsumer) {
            new SortMembersProcessor((SortMembersConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof CreateContextConsumer) {
            new CreateContextProcessor((CreateContextConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof MapUriConsumer) {
            new MapUriProcessor((MapUriConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetServerPortConsumer) {
            new GetServerPortProcessor((GetServerPortConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof GetVersionConsumer) {
            new VersionProcessor((GetVersionConsumer)consumer).process(resultObject, requestError);
        } else if (consumer instanceof BasicConsumer) {
            ((BasicConsumer)consumer).received();
        } else if (consumer instanceof JsonConsumer) {
            ((JsonConsumer)consumer).onResponse(resultObject, requestError);
        }
        Object object2 = this.consumerMapLock;
        synchronized (object2) {
            this.consumerMap.remove(idString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResponseListeners(JsonObject response) {
        List<ResponseListener> list = this.responseListenerList;
        synchronized (list) {
            ImmutableList listeners = ImmutableList.copyOf(this.responseListenerList);
            for (ResponseListener listener : listeners) {
                listener.onResponse(response);
            }
        }
    }

    @Override
    public void sendRequestToServer(String id, JsonObject request) {
        this.sendRequestToServer(id, request, new LocalConsumer(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequestToServer(String id, JsonObject request, Consumer consumer) {
        Object object = this.consumerMapLock;
        synchronized (object) {
            this.consumerMap.put(id, consumer);
        }
        this.lastRequestTime.set(System.currentTimeMillis());
        object = this.requestSinkLock;
        synchronized (object) {
            this.requestSink.add(request);
        }
    }

    private void startServer() throws Exception {
        this.socket.start();
        this.consumerMap.clear();
        this.requestSink = this.socket.getRequestSink();
        this.responseStream = this.socket.getResponseStream();
        this.errorStream = this.socket.getErrorStream();
        new ServerResponseReaderThread(this.responseStream).start();
        if (this.errorStream != null) {
            new ServerErrorReaderThread(this.errorStream, this.listener).start();
        }
        if (this.checkServerVersion) {
            final BlockingRequestSink blockRequestSink = new BlockingRequestSink(this.requestSink);
            this.requestSink = blockRequestSink;
            this.server_getVersion(new GetVersionConsumer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void computedVersion(String versionStr) {
                    String message = null;
                    Version version = null;
                    try {
                        version = Version.parseVersion(versionStr);
                    }
                    catch (Throwable e) {
                        message = "Unable to parse version: " + versionStr;
                    }
                    if (version != null && (version.compareTo(MIN_SERVER_VERSION) < 0 || version.compareTo(MAX_SERVER_VERSION) >= 0)) {
                        message = "This version of the com.google.dart.server project can communicate only with server versions between " + MIN_SERVER_VERSION + " and " + MAX_SERVER_VERSION + ", but the version read from the server is " + version + ".";
                    }
                    if (message == null) {
                        Object object = RemoteAnalysisServerImpl.this.requestSinkLock;
                        synchronized (object) {
                            RemoteAnalysisServerImpl.this.requestSink = blockRequestSink.toPassthroughSink();
                            return;
                        }
                    }
                    Logging.getLogger().logError(message);
                    RemoteAnalysisServerImpl.this.listener.serverIncompatibleVersion(versionStr);
                    this.sendErrorForEveryRequest(versionStr);
                }

                @Override
                public void onError(RequestError requestError) {
                    Logging.getLogger().logError("No version received from the server.");
                    RemoteAnalysisServerImpl.this.listener.serverIncompatibleVersion(null);
                    this.sendErrorForEveryRequest(null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void sendErrorForEveryRequest(String version) {
                    String message = "Incompatible server version: " + version;
                    Object object = RemoteAnalysisServerImpl.this.requestSinkLock;
                    synchronized (object) {
                        RemoteAnalysisServerImpl.this.requestSink = blockRequestSink.toErrorSink(new ResponseSink(){

                            @Override
                            public void add(JsonObject response) throws Exception {
                                RemoteAnalysisServerImpl.this.processResponse(response);
                            }
                        }, "INCOMPATIBLE_SERVER_VERSION", message);
                    }
                    RemoteAnalysisServerImpl.this.server_shutdown();
                }
            });
        }
    }

    private void startWatcher(final long millisToRestart) {
        if (millisToRestart <= 0L || this.watcher != null) {
            return;
        }
        this.watch = true;
        this.watcher = new Thread(this.getClass().getSimpleName() + " watcher"){

            @Override
            public void run() {
                RemoteAnalysisServerImpl.this.watch(millisToRestart);
            }
        };
        this.watcher.setDaemon(true);
        this.watcher.start();
    }

    private void stopServer() {
        this.socket.stop();
    }

    private void stopWatcher() {
        if (this.watcher == null) {
            return;
        }
        this.watch = false;
        this.watcher.interrupt();
        try {
            this.watcher.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.watcher = null;
    }

    private void watch(long millisToRestart) {
        while (this.watch) {
            if (this.isSocketOpen()) {
                RemoteAnalysisServerImpl.sleep(millisToRestart / 2L);
                continue;
            }
            InstrumentationBuilder instrumentation = Instrumentation.builder("RemoteAnalysisServerImpl.serverNotRunning");
            for (AnalysisServerStatusListener listener : this.statusListenerList) {
                listener.isAliveServer(false);
            }
            instrumentation.log();
            this.watch = false;
        }
    }

    @Override
    public long getLastRequestMillis() {
        return this.lastRequestTime.get();
    }

    @Override
    public long getLastResponseMillis() {
        long millis = this.lastResponseTime.get();
        if (millis == 0L) {
            this.lastResponseTime.set(System.currentTimeMillis());
        }
        return millis;
    }

    private static RequestError processErrorResponse(JsonObject errorObject) throws Exception {
        String errorCode = errorObject.get("code").getAsString();
        String errorMessage = errorObject.get("message").getAsString();
        String errorStackTrace = errorObject.get("stackTrace") != null ? errorObject.get("stackTrace").getAsString() : null;
        return new RequestError(errorCode, errorMessage, errorStackTrace);
    }

    private static void sleep(long millisToSleep) {
        try {
            Thread.sleep(millisToSleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ AtomicLong access$800(RemoteAnalysisServerImpl x0) {
        return x0.lastResponseTime;
    }

    static /* synthetic */ boolean access$900(RemoteAnalysisServerImpl x0) {
        return x0.shutdownRequested;
    }

    public class ServerResponseReaderThread
    extends Thread {
        private ResponseStream stream;

        public ServerResponseReaderThread(ResponseStream stream) {
            this.setDaemon(true);
            this.setName("ServerResponseReaderThread");
            this.stream = stream;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        if ((response = this.stream.take()) == null) {
                            return;
                        }
                        RemoteAnalysisServerImpl.access$800(RemoteAnalysisServerImpl.this).set(System.currentTimeMillis());
                        try {
                            RemoteAnalysisServerImpl.access$600(RemoteAnalysisServerImpl.this, response);
                        }
                        finally {
                            this.stream.lastRequestProcessed();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    if (RemoteAnalysisServerImpl.access$900(RemoteAnalysisServerImpl.this)) {
                        return;
                    }
                    if (e instanceof IOException && (message = e.getMessage()) != null && message.contains("closed")) {
                        Logging.getLogger().logError("AnalysisServer stream unexpected closed", e);
                        return;
                    }
                    Logging.getLogger().logError(e.getMessage(), e);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }

    public static class LocalConsumer
    implements Consumer {
        private final JsonObject request;

        public LocalConsumer(JsonObject request) {
            this.request = request;
        }

        private JsonObject getRequest() {
            return this.request;
        }
    }
}

