/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.dart.server.internal.remote.RequestSink;
import com.google.dart.server.internal.remote.ResponseSink;
import com.google.dart.server.internal.remote.utilities.RequestUtilities;
import com.google.dart.server.internal.remote.utilities.ResponseUtilities;
import com.google.dart.server.utilities.logging.Logging;
import com.google.gson.JsonObject;

public class ErrorRequestSink
implements RequestSink {
    private final ResponseSink responseSink;
    private final String code;
    private final String message;

    public ErrorRequestSink(ResponseSink responseSink, String code, String message) {
        if (responseSink == null || code == null || message == null) {
            throw new IllegalArgumentException("Unexpected null argument: " + responseSink + " " + code + " " + message);
        }
        this.responseSink = responseSink;
        this.code = code;
        this.message = message;
    }

    @Override
    public void add(JsonObject request) {
        String id = RequestUtilities.getId(request);
        try {
            JsonObject response = ResponseUtilities.createErrorResponse(id, this.code, this.message);
            this.responseSink.add(response);
        }
        catch (Throwable e) {
            Logging.getLogger().logError(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
    }
}

