/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.dart.server.internal.remote.DebugPrintStream;
import com.google.dart.server.internal.remote.ResponseStream;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ByteResponseStream
implements ResponseStream {
    public static final String EOF_LINE = "EOF line";
    private final BufferedReader reader;
    private final DebugPrintStream debugStream;
    private final Runnable onStreamEndRunnable;
    private final BlockingQueue<String> lineQueue = new LinkedBlockingQueue<String>();

    public ByteResponseStream(InputStream stream, DebugPrintStream debugStream, Runnable onStreamEndRunnable) {
        this.reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        this.debugStream = debugStream;
        this.onStreamEndRunnable = onStreamEndRunnable;
        new LinesReaderThread().start();
    }

    @Override
    public void lastRequestProcessed() {
    }

    @Override
    public JsonObject take() throws Exception {
        String line = this.lineQueue.take();
        if (line == EOF_LINE) {
            this.lineQueue.add(line);
            return null;
        }
        try {
            return (JsonObject)new JsonParser().parse(line);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Parse server message failed: " + line, (Throwable)e);
        }
    }

    private class LinesReaderThread
    extends Thread {
        public LinesReaderThread() {
            this.setName("ByteResponseStream.LinesReaderThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                String line;
                try {
                    line = ByteResponseStream.this.reader.readLine();
                }
                catch (IOException e) {
                    line = null;
                }
                if (line == null) {
                    ByteResponseStream.this.lineQueue.add(ByteResponseStream.EOF_LINE);
                    if (ByteResponseStream.this.onStreamEndRunnable != null) {
                        ByteResponseStream.this.onStreamEndRunnable.run();
                    }
                    return;
                }
                if (ByteResponseStream.this.debugStream != null) {
                    ByteResponseStream.this.debugStream.println(System.currentTimeMillis() + " <= " + line);
                }
                if (!line.startsWith("{")) continue;
                ByteResponseStream.this.lineQueue.add(line);
            }
        }
    }
}

