/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal;

import com.google.common.collect.Lists;
import com.google.dart.server.AnalysisServerListener;
import java.util.List;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.AnalysisStatus;
import org.dartlang.analysis.server.protocol.ClosingLabel;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.HighlightRegion;
import org.dartlang.analysis.server.protocol.ImplementedClass;
import org.dartlang.analysis.server.protocol.ImplementedMember;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.Occurrences;
import org.dartlang.analysis.server.protocol.Outline;
import org.dartlang.analysis.server.protocol.OverrideMember;
import org.dartlang.analysis.server.protocol.PubStatus;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SearchResult;

public class BroadcastAnalysisServerListener
implements AnalysisServerListener {
    private final List<AnalysisServerListener> listeners = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AnalysisServerListener listener) {
        List<AnalysisServerListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void computedAnalyzedFiles(List<String> directories) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedAnalyzedFiles(directories);
        }
    }

    @Override
    public void computedCompletion(String completionId, int replacementOffset, int replacementLength, List<CompletionSuggestion> completions, boolean isLast) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedCompletion(completionId, replacementOffset, replacementLength, completions, isLast);
        }
    }

    @Override
    public void computedErrors(String file, List<AnalysisError> errors) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedErrors(file, errors);
        }
    }

    @Override
    public void computedHighlights(String file, List<HighlightRegion> highlights) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedHighlights(file, highlights);
        }
    }

    @Override
    public void computedImplemented(String file, List<ImplementedClass> implementedClasses, List<ImplementedMember> implementedMembers) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedImplemented(file, implementedClasses, implementedMembers);
        }
    }

    @Override
    public void computedLaunchData(String file, String kind, String[] referencedFiles) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedLaunchData(file, kind, referencedFiles);
        }
    }

    @Override
    public void computedNavigation(String file, List<NavigationRegion> targets) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedNavigation(file, targets);
        }
    }

    @Override
    public void computedOccurrences(String file, List<Occurrences> occurrencesArray) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedOccurrences(file, occurrencesArray);
        }
    }

    @Override
    public void computedOutline(String file, Outline outline) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedOutline(file, outline);
        }
    }

    @Override
    public void computedOverrides(String file, List<OverrideMember> overrides) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedOverrides(file, overrides);
        }
    }

    @Override
    public void computedClosingLabels(String file, List<ClosingLabel> labels) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedClosingLabels(file, labels);
        }
    }

    @Override
    public void computedSearchResults(String searchId, List<SearchResult> results, boolean last) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.computedSearchResults(searchId, results, last);
        }
    }

    @Override
    public void flushedResults(List<String> files) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.flushedResults(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AnalysisServerListener listener) {
        List<AnalysisServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void requestError(RequestError requestError) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.requestError(requestError);
        }
    }

    @Override
    public void serverConnected(String version) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.serverConnected(version);
        }
    }

    @Override
    public void serverError(boolean isFatal, String message, String stackTrace) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.serverError(isFatal, message, stackTrace);
        }
    }

    @Override
    public void serverIncompatibleVersion(String version) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.serverIncompatibleVersion(version);
        }
    }

    @Override
    public void serverStatus(AnalysisStatus analysisStatus, PubStatus pubStatus) {
        for (AnalysisServerListener listener : this.getListeners()) {
            listener.serverStatus(analysisStatus, pubStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnalysisServerListener> getListeners() {
        List<AnalysisServerListener> list = this.listeners;
        synchronized (list) {
            return Lists.newArrayList(this.listeners);
        }
    }
}

