import 'package:flutter/material.dart';
import 'package:english_words/english_words.dart';

void main() => runApp(new MyApp());

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    final wordPair = new WordPair.random();

    return new MaterialApp(
      title: 'Welcome to Flutter',
      home: new RandomWords(),
//      home: new Scaffold(
//        appBar: new AppBar(
//          title: new Text('Welcome to Flutter'),
//        ),
//        body: new Center(
////          child: new Text("hello word!"),
////          child: new Text(wordPair.asPascalCase),
//          child: new RandomWords(),
//        ),
//      ),
    );
  }
}

//添加有状态的 RandomWords widget 到 main.dart
class RandomWords extends StatefulWidget{
  @override
  createState() => new RandomWordsState();
}
//添加 RandomWordsState 类.该应用程序的大部分代码都在该类中
class RandomWordsState extends State<RandomWords>{
  final _suggestions = <WordPair>{};
  final _biggerFont = const TextStyle(fontSize:  18.0);

  Widget _buildRow(WordPair pair){
    return new ListTile(
      title: new Text(
        pair.asPascalCase,
        style: _biggerFont,
      ),
    );
  }

  //添加一个基本的build方法
  @override
  Widget build(BuildContext context) {
    final wordPair = new WordPair.random();
    return new Text(wordPair.asPascalCase);
  }
  Widget _buildSuggestions(){
    return new ListView.builder(
      padding: const EdgeInsets.all(16.0),
      itemBuilder: (context, i){
        if(i.isOdd){
          return new Divider();

          final index = i ~/ 2;

          if(index >= _suggestions.length){
            //接着再生成10个单词对，然后添加到建议列表
            _suggestions.addAll(generateWordPairs().take(10));
          }
          return _buildRow(_suggestions[index]);
        }
      },
    );
  }
}

