#import "FlutterPlugin.h"
#import "FlutterPluginEvent.h"

@implementation FlutterPlugin

//事件处理
 FlutterPluginEvent *pluginEvent;

+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
  FlutterMethodChannel* channel = [FlutterMethodChannel
      methodChannelWithName:@"flutter_plugin"
            binaryMessenger:[registrar messenger]];
  FlutterPlugin* instance = [[FlutterPlugin alloc] init];
  [registrar addMethodCallDelegate:instance channel:channel];
    
    
    //事件处理
    pluginEvent = [[FlutterPluginEvent alloc] init];
    pluginEvent.eventChannel = [FlutterEventChannel
                                eventChannelWithName:@"flutter_plugin_event"
                                binaryMessenger:[registrar messenger]];
    [pluginEvent.eventChannel setStreamHandler:pluginEvent];
    
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
  if ([@"getPlatformVersion" isEqualToString:call.method]) {
    result([@"iOS " stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
  }
  else if([@"getNative" isEqualToString:call.method])
  {
      result(@"Get iOS Success..." );
     
  }
  else if([@"sayHello" isEqualToString:call.method])
  {
      NSDictionary* argsMap = call.arguments;
      NSString * message = argsMap[@"message"];
      NSString * info = argsMap[@"info"];
      NSLog(message);
      NSLog(info);
      //result(nil);
      //result(message);
      //result(@{@"message": message,@"info":@"info_value"});
      
      //事件处理
      FlutterEventSink eventSink = pluginEvent.eventSink;
      if(eventSink){
          eventSink(@{
                      @"event" : @"demoEvent",
                      @"value" : @"iOS value is 10",
                      });
      }
    
  }
  else {
    result(FlutterMethodNotImplemented);
  }
}

@end
