package com.flutterplugin;

import android.drm.DrmStore;

import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;
import io.flutter.plugin.common.PluginRegistry.Registrar;

/** FlutterPlugin */
public class FlutterPlugin implements MethodCallHandler {


  //事件派发对象
  private EventChannel.EventSink eventSink = null;

  //事件派发流
  private EventChannel.StreamHandler streamHandler = new EventChannel.StreamHandler() {
    @Override
    public void onListen(Object o, EventChannel.EventSink sink) {
      eventSink = sink;
    }

    @Override
    public void onCancel(Object o) {
      eventSink = null;
    }
  };

  private FlutterPlugin(Registrar registrar,MethodChannel channel){

    //初始化事件
    EventChannel eventChannel = new EventChannel(registrar.messenger(),"flutter_plugin_event");
    eventChannel.setStreamHandler(streamHandler);

  }

  /** Plugin registration. */
  public static void registerWith(Registrar registrar) {
    final MethodChannel channel = new MethodChannel(registrar.messenger(), "flutter_plugin");
    channel.setMethodCallHandler(new FlutterPlugin(registrar,channel));

  }

  @Override
  public void onMethodCall(MethodCall call, Result result) {
    if (call.method.equals("getPlatformVersion")) {
      result.success("Android " + android.os.Build.VERSION.RELEASE);
    }
    else if(call.method.equals("getNative")){
      result.success("Get Android Success... ");
    }
    else if(call.method.equals("sayHello")){
      String message = call.argument("message");
      String info = call.argument("info");
      System.out.println("Android层:message::" + message);
      System.out.println("Android层:info::" + info);

//      ConstraintsMap params = new ConstraintsMap();
//      params.putString("message",message);
//      params.putString("info","infoValue");
//      result.success(params.toMap());

      //result.success(null);
      //result.error();

      //result.success(message);


      //派发事件
      if(eventSink != null){
        ConstraintsMap params = new ConstraintsMap();
        params.putString("event","demoEvent");
        params.putString("value","value is 10");
        eventSink.success(params.toMap());
      }


    }
    else {
      result.notImplemented();
    }
  }
}
