/*
 * Decompiled with CFR 0.152.
 */
package com.flutterplugin;

import com.flutterplugin.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConstraintsMap {
    private final Map<String, Object> mMap;

    public ConstraintsMap() {
        this.mMap = new HashMap<String, Object>();
    }

    public ConstraintsMap(Map<String, Object> map) {
        this.mMap = map;
    }

    public Map<String, Object> toMap() {
        return this.mMap;
    }

    public boolean hasKey(String name) {
        return this.mMap.containsKey(name);
    }

    public boolean isNull(String name) {
        return this.mMap.get(name) == null;
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.mMap.get(name);
    }

    public double getDouble(String name) {
        return (Double)this.mMap.get(name);
    }

    public int getInt(String name) {
        if (this.getType(name) == ObjectType.String) {
            return Integer.parseInt((String)this.mMap.get(name));
        }
        return (Integer)this.mMap.get(name);
    }

    public String getString(String name) {
        return (String)this.mMap.get(name);
    }

    public ConstraintsMap getMap(String name) {
        return new ConstraintsMap((Map)this.mMap.get(name));
    }

    public ObjectType getType(String name) {
        Object value = this.mMap.get(name);
        if (value == null) {
            return ObjectType.Null;
        }
        if (value instanceof Number) {
            return ObjectType.Number;
        }
        if (value instanceof String) {
            return ObjectType.String;
        }
        if (value instanceof Boolean) {
            return ObjectType.Boolean;
        }
        if (value instanceof Map) {
            return ObjectType.Map;
        }
        if (value instanceof ArrayList) {
            return ObjectType.Array;
        }
        throw new IllegalArgumentException("Invalid value " + value.toString() + " for key " + name + "contained in ConstraintsMap");
    }

    public void putBoolean(String key, boolean value) {
        this.mMap.put(key, value);
    }

    public void putDouble(String key, double value) {
        this.mMap.put(key, value);
    }

    public void putInt(String key, int value) {
        this.mMap.put(key, value);
    }

    public void putString(String key, String value) {
        this.mMap.put(key, value);
    }

    public void putNull(String key) {
        this.mMap.put(key, null);
    }

    public void putMap(String key, Map<String, Object> value) {
        this.mMap.put(key, value);
    }

    public void merge(Map<String, Object> value) {
        this.mMap.putAll(value);
    }

    public void putArray(String key, ArrayList<Object> value) {
        this.mMap.put(key, value);
    }
}

