/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Response;

public class VM
extends Response {
    public VM(JsonObject json) {
        super(json);
    }

    public int getArchitectureBits() {
        return this.json.get("architectureBits") == null ? -1 : this.json.get("architectureBits").getAsInt();
    }

    public String getHostCPU() {
        return this.json.get("hostCPU").getAsString();
    }

    public ElementList<IsolateRef> getIsolates() {
        return new ElementList<IsolateRef>(this.json.get("isolates").getAsJsonArray()){

            @Override
            protected IsolateRef basicGet(JsonArray array, int index) {
                return new IsolateRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getName() {
        return this.json.get("name").getAsString();
    }

    public int getPid() {
        return this.json.get("pid") == null ? -1 : this.json.get("pid").getAsInt();
    }

    public int getStartTime() {
        return this.json.get("startTime") == null ? -1 : this.json.get("startTime").getAsInt();
    }

    public String getTargetCPU() {
        return this.json.get("targetCPU").getAsString();
    }

    public String getVersion() {
        return this.json.get("version").getAsString();
    }
}

