/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.ObjRef;

public class InstanceRef
extends ObjRef {
    public InstanceRef(JsonObject json) {
        super(json);
    }

    public ClassRef getClassRef() {
        return new ClassRef((JsonObject)this.json.get("class"));
    }

    public InstanceKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? InstanceKind.Unknown : InstanceKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return InstanceKind.Unknown;
        }
    }

    public int getLength() {
        return this.json.get("length") == null ? -1 : this.json.get("length").getAsInt();
    }

    public String getName() {
        return this.json.get("name") == null ? null : this.json.get("name").getAsString();
    }

    public ClassRef getParameterizedClass() {
        return this.json.get("parameterizedClass") == null ? null : new ClassRef((JsonObject)this.json.get("parameterizedClass"));
    }

    public InstanceRef getPattern() {
        return this.json.get("pattern") == null ? null : new InstanceRef((JsonObject)this.json.get("pattern"));
    }

    public ClassRef getTypeClass() {
        return this.json.get("typeClass") == null ? null : new ClassRef((JsonObject)this.json.get("typeClass"));
    }

    public String getValueAsString() {
        return this.json.get("valueAsString") == null ? null : this.json.get("valueAsString").getAsString();
    }

    public boolean getValueAsStringIsTruncated() {
        JsonElement elem = this.json.get("valueAsStringIsTruncated");
        return elem != null ? elem.getAsBoolean() : false;
    }
}

