/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.BoundVariable;
import org.dartlang.vm.service.element.CodeRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.Response;
import org.dartlang.vm.service.element.SourceLocation;

public class Frame
extends Response {
    public Frame(JsonObject json) {
        super(json);
    }

    public CodeRef getCode() {
        return this.json.get("code") == null ? null : new CodeRef((JsonObject)this.json.get("code"));
    }

    public FuncRef getFunction() {
        return this.json.get("function") == null ? null : new FuncRef((JsonObject)this.json.get("function"));
    }

    public int getIndex() {
        return this.json.get("index") == null ? -1 : this.json.get("index").getAsInt();
    }

    public FrameKind getKind() {
        if (this.json.get("kind") == null) {
            return null;
        }
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? FrameKind.Unknown : FrameKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return FrameKind.Unknown;
        }
    }

    public SourceLocation getLocation() {
        return this.json.get("location") == null ? null : new SourceLocation((JsonObject)this.json.get("location"));
    }

    public ElementList<BoundVariable> getVars() {
        if (this.json.get("vars") == null) {
            return null;
        }
        return new ElementList<BoundVariable>(this.json.get("vars").getAsJsonArray()){

            @Override
            protected BoundVariable basicGet(JsonArray array, int index) {
                return new BoundVariable(array.get(index).getAsJsonObject());
            }
        };
    }
}

