/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExtensionData;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Response;
import org.dartlang.vm.service.element.TimelineEvent;
import org.dartlang.vm.service.element.VMRef;

public class Event
extends Response {
    public Event(JsonObject json) {
        super(json);
    }

    public String getAlias() {
        return this.json.get("alias") == null ? null : this.json.get("alias").getAsString();
    }

    public boolean getAtAsyncSuspension() {
        return this.json.get("atAsyncSuspension") == null ? false : this.json.get("atAsyncSuspension").getAsBoolean();
    }

    public Breakpoint getBreakpoint() {
        return this.json.get("breakpoint") == null ? null : new Breakpoint((JsonObject)this.json.get("breakpoint"));
    }

    public String getBytes() {
        return this.json.get("bytes") == null ? null : this.json.get("bytes").getAsString();
    }

    public InstanceRef getException() {
        return this.json.get("exception") == null ? null : new InstanceRef((JsonObject)this.json.get("exception"));
    }

    public ExtensionData getExtensionData() {
        return this.json.get("extensionData") == null ? null : new ExtensionData((JsonObject)this.json.get("extensionData"));
    }

    public String getExtensionKind() {
        return this.json.get("extensionKind") == null ? null : this.json.get("extensionKind").getAsString();
    }

    public String getExtensionRPC() {
        return this.json.get("extensionRPC") == null ? null : this.json.get("extensionRPC").getAsString();
    }

    public InstanceRef getInspectee() {
        return this.json.get("inspectee") == null ? null : new InstanceRef((JsonObject)this.json.get("inspectee"));
    }

    public IsolateRef getIsolate() {
        return this.json.get("isolate") == null ? null : new IsolateRef((JsonObject)this.json.get("isolate"));
    }

    public EventKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? EventKind.Unknown : EventKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return EventKind.Unknown;
        }
    }

    public String getMethod() {
        return this.json.get("method") == null ? null : this.json.get("method").getAsString();
    }

    public ElementList<Breakpoint> getPauseBreakpoints() {
        if (this.json.get("pauseBreakpoints") == null) {
            return null;
        }
        return new ElementList<Breakpoint>(this.json.get("pauseBreakpoints").getAsJsonArray()){

            @Override
            protected Breakpoint basicGet(JsonArray array, int index) {
                return new Breakpoint(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getService() {
        return this.json.get("service") == null ? null : this.json.get("service").getAsString();
    }

    public String getStatus() {
        return this.json.get("status") == null ? null : this.json.get("status").getAsString();
    }

    public ElementList<TimelineEvent> getTimelineEvents() {
        if (this.json.get("timelineEvents") == null) {
            return null;
        }
        return new ElementList<TimelineEvent>(this.json.get("timelineEvents").getAsJsonArray()){

            @Override
            protected TimelineEvent basicGet(JsonArray array, int index) {
                return new TimelineEvent(array.get(index).getAsJsonObject());
            }
        };
    }

    public long getTimestamp() {
        return this.json.get("timestamp") == null ? -1L : this.json.get("timestamp").getAsLong();
    }

    public Frame getTopFrame() {
        return this.json.get("topFrame") == null ? null : new Frame((JsonObject)this.json.get("topFrame"));
    }

    public VMRef getVm() {
        return this.json.get("vm") == null ? null : new VMRef((JsonObject)this.json.get("vm"));
    }
}

