/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutlineAttribute;

public class FlutterOutline {
    public static final FlutterOutline[] EMPTY_ARRAY = new FlutterOutline[0];
    public static final List<FlutterOutline> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final int offset;
    private final int length;
    private final String label;
    private final Element dartElement;
    private final List<FlutterOutlineAttribute> attributes;
    private final String className;
    private final String parentAssociationLabel;
    private final String variableName;
    private final List<FlutterOutline> children;
    private final Integer id;
    private final boolean isWidgetClass;
    private final String renderConstructor;
    private final String stateClassName;
    private final Integer stateOffset;
    private final Integer stateLength;

    public FlutterOutline(String kind, int offset, int length, int codeOffset, int codeLength, String label, Element dartElement, List<FlutterOutlineAttribute> attributes, String className, String parentAssociationLabel, String variableName, List<FlutterOutline> children, Integer id, boolean isWidgetClass, String renderConstructor, String stateClassName, Integer stateOffset, Integer stateLength) {
        this.kind = kind;
        this.offset = offset;
        this.length = length;
        this.label = label;
        this.dartElement = dartElement;
        this.attributes = attributes;
        this.className = className;
        this.parentAssociationLabel = parentAssociationLabel;
        this.variableName = variableName;
        this.children = children;
        this.id = id;
        this.isWidgetClass = isWidgetClass;
        this.renderConstructor = renderConstructor;
        this.stateClassName = stateClassName;
        this.stateOffset = stateOffset;
        this.stateLength = stateLength;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterOutline) {
            FlutterOutline other = (FlutterOutline)obj;
            return ObjectUtilities.equals((Object)other.kind, (Object)this.kind) && other.offset == this.offset && other.length == this.length && ObjectUtilities.equals((Object)other.label, (Object)this.label) && ObjectUtilities.equals((Object)other.dartElement, (Object)this.dartElement) && ObjectUtilities.equals(other.attributes, this.attributes) && ObjectUtilities.equals((Object)other.className, (Object)this.className) && ObjectUtilities.equals((Object)other.parentAssociationLabel, (Object)this.parentAssociationLabel) && ObjectUtilities.equals((Object)other.variableName, (Object)this.variableName) && ObjectUtilities.equals(other.children, this.children) && ObjectUtilities.equals((Object)other.id, (Object)this.id) && ObjectUtilities.equals((Object)other.isWidgetClass, (Object)this.isWidgetClass) && ObjectUtilities.equals((Object)other.renderConstructor, (Object)this.renderConstructor) && ObjectUtilities.equals((Object)other.stateClassName, (Object)this.stateClassName) && ObjectUtilities.equals((Object)other.stateOffset, (Object)this.stateOffset) && ObjectUtilities.equals((Object)other.stateLength, (Object)this.stateLength);
        }
        return false;
    }

    public static FlutterOutline fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        int codeOffset = jsonObject.get("codeOffset") == null ? 0 : jsonObject.get("codeOffset").getAsInt();
        int codeLength = jsonObject.get("codeLength") == null ? 0 : jsonObject.get("codeLength").getAsInt();
        String label = jsonObject.get("label") == null ? null : jsonObject.get("label").getAsString();
        Element dartElement = jsonObject.get("dartElement") == null ? null : Element.fromJson((JsonObject)jsonObject.get("dartElement").getAsJsonObject());
        List<FlutterOutlineAttribute> attributes = jsonObject.get("attributes") == null ? null : FlutterOutlineAttribute.fromJsonArray(jsonObject.get("attributes").getAsJsonArray());
        String className = jsonObject.get("className") == null ? null : jsonObject.get("className").getAsString();
        String parentAssociationLabel = jsonObject.get("parentAssociationLabel") == null ? null : jsonObject.get("parentAssociationLabel").getAsString();
        String variableName = jsonObject.get("variableName") == null ? null : jsonObject.get("variableName").getAsString();
        List<FlutterOutline> children = jsonObject.get("children") == null ? null : FlutterOutline.fromJsonArray(jsonObject.get("children").getAsJsonArray());
        Integer id = jsonObject.get("id") == null ? null : Integer.valueOf(jsonObject.get("id").getAsInt());
        boolean isWidgetClass = jsonObject.get("isWidgetClass") == null ? false : jsonObject.get("isWidgetClass").getAsBoolean();
        String renderConstructor = jsonObject.get("renderConstructor") == null ? null : jsonObject.get("renderConstructor").getAsString();
        String stateClassName = jsonObject.get("stateClassName") == null ? null : jsonObject.get("stateClassName").getAsString();
        Integer stateOffset = jsonObject.get("stateOffset") == null ? null : Integer.valueOf(jsonObject.get("stateOffset").getAsInt());
        Integer stateLength = jsonObject.get("stateLength") == null ? null : Integer.valueOf(jsonObject.get("stateLength").getAsInt());
        return new FlutterOutline(kind, offset, length, codeOffset, codeLength, label, dartElement, attributes, className, parentAssociationLabel, variableName, children, id, isWidgetClass, renderConstructor, stateClassName, stateOffset, stateLength);
    }

    public static List<FlutterOutline> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterOutline> list = new ArrayList<FlutterOutline>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterOutline.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<FlutterOutlineAttribute> getAttributes() {
        return this.attributes;
    }

    public List<FlutterOutline> getChildren() {
        return this.children;
    }

    public String getClassName() {
        return this.className;
    }

    public Element getDartElement() {
        return this.dartElement;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isWidgetClass() {
        return this.isWidgetClass;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getParentAssociationLabel() {
        return this.parentAssociationLabel;
    }

    public String getRenderConstructor() {
        return this.renderConstructor;
    }

    public String getStateClassName() {
        return this.stateClassName;
    }

    public Integer getStateLength() {
        return this.stateLength;
    }

    public Integer getStateOffset() {
        return this.stateOffset;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int hashCode() {
        return this.offset;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        if (this.label != null) {
            jsonObject.addProperty("label", this.label);
        }
        if (this.dartElement != null) {
            jsonObject.add("dartElement", (JsonElement)this.dartElement.toJson());
        }
        if (this.attributes != null) {
            JsonArray jsonArrayAttributes = new JsonArray();
            for (FlutterOutlineAttribute flutterOutlineAttribute : this.attributes) {
                jsonArrayAttributes.add((JsonElement)flutterOutlineAttribute.toJson());
            }
            jsonObject.add("attributes", (JsonElement)jsonArrayAttributes);
        }
        if (this.className != null) {
            jsonObject.addProperty("className", this.className);
        }
        if (this.parentAssociationLabel != null) {
            jsonObject.addProperty("parentAssociationLabel", this.parentAssociationLabel);
        }
        if (this.variableName != null) {
            jsonObject.addProperty("variableName", this.variableName);
        }
        if (this.children != null) {
            JsonArray jsonArrayChildren = new JsonArray();
            for (FlutterOutline flutterOutline : this.children) {
                jsonArrayChildren.add((JsonElement)flutterOutline.toJson());
            }
            jsonObject.add("children", (JsonElement)jsonArrayChildren);
        }
        if (this.id != null) {
            jsonObject.addProperty("id", (Number)this.id);
        }
        jsonObject.addProperty("isWidgetClass", Boolean.valueOf(this.isWidgetClass));
        if (this.renderConstructor != null) {
            jsonObject.addProperty("renderConstructor", this.renderConstructor);
        }
        if (this.stateClassName != null) {
            jsonObject.addProperty("stateClassName", this.stateClassName);
        }
        if (this.stateOffset != null) {
            jsonObject.addProperty("stateOffset", (Number)this.stateOffset);
        }
        if (this.stateLength != null) {
            jsonObject.addProperty("stateLength", (Number)this.stateLength);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("label=");
        builder.append(this.label + ", ");
        builder.append("dartElement=");
        builder.append(this.dartElement + ", ");
        if (this.attributes != null) {
            builder.append("attributes=");
            builder.append(Joiner.on((String)", ").join(this.attributes) + ", ");
        }
        builder.append("className=");
        builder.append(this.className + ", ");
        builder.append("parentAssociationLabel=");
        builder.append(this.parentAssociationLabel + ", ");
        builder.append("variableName=");
        builder.append(this.variableName + ", ");
        if (this.children != null) {
            builder.append("children=");
            builder.append(Joiner.on((String)", ").join(this.children) + ", ");
        }
        builder.append("id=");
        builder.append("isWidgetClass=");
        builder.append(this.isWidgetClass + ", ");
        builder.append(this.id + ", ");
        builder.append("renderConstructor=");
        builder.append(this.renderConstructor + ", ");
        builder.append("stateClassName=");
        builder.append(this.stateClassName + ", ");
        builder.append("stateOffset=");
        builder.append(this.stateOffset + ", ");
        builder.append("stateLength=");
        builder.append(this.stateLength);
        builder.append("]");
        return builder.toString();
    }
}

