/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.frame.DartStaticFieldsGroup;
import io.flutter.vmService.frame.DartVmServiceEvaluatorInFrame;
import io.flutter.vmService.frame.DartVmServiceValue;
import java.util.List;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.BoundVariable;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceStackFrame
extends XStackFrame {
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final Frame myVmFrame;
    @Nullable
    private final InstanceRef myException;
    @Nullable
    private final XSourcePosition mySourcePosition;
    @Nullable
    private final List<Frame> myVmFrames;
    private boolean myIsDroppableFrame;

    public DartVmServiceStackFrame(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull Frame vmFrame, @Nullable List<Frame> vmFrames, @Nullable InstanceRef exception) {
        if (debugProcess == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(0);
        }
        if (isolateId == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(1);
        }
        if (vmFrame == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(2);
        }
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myVmFrame = vmFrame;
        this.myVmFrames = vmFrames;
        this.myException = exception;
        this.mySourcePosition = vmFrame.getLocation() == null ? null : debugProcess.getSourcePosition(isolateId, vmFrame.getLocation().getScript(), vmFrame.getLocation().getTokenPos());
    }

    @NotNull
    public String getIsolateId() {
        String string = this.myIsolateId;
        if (string == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public int getFrameIndex() {
        return this.myVmFrames == null ? 0 : this.myVmFrames.indexOf(this.myVmFrame);
    }

    public void setIsDroppableFrame(boolean value) {
        this.myIsDroppableFrame = value;
    }

    private boolean isLastFrame() {
        if (this.myVmFrames == null) {
            return true;
        }
        return this.getFrameIndex() == this.myVmFrames.size() - 1;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(4);
        }
        String unoptimizedPrefix = "[Unoptimized] ";
        String name = StringUtil.trimEnd((String)this.myVmFrame.getCode().getName(), (String)"=");
        name = StringUtil.trimStart((String)name, (String)"[Unoptimized] ");
        boolean causal = this.myVmFrame.getKind() == FrameKind.AsyncCausal;
        component.append(name, causal ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.mySourcePosition != null) {
            String text = " (" + this.mySourcePosition.getFile().getName() + ":" + (this.mySourcePosition.getLine() + 1) + ")";
            component.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        component.setIcon(AllIcons.Debugger.Frame);
    }

    @NotNull
    public Object getEqualityObject() {
        String string = this.myVmFrame.getLocation().getScript().getId() + ":" + this.myVmFrame.getCode().getId();
        if (string == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        ElementList<BoundVariable> vars;
        if (node == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(6);
        }
        if (this.myException != null) {
            DartVmServiceValue exception = new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, "exception", this.myException, null, null, true);
            node.addChildren(XValueChildrenList.singleton((XNamedValue)exception), false);
        }
        if ((vars = this.myVmFrame.getVars()) == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        BoundVariable thisVar = null;
        for (BoundVariable var : vars) {
            if (!"this".equals(var.getName())) continue;
            thisVar = var;
            break;
        }
        this.addStaticFieldsIfPresentAndThenAllVars(node, thisVar, vars);
    }

    private void addStaticFieldsIfPresentAndThenAllVars(final @NotNull XCompositeNode node, @Nullable BoundVariable thisVar, final @NotNull ElementList<BoundVariable> vars) {
        if (node == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(7);
        }
        if (vars == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(8);
        }
        if (thisVar == null) {
            this.addVars(node, vars);
            return;
        }
        Object thisVarValue = thisVar.getValue();
        if (!(thisVarValue instanceof InstanceRef)) {
            this.addVars(node, vars);
            return;
        }
        ClassRef classRef = ((InstanceRef)thisVarValue).getClassRef();
        this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, classRef.getId(), new GetObjectConsumer(){

            @Override
            public void received(Obj classObj) {
                SmartList staticFields = new SmartList();
                for (FieldRef fieldRef : ((ClassObj)classObj).getFields()) {
                    if (!fieldRef.isStatic()) continue;
                    staticFields.add((Object)fieldRef);
                }
                if (!staticFields.isEmpty()) {
                    XValueChildrenList list = new XValueChildrenList();
                    list.addTopGroup((XValueGroup)new DartStaticFieldsGroup(DartVmServiceStackFrame.this.myDebugProcess, DartVmServiceStackFrame.this.myIsolateId, ((ClassObj)classObj).getName(), (SmartList<FieldRef>)staticFields));
                    node.addChildren(list, false);
                }
                DartVmServiceStackFrame.this.addVars(node, vars);
            }

            @Override
            public void received(Sentinel sentinel) {
                node.setErrorMessage(sentinel.getValueAsString());
            }

            @Override
            public void onError(RPCError error) {
                node.setErrorMessage(error.getMessage());
            }
        });
    }

    private void addVars(@NotNull XCompositeNode node, @NotNull ElementList<BoundVariable> vars) {
        if (node == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(9);
        }
        if (vars == null) {
            DartVmServiceStackFrame.$$$reportNull$$$0(10);
        }
        XValueChildrenList childrenList = new XValueChildrenList(vars.size());
        for (BoundVariable var : vars) {
            Object value = var.getValue();
            if (!(value instanceof InstanceRef)) continue;
            InstanceRef instanceRef = (InstanceRef)value;
            DartVmServiceValue.LocalVarSourceLocation varLocation = "this".equals(var.getName()) ? null : new DartVmServiceValue.LocalVarSourceLocation(this.myVmFrame.getLocation().getScript(), var.getDeclarationTokenPos());
            childrenList.add((XNamedValue)new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, var.getName(), instanceRef, varLocation, null, false));
        }
        node.addChildren(childrenList, true);
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return new DartVmServiceEvaluatorInFrame(this.myDebugProcess, this.myIsolateId, this.myVmFrame);
    }

    public boolean isInDartSdkPatchFile() {
        return this.mySourcePosition != null && this.mySourcePosition.getFile() instanceof LightVirtualFile;
    }

    public boolean canDrop() {
        return this.myIsDroppableFrame && !this.isLastFrame();
    }

    public void dropFrame() {
        this.myDebugProcess.dropFrame(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmFrame";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/frame/DartVmServiceStackFrame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/frame/DartVmServiceStackFrame";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsolateId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStaticFieldsIfPresentAndThenAllVars";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addVars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

